package org.phosphoresce.commons.util;

/**
 * 真偽値に対する操作を行うメソッドを提供するクラス<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2007/02/21	Kitagawa		新規作成
 *-->
 */
public final class BooleanUtil {

	/** 真偽値 : 真文字列 */
	public static String TRUE = "true";

	/** 真偽値 : 偽文字列 */
	public static String FALSE = "false";

	/** 真偽値 : 真文字 */
	public static String TRUE_1 = "1";

	/** 真偽値 : 偽文字 */
	public static String FALSE_0 = "0";

	/**
	 * コンストラクタ<br>
	 */
	private BooleanUtil() {
		//
	}

	/**
	 * 指定された文字列をboolean型に変換して提供します。<br>
	 * @param value 変換対象真偽値文字列
	 * @return 変換したboolean変数
	 */
	public static boolean parseBooleanValue(String value) {
		if (StringUtil.isEmpty(value)) {
			return false;
		} else {
			return TRUE.toUpperCase().equals(value.toUpperCase()) //
					|| TRUE_1.toUpperCase().equals(value.toUpperCase());
		}
	}

	/**
	 * 指定された文字列をBooleanオブジェクトに変換して提供します。<br>
	 * @param value 変換対象真偽値文字列
	 * @return 変換したBooleanオブジェクト
	 */
	public static Boolean parseBoolean(String value) {
		return new Boolean(parseBooleanValue(value));
	}
}

