package org.phosphoresce.commons.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;

/**
 * ビーンオブジェクトに対する操作を行うメソッドを提供するクラス<br>
 *
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2009/11/20	Kitagawa		新規作成
 *-->
 */
public final class BeanUtil {

	/**
	 * コンストラクタ<br>
	 */
	private BeanUtil() {
		super();
	}

	/**
	 * スネーク表記で保持されているマップオブジェクトからキャメル表記フィールドを持った
	 * ビーンオブジェクトにプロパティコピーを行います。<br>
	 * @param destination 設定対象ビーンオブジェクト
	 * @param source スネーク表記で情報を保持するマップオブジェクト
	 * @throws IllegalAccessException ビーンオブジェクトに対してフィールドアクセスに失敗した場合にスローされます
	 * @throws InvocationTargetException ビーンオブジェクトのアクセッサメソッド使用に失敗した場合にスローされます
	 */
	public static void copyPropertiesSnakeToCamel(Object destination, Map source) throws IllegalAccessException, InvocationTargetException {
		if (destination == null || source == null) {
			return;
		}
		Map map = new HashMap();
		for (Iterator iterator = source.keySet().iterator(); iterator.hasNext();) {
			String key = (String) iterator.next();
			map.put(StringUtil.toLowerCamelCase(key), source.get(key));
		}
		BeanUtils.copyProperties(destination, map);
	}
}
