package org.phosphoresce.commons.html.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

import javax.swing.text.html.parser.ParserDelegator;

import org.phosphoresce.commons.html.HTMLDocumentElement;
import org.phosphoresce.commons.util.StringUtil;

/**
 * HTMLドキュメントパースユーティリティクラス<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/19	Kitagawa		新規作成
 *-->
 */
public final class HTMLDocumentParserUtil {

	/**
	 * コンストラクタ<br>
	 */
	private HTMLDocumentParserUtil() {
		super();
	}

	/**
	 * 指定されたHTMLコンテンツをパースします。<br>
	 * @param content HTMLコンテンツ
	 * @return HTMLドキュメントエレメント
	 */
	public static HTMLDocumentElement parseDocument(String content) {
		if (StringUtil.isEmpty(content) || StringUtil.isEmpty(content.trim())) {
			return new HTMLDocumentElement();
		}
		Reader reader = new InputStreamReader(new ByteArrayInputStream(content.toString().getBytes()));
		HTMLDocumentParserCallbak callbak = new HTMLDocumentParserCallbak();
		ParserDelegator delegator = new ParserDelegator();
		try {
			delegator.parse(reader, callbak, true);
		} catch (IOException e) {
			// 文字列ストリームであるため例外は発生しない想定
		}
		return callbak.getDocument();
	}
}

