package org.phosphoresce.commons.html;


/**
 * HTMLテキストエレメントクラス<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/19	Kitagawa		新規作成
 *-->
 */
public class HTMLTextElement extends HTMLElement {

	/** テキスト */
	private String text;

	/**
	 * コンストラクタ<br>
	 */
	public HTMLTextElement() {
		super();
		this.text = null;
	}

	/**
	 * コンストラクタ<br>
	 * @param text テキスト
	 */
	public HTMLTextElement(String text) {
		super();
		this.text = text;
	}

	/**
	 * エレメントが子エレメントの操作をサポートしているか判定します。<br>
	 * @return HTMLTextは子エレメントをサポートしないためfalseを返却
	 * @see org.phosphoresce.commons.html.HTMLElement#isSupportChild()
	 */
	public boolean isSupportChild() {
		return false;
	}

	/**
	 * テキストを取得します。<br>
	 * @return テキスト
	 */
	public String getText() {
		return text;
	}

	/**
	 * テキストを設定します。<br>
	 * @param text テキスト
	 */
	public void setText(String text) {
		this.text = text;
	}

	/**
	 * オブジェクトの文字列表現を返します。<br>
	 * @return オブジェクトの文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("text=");
		buffer.append(text);
		buffer.append("}");
		return buffer.toString();
	}
}

