package org.phosphoresce.common.graphics.test;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

import org.phosphoresce.common.graphics.paint.util.GradientPaintUtil;

/**
 * テストフレーム<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/06/09	Kitagawa		新規作成
 *-->
 */
public class TestFrame extends JFrame {

	/** コンテンツパネル */
	private JPanel content = null;

	/** グラデーションペイントテストフレーム01 */
	private JPanel gradientPaintFrame01 = null;

	/** グロッシーペイントテストパネル01 */
	private PaintTestPanel glossyGradientPaintTestPanel01 = null;

	/** グラデーションペイントテストフレーム02 */
	private JPanel gradientPaintFrame02 = null;

	/** グロッシーペイントテストパネル02 */
	private PaintTestPanel glossyGradientPaintTestPanel02 = null;

	/**
	 * メインメソッド<br>
	 * @param args コマンドライン引数
	 * @throws Throwable 予期せぬ例外が発生した場合にスローされます
	 */
	public static void main(String[] args) throws Throwable {
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		TestFrame frame = new TestFrame();
		frame.setVisible(true);
	}

	/**
	 * コンストラクタ<br>
	 */
	public TestFrame() {
		super();
		initialize();
	}

	/**
	 * コンポーネントを初期化します。<br>
	 */
	private void initialize() {
		this.setSize(768, 399);
		this.setContentPane(getContent());
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setTitle("org.phosphoresce.common.graphics.paint");
	}

	/**
	 * コンテンツパネルを取得します。<br>
	 * @return コンテンツパネル
	 */
	private JPanel getContent() {
		if (content == null) {
			content = new JPanel();
			content.setLayout(null);
			content.add(getGradientPaintFrame01(), null);
			content.add(getGradientPaintFrame02(), null);
		}
		return content;
	}

	/**
	 * グラデーションペイントテストフレーム01を取得します。<br>
	 * @return グラデーションペイントテストフレーム01
	 */
	private JPanel getGradientPaintFrame01() {
		if (gradientPaintFrame01 == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 0;
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.weightx = 1.0D;
			gridBagConstraints.weighty = 1.0D;
			gridBagConstraints.gridy = 0;
			gradientPaintFrame01 = new JPanel();
			gradientPaintFrame01.setLayout(new GridBagLayout());
			gradientPaintFrame01.setBounds(new Rectangle(20, 17, 120, 100));
			gradientPaintFrame01.setBorder(BorderFactory.createTitledBorder(null, "Gradation Paint", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font(
					"MS Sans Serif", Font.PLAIN, 11), Color.black));
			gradientPaintFrame01.add(getGlossyGradientPaintTestPanel01(), gridBagConstraints);
		}
		return gradientPaintFrame01;
	}

	/**
	 * グロッシーペイントテストパネル01を取得します。<br>
	 * @return グロッシーペイントテストパネル01
	 */
	private PaintTestPanel getGlossyGradientPaintTestPanel01() {
		if (glossyGradientPaintTestPanel01 == null) {
			glossyGradientPaintTestPanel01 = new PaintTestPanel();
			glossyGradientPaintTestPanel01.setPaint(GradientPaintUtil.createGlossyLinearGradientPaint(new Color(255, 255, 255)));
		}
		return glossyGradientPaintTestPanel01;
	}

	/**
	 * グラデーションペイントテストフレーム02を取得します。<br>
	 * @return グラデーションペイントテストフレーム02
	 */
	private JPanel getGradientPaintFrame02() {
		if (gradientPaintFrame02 == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 0;
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.weightx = 1.0D;
			gridBagConstraints.weighty = 1.0D;
			gridBagConstraints.gridy = 0;
			gradientPaintFrame02 = new JPanel();
			gradientPaintFrame02.setLayout(new GridBagLayout());
			gradientPaintFrame02.setBounds(new Rectangle(180, 17, 120, 100));
			gradientPaintFrame02.setBorder(BorderFactory.createTitledBorder(null, "Gradation Paint", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font(
					"MS Sans Serif", Font.PLAIN, 11), Color.black));
			gradientPaintFrame02.add(getGlossyGradientPaintTestPanel02(), gridBagConstraints);
		}
		return gradientPaintFrame02;
	}

	/**
	 * グロッシーペイントテストパネル02を取得します。<br>
	 * @return グロッシーペイントテストパネル02
	 */
	private PaintTestPanel getGlossyGradientPaintTestPanel02() {
		if (glossyGradientPaintTestPanel02 == null) {
			glossyGradientPaintTestPanel02 = new PaintTestPanel();
			glossyGradientPaintTestPanel02.setPaint(GradientPaintUtil.createSimpleRadialGradientPaint(new Color(0, 0, 0), new Color(255, 255, 255)));
		}
		return glossyGradientPaintTestPanel02;
	}
}
