package org.phosphoresce.common.graphics.util;

import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.ImageIcon;

/**
 * イメージ関連ユーティリティクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/06/02	Kitagawa		新規作成
 *-->
 */
public final class ImageUtil {

	/**
	 * コンストラクタ<br>
	 */
	private ImageUtil() {
		super();
	}

	/**
	 * 指定されたイメージのサイズを取得します。<br>
	 * @param image イメージコンポーネント
	 * @return イメージサイズ
	 */
	public static Dimension getImageSize(Image image) {
		if (image == null) {
			return new Dimension(0, 0);
		} else {
			Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
			return dimension;
		}
	}

	/**
	 * 指定されたリソースパスからImageIconを取得します。<br>
	 * 当メソッドはクラスリソース、システムファイルの順で検索を行います。<br>
	 * @param path リソースパス
	 * @return ImageIconオブジェクト
	 */
	public static ImageIcon getImageIcon(String path) {
		URL url = null;

		url = ImageUtil.class.getResource(path);
		if (url == null) {
			File file = new File(path);
			if (file.exists() && file.isFile()) {
				try {
					url = new URL("file://" + path);
				} catch (MalformedURLException e) {
					// プロトコル固定のため、無視
				}
			}
		}

		if (url == null) {
			return null;
		} else {
			return new ImageIcon(url);
		}
	}

	/**
	 * 指定されたリソースパスからImageを取得します。<br>
	 * 当メソッドはクラスリソース、システムファイルの順で検索を行います。<br>
	 * @param path リソースパス
	 * @return Imageオブジェクト
	 */
	public static Image getImage(String path) {
		return getImageIcon(path).getImage();
	}
}
