package org.phosphoresce.common.graphics.paint;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

/**
 * 線形グラデーションペイントクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/06/08	Kitagawa		新規作成
 *-->
 */
public class LinearGradientPaint extends AbstractGradientPaint {

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 * @param alphaDefine グラデーションアルファ定義
	 * @param angle 角度
	 * @param smoothness 滑らかさ(0.0f～1.0f)
	 * @param ratio 比率(0.0f～100.0f)
	 */
	public LinearGradientPaint(GradientColorDefine colorDefine, GradientAlphaDefine alphaDefine, double angle, float smoothness, float ratio) {
		super(colorDefine, alphaDefine, angle, smoothness, ratio);
	}

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 * @param alphaDefine グラデーションアルファ定義
	 * @param angle 角度
	 */
	public LinearGradientPaint(GradientColorDefine colorDefine, GradientAlphaDefine alphaDefine, double angle) {
		this(colorDefine, alphaDefine, angle, DEFAULT_SMOOTHNESS, DEFAULT_RAITO);
	}

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 * @param angle 角度
	 * @param smoothness 滑らかさ(0.0f～1.0f)
	 * @param ratio 比率(0.0f～100.0f)
	 */
	public LinearGradientPaint(GradientColorDefine colorDefine, double angle, float smoothness, float ratio) {
		this(colorDefine, null, angle, smoothness, ratio);
	}

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 * @param angle 角度
	 */
	public LinearGradientPaint(GradientColorDefine colorDefine, double angle) {
		this(colorDefine, null, angle, DEFAULT_SMOOTHNESS, DEFAULT_RAITO);
	}

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 */
	public LinearGradientPaint(GradientColorDefine colorDefine) {
		this(colorDefine, null, DEFAULT_ANGLE, DEFAULT_SMOOTHNESS, DEFAULT_RAITO);
	}

	/**
	 * カラーパターンを生成するために使用するPaintContextを生成します。<br>
	 * @param model Paintデータを受け取るColorModelオブジェクト
	 * @param deviceBounds 描画されるグラフィックスプリミティブのデバイス空間でのバウンディングボックス
	 * @param userBounds 描画されるグラフィックスプリミティブのユーザ空間でのバウンディングボックス
	 * @param transform ユーザ空間からデバイス空間へのAffineTransform
	 * @param hints コンテキストオブジェクトが描画の選択肢を選択するときに使用するヒント
	 * @return PaintContextオブジェクト
	 * @see java.awt.Paint#createContext(java.awt.image.ColorModel, java.awt.Rectangle, java.awt.geom.Rectangle2D, java.awt.geom.AffineTransform, java.awt.RenderingHints)
	 */
	public PaintContext createContext(ColorModel model, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints) {
		return new LinearGradientPaintContext(model, deviceBounds, userBounds, transform, hints, getAngle(), getColorDefine(), getAlphaDefine(), getSmoothness(), getRatio());
	}
}
