package org.phosphoresce.common.graphics.paint;

import java.awt.Color;
import java.util.List;

/**
 * グラデーションカラー定義クラス<br>
 * 当クラスが保持するカラーオブジェクトは透明度を提供しません。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/06/08	Kitagawa		新規作成
 *-->
 */
public class GradientColorDefine extends GradientDefine {

	/** カラー */
	private Color color;

	/**
	 * コンストラクタ<br>
	 * @param color カラー
	 * @param location 位置
	 * @param behindDivergence 後方分岐ポイント
	 * @param frontDivergence 前方分岐ポイント
	 */
	public GradientColorDefine(Color color, float location, float behindDivergence, float frontDivergence) {
		super(location, behindDivergence, frontDivergence);
		this.setColor(color);
	}

	/**
	 * コンストラクタ<br>
	 * @param color カラー
	 * @param location 位置
	 */
	public GradientColorDefine(Color color, float location) {
		this(color, location, 0.5f, 0.5f);
	}

	/**
	 * コンストラクタ<br>
	 */
	private GradientColorDefine() {
		this(Color.BLACK, 0.0f, 0.5f, 0.5f);
	}

	/**
	 * グラデーション定義が提供するカラーを取得します。<br>
	 * @return グラデーション定義が提供するカラー
	 * @see org.phosphoresce.common.graphics.paint.GradientDefine#getGradientColor()
	 */
	public Color getGradientColor() {
		return getColor();
	}

	/**
	 * 全てのグラデーションカラー定義を取得します。<br>
	 * @return 全てのグラデーションカラー定義
	 * @see org.phosphoresce.common.graphics.paint.GradientDefine#getAllDefines()
	 */
	public GradientDefine[] getAllDefines() {
		List list = getAllDefineList();
		return (GradientColorDefine[]) list.toArray(new GradientColorDefine[list.size()]);
	}

	/**
	 * カラーを取得します。<br>
	 * @return カラー
	 */
	public Color getColor() {
		return color;
	}

	/**
	 * カラーを設定します。<br>
	 * @param color カラー
	 */
	public void setColor(Color color) {
		this.color = color;
		if (this.color == null) {
			this.color = Color.BLACK;
		}
		this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 255);
	}

	/**
	 * ディフォルトグラデーションカラー定義を生成します。<br>
	 * @return ディフォルトグラデーションカラー定義
	 */
	public static GradientColorDefine createDefaultGradientColorDefine() {
		GradientColorDefine point1 = new GradientColorDefine();
		GradientColorDefine point2 = new GradientColorDefine();
		point1.color = Color.BLACK;
		point1.location = 0.0f;
		point2.color = Color.WHITE;
		point2.location = 1.0f;
		point1.add(point2);
		return point1;
	}
}
