package naru.phantom.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Date;

import org.apache.log4j.Logger;

import naru.async.ChannelHandler;
import naru.async.pool.BuffersUtil;
import naru.async.pool.PoolManager;
import naru.async.store.Store;
import naru.phantom.AccessLog;
import naru.phantom.Dispatcher;
import naru.phantom.ServerBaseHandler;
import naru.phantom.admin.Setting;
import naru.phantom.util.HeaderParser;
import naru.phantom.util.ParameterParser;

/**
 * HTTPvgR{ɁAɃX|XnhOB
 * HTTPvgR̃XL[ɓȂvgRnhOꍇɂ́A
 * onRead\bhI[o[Ch
 * @author Naru
 *
 */
public class WebServerHandler extends ServerBaseHandler {
	/* Ŏw肵́AVelocityev[gQƂł */
	public static final String CONTENT_ENCODING_GZIP="gzip";
	
	public static final String ENCODE="ISO8859_1";
	private static final String WRITE_CONTEXT_BODY="writeContextBody";
	private static final String WRITE_CONTEXT_BODY_INTERNAL="writeContextBodyInternal";
	private static final String WRITE_CONTEXT_HEADER="writeContextHeader";
	private static final String WRITE_CONTEXT_LAST_HEADER="writeContextLastHeader";

	private static Logger logger = Logger.getLogger(WebServerHandler.class);
	private static Setting config=Setting.getInstance();
	private HeaderParser responseHeader=new HeaderParser();
	private long requestContentLength;
	private long requestReadBody;
	
	private long responseHeaderLength;//X|Xwb_
	private long responseContentLengthApl;//AvP[V,content-lengthwb_Ŏw肵contentLength
	private long responseWriteBodyApl;//ۂapl烌X|X˗ꂽbody
	private long responseWriteBody;//ۂɃX|Xbody
	
	private boolean isFlushFirstResponse;
	private ByteBuffer[] firstBody;
	private boolean isResponseEnd;
//	private GzipContext gzipContext;
	
//	private KeepAliveContext keepAliveContext;/* firstFlush  endOfResponsetrue𕜋A܂ŗL */
	
	public void recycle(){
		requestContentLength=requestReadBody=0;
		responseWriteBody=responseHeaderLength=responseWriteBodyApl=responseContentLengthApl=0;
		responseHeader.recycle();
		responseBodyStream=null;
		responseBodyWriter=null;
		isFlushFirstResponse=false;
		isResponseEnd=false;//ȓ̂poolɂ邤trueɂEEE
		firstBody=null;
//		gzipContext=null;
		super.recycle();
	}
	
	/**
	 * proxyreverse proxy̎AobNT[oԋpbufferp[X邽߂̃\bh
	 * ̂܂܁AuEŨX|XɗpłB
	 * @param buffers
	 * @return
	 */
	public final boolean parseResponseHeader(ByteBuffer[] buffers){
		for(int i=0;i<buffers.length;i++){
			responseHeader.parse(buffers[i]);
		}
		return responseHeader.isParseEnd();
	}
	
	public final boolean isReponseParseError(){
		return responseHeader.isParseError();
	}
	
	public final void setStatusCode(String statusCode) {
		responseHeader.setStatusCode(statusCode);
	}
	
	public final String getStatusCode() {
		return responseHeader.getStatusCode();
	}
	
	public final void setHttpVersion(String httpVersion) {
		responseHeader.setResHttpVersion(httpVersion);
	}
	
	public final void setHeader(String name, String value) {
		responseHeader.setHeader(name,value);
	}
	
	public final void removeHeader(String name) {
		responseHeader.removeHeader(name);
	}
	
	public final void setContentLength(long contentLength) {
		responseHeader.setContentLength(contentLength);
	}
	
	public final String getHeader(String name) {
		return responseHeader.getHeader(name);
	}
	
	public final void setNoCacheResponseHeaders(){
		responseHeader.setHeader("Pragma","no-cache");
		responseHeader.setHeader("Cache-Control","no-cache");
		responseHeader.setHeader("Expires","Thu, 01 Dec 1994 16:00:00 GMT");
	}
	
	public final void setResponseHeader(HeaderParser header){
		responseHeader.setStatusCode(header.getStatusCode(),header.getReasonPhrase());
		responseHeader.setResHttpVersion(header.getResHttpVersion());
		responseHeader.setAllHeaders(header);
	}
	
	public void setTimeCheckPint(int index){
		AccessLog accessLog=getAccessLog();
		if(accessLog!=null){
			accessLog.setTimeCheckPint(index);
		}
	}
	
	/**
	 * {fB̉͏Jn܂B
	 * doResponseĂяoɂ́AreadvoĂȂ̂ŁAقĂbody͓ȂB
	 */
	public final void startParseRequestBody(){
		HeaderParser requestHeader=getRequestHeader();
		requestReadBody=0;
		requestContentLength=requestHeader.getContentLength();
		
		ParameterParser parameterParser=getParameterParser();
		parameterParser.init(requestHeader.getMethod(),requestHeader.getContentType(), requestContentLength);
		String query=requestHeader.getQuery();
		if(query!=null&&!"".equals(query)){
			parameterParser.parseQuery(query);
		}
		if(requestContentLength<=0){//GET̂悤ȏꍇbody͂Ȃ
			setTimeCheckPint(AccessLog.TIMEPOINT_requestBodyEnd);
			startResponseReqBody();//p^ǂݍ݊ʒm
			return;
		}
		ByteBuffer[] body=requestHeader.getBodyBuffer();
		//bodýAK̃IuWFNgread\bhʉ߂Bnullł̒asyncReadôŕKv
		onReadPlain(null,body);
	}
	
	/**
	 * ƎɃX|XԋpĺÃ\bhI[oCh
	 * ̃\bhĂяo_ł́Awb_͎ɓǂݍł܂bodyrequestHeaderɎcĂ_ɒ
	 * startParseBody\bhł́A̕ɂĖIonReadPlain\bhĂяoB
	 * @param requestParser
	 */
	public void startResponse(){
		startParseRequestBody();
	}
	
	/**
	 * NGXgbodyl͂̃\bhI[oChĎg
	 * ftHgł́AparameterƂĉ͂鏈
	 * @param buffers
	 */
	public void requestBody(ByteBuffer[] buffers){
		ParameterParser parameterParser=getParameterParser();
		for(int i=0;i<buffers.length;i++){
			parameterParser.parse(buffers[i]);
		}
	}
	
	/**
	 * NGXgf[^ʒmʒm
	 * p^҂ďl͂̃\bhI[oChĎg
	 * @param buffers
	 */
	public void startResponseReqBody(){
	}
	
	/**
	 * ̃\bhĂԂƕKX|XAύXƂȂ̂final
	 * @param requestParser
	 * @param statusCode
	 */
	public final void doneResponse(String statusCode){
		doneResponse(statusCode,(ByteBuffer)null);
	}
	
	/**
	 * ̃\bhĂԂƕKX|XAύXƂȂ̂final
	 * @param requestParser
	 * @param statusCode
	 */
	public final void doneResponse(String statusCode,String body){
		try {
			doneResponse(statusCode,body.getBytes(ENCODE));
		} catch (UnsupportedEncodingException e) {
			logger.error("fail to getBytes().",e);
		}
	}
	
	/**
	 * ̃\bhĂԂƕKX|XAύXƂȂ̂final
	 * @param requestParser
	 * @param statusCode
	 */
	public final void doneResponse(String statusCode,byte[] body){
		doneResponse(statusCode,ByteBuffer.wrap(body));
	}
	
	/**
	 * ̃\bhĂԂƕKX|XAύXƂȂ̂final
	 * @param requestParser
	 * @param statusCode
	 */
	public final void doneResponse(String statusCode,ByteBuffer body){
		if(statusCode!=null){
			setStatusCode(statusCode);
		}
		if(body!=null){
			responseContentLengthApl=(long)body.remaining();
			setContentLength(responseContentLengthApl);
			setHeader(HeaderParser.CONTENT_LENGTH_HEADER, Long.toString(responseContentLengthApl));
			responseBody(body);
		}
		responseEnd();
	}
	
	public final void responseHeaderAndRestBody(){
		//setupResponseHeader();//body͊m肵ĂȂ
		//responseContentLengthApl=responseHeader.getContentLength();
		//bodym肷B
		String statusCode=responseHeader.getStatusCode();
		if("304".equals(statusCode) || "204".equals(statusCode)){
			responseContentLengthApl=0;
		}else{
			responseContentLengthApl=responseHeader.getContentLength();
		}
		ByteBuffer[] body=responseHeader.getBodyBuffer();
		if(body!=null){
			responseBody(body);
		}
	}
	
	/**
	 * RecX|Xfalse𕜋AB
	 * @return
	 */
	public final boolean needMoreResponse(){
		//responseBodyĂяoɗLɓ
		//̑OɌĂяoꍇAÔe
		if(responseContentLengthApl<0){
			return true;//content̎wȂ
		}
		if(responseContentLengthApl>responseWriteBodyApl){
			return true;
		}
		return false;
	}
	
	/**
	 * X|Xwb_m肵Ă炶Ȃgzip͊m肵Ȃ
	 * @param isAllResponse SX|Xɂ邩ۂ
	 */
	private void setupResponseHeader(){
		String httpVersion=responseHeader.getResHttpVersion();
		if(httpVersion==null){//X|Xo[Wm肵ĂȂꍇAmyProxyWebT[o
			//myProxyWebT[oȂ̂Serverwb_ǉ
			responseHeader.setResHttpVersion(HeaderParser.HTTP_VESION_11);
			responseHeader.setHeader("Server","QueueletHttpServer/0.7");
			responseHeader.setHeader("Date", HeaderParser.fomatDateHeader(new Date()));
		}
		String statusCode=responseHeader.getStatusCode();
		if("304".equals(statusCode) || "204".equals(statusCode)){
			responseContentLengthApl=0;
		}else{
			responseContentLengthApl=responseHeader.getContentLength();
		}
		if( setupGzip() ){
			logger.debug("contents gzip response.id:"+getPoolId());
		}
		return;
	}
	
	/*@WebHandlerpNXX|XIm点郁\bh */
	//TODO keepAlivefowardresponseEndĂяo鎖B
	//handlerĂ̂ŁA肷@ȂB
	protected void responseEnd(){
		synchronized(this){
			if(isResponseEnd || getChannelId()==-1){
				return;
			}
			logger.debug("responseEnd called.handler:"+toString());
			isResponseEnd=true;
			if(isFlushFirstResponse==false){
				flushFirstResponse(null);
				isFlushFirstResponse=true;
			}
			endOfResponse();
//			doneKeepAlive();
		}
	}

	private void endOfResponse(){
		boolean isGzip=false;
//		long gzipResponseLength=0;
		/* gzipr̃f[^tbVAKv΍ŏIchunko */
		GzipContext gzipContext=getGzipContext();
		if(gzipContext!=null){
			ByteBuffer[] zipdBuffer=gzipContext.getZipedBuffer(true);
			if(zipdBuffer!=null && BuffersUtil.remaining(zipdBuffer)!=0){
				internalWriteBody(true,false,zipdBuffer);
			}else{
				internalWriteBody(true,false,null);
			}
//			gzipResponseLength=gzipContext.getOutputLength();
//			gzipContext.unref(true);
			isGzip=true;
//			gzipContext=null;
		}else{
			internalWriteBody(true,false,null);
		}
		
		String peekBody=null;
		ParameterParser parameterParser=getParameterParser();
		if(parameterParser!=null){
			peekBody=parameterParser.getPeekBody();
		}
		KeepAliveContext keepAliveContext=getKeepAliveContext();
		AccessLog accessLog=keepAliveContext.getRequestContext().getAccessLog();
		if(accessLog!=null){
			//\ȏꍇbody̕\accesslogɊ܂߂
			accessLog.setRequestBody(peekBody);
			accessLog.endProcess();
			accessLog.setStatusCode(responseHeader.getStatusCode());
			accessLog.setResponseHeaderLength(responseHeaderLength);
			if(keepAliveContext.isChunked()){
				accessLog.setTransferEncoding(HeaderParser.TRANSFER_ENCODING_CHUNKED);
			}
			accessLog.setPlainResponseLength(responseWriteBodyApl);
			accessLog.setResponseLength(responseWriteBodyApl);
			if(isGzip){
				accessLog.setContentEncoding(CONTENT_ENCODING_GZIP);
			}
			Store readPeek=popReadPeakStore();
			if(readPeek!=null){
				accessLog.setRequestTrace(readPeek.getPageId());
				accessLog.setRequestTraceLength(readPeek.getPutLength());
				readPeek.close();
			}else{
				accessLog.setRequestTrace(-1);
				accessLog.setRequestTraceLength(0);
			}
			
			Store writePeek=popWritePeakStore();
			if(writePeek!=null){
				accessLog.setResponseTrace(writePeek.getPageId());
				accessLog.setResponseTraceLength(writePeek.getPutLength());
				writePeek.close();
			}else{
				accessLog.setResponseTrace(-1);
				accessLog.setResponseTraceLength(0);
			}
			accessLog.log();//loggerɏóiɁj
			accessLog.persist();//dbɏóiꍇɂāj
		}
		keepAliveContext.endOfResponse();
	}
	
	//SSL ProxyńAڃX|X邪ANZXÕX|X\̂߁AZB
	public final void responseBodyLength(long length){
		responseWriteBodyApl+=length;
	}
	
	public final void responseBody(ByteBuffer buffer){
		responseBody(new ByteBuffer[]{buffer});
	}
	
	/**
	 * keepAlive邩ۂ𔻒f
	 * @return
	 */
	private void prepareKeepAlive(long commitContentLength){
		KeepAliveContext keepAliveContext=getKeepAliveContext();
		keepAliveContext.prepareResponse(this,responseHeader,commitContentLength);
	}
	
	protected boolean doneKeepAlive(){
		KeepAliveContext keepAliveContext=getKeepAliveContext();
		if(keepAliveContext!=null){
			boolean done=keepAliveContext.commitResponse(this);
			return done;
		}
		return false;
	}
	
	/**
	 * gzip encoding\fA\ȏꍇAgzipContextpӂ
	 * @return
	 */
	private boolean setupGzip(){
		GzipContext gzipContext=getGzipContext();
		if(responseContentLengthApl==0 || gzipContext!=null){
			return false;
		}
		//ݒ肪gzipɂȂĂȂ΂ȂɂȂ(encodingꍇ͍člv)
		String settingContentEncoding=config.getContentEncoding();
		if(!CONTENT_ENCODING_GZIP.equalsIgnoreCase(settingContentEncoding)){
			return false;
		}
		//X|XencodeĂ牽Ȃ
		String contentEncoding=responseHeader.getHeader(HeaderParser.CONTENT_ENCODING_HEADER);
		if(contentEncoding!=null){
			return false;
		}
		//Ȃs"application/zip"ȃRecgzipŃX|XƁAIE7Ńf[^ꂽ
		String contentType=responseHeader.getHeader(HeaderParser.CONTENT_TYPE_HEADER);
		if(contentType!=null && contentType.indexOf("zip")>=0){
			return false;
		}
		
		HeaderParser requestHeader=getRequestHeader();
		String acceptEncoding=requestHeader.getHeader(HeaderParser.ACCEPT_ENCODING_HEADER);
		if(acceptEncoding!=null){
			String[] entry=acceptEncoding.split(",");
			for(int i=0;i<entry.length;i++){
				if(CONTENT_ENCODING_GZIP.equalsIgnoreCase(entry[i].trim())){
					responseHeader.setHeader(HeaderParser.CONTENT_ENCODING_HEADER,CONTENT_ENCODING_GZIP);
					responseHeader.removeContentLength();
					gzipContext=(GzipContext)PoolManager.getInstance(GzipContext.class);
					setGzipContext(gzipContext);
					return true;
				}
			}
		}
		return false;
	}
	
	private ByteBuffer[] zipedIfNeed(boolean isLast,ByteBuffer[] buffers){
		GzipContext gzipContext=getGzipContext();
		if(gzipContext==null || buffers==null){
			return buffers;
		}
		return gzipContext.getZipedBuffer(isLast, buffers);
	}
	
	/**
	 * @param isLast ŏIf[^ۂ
	 * @param neadCallback onWriteBodycallbackKvۂ
	 * @param buffers Mf[^
	 */
	private void internalWriteBody(boolean isLast,boolean needCallback,ByteBuffer[] buffers){
		KeepAliveContext keepAliveContext=getKeepAliveContext();
		/* Kvchunkedďo͂ */
		buffers=keepAliveContext.chunkedIfNeed(isLast,buffers);
		if(buffers==null){
			if(needCallback){
				onWrittenBody();//͂Ȃ͂Ô
			}
			return;
		}
		String writeContext;
		if(needCallback){
			writeContext=WRITE_CONTEXT_BODY;
		}else{
			writeContext=WRITE_CONTEXT_BODY_INTERNAL;
		}
		if(responseWriteBody==0){
			setTimeCheckPint(AccessLog.TIMEPOINT_responseBodyTop);
		}
//		bodyWriteCount++;
		responseWriteBody+=BuffersUtil.remaining(buffers);
		asyncWrite(writeContext, buffers);
	}
	
	/**
	 * 1NGXg1AbodyݎɌĂяo
	 * @param secondBody@null̏ꍇAX|XI
	 */
	private void flushFirstResponse(ByteBuffer[] secondBody){
		/*@{header̊m */
		setupResponseHeader();
		
		/*@bodym肷 */
		ByteBuffer[] bodyBuffers=BuffersUtil.concatenate(firstBody, secondBody);
		long commitContentLength=-1;
		if(secondBody==null){
			bodyBuffers=zipedIfNeed(true, bodyBuffers);
			/* SX|Xɂ̂chunkedɂKv͂Ȃ,Recm */
			commitContentLength=BuffersUtil.remaining(bodyBuffers);
			responseHeader.setContentLength(commitContentLength);
		}else{
			bodyBuffers=zipedIfNeed(false, bodyBuffers);
		}
		
		/*@keepAlive֘Aheader̐ݒ */
		prepareKeepAlive(commitContentLength);
		ByteBuffer[] headerBuffer=responseHeader.getHeaderBuffer();
		if(headerBuffer==null){//wb_m肵ĂȂ..
			logger.warn("flushFirstResponse fail to getHeaderBuffer.cid:"+getChannelId());
			logger.warn("firstBody:"+firstBody+":secondBody:"+secondBody);
			asyncClose(null);//ؒf
			return;//Ă
		}
		responseHeaderLength=BuffersUtil.remaining(headerBuffer);
		setTimeCheckPint(AccessLog.TIMEPOINT_responseTop);
		if(firstBody==null && secondBody==null){
			/* header̃X|X */
			setTimeCheckPint(AccessLog.TIMEPOINT_responseBodyTop);
			asyncWrite(WRITE_CONTEXT_LAST_HEADER, headerBuffer);
			return;
		}
		firstBody=null;
		/* bodyX|X */
		asyncWrite(WRITE_CONTEXT_HEADER, headerBuffer);
		if(secondBody==null){//SX|XꍇōŌ
			internalWriteBody(true,true,bodyBuffers);
		}else{
			internalWriteBody(false,true,bodyBuffers);
		}
	}
	
	public final void responseBody(ByteBuffer[] buffers){
		AccessLog accessLog=getAccessLog();
		if(accessLog!=null){
			accessLog.digestResponseBody(buffers);
		}
		//bodyƂwritevZAwritéASSL̏ꍇ̂œ
		responseWriteBodyApl+=BuffersUtil.remaining(buffers);
		boolean isCallbackOnWrittenBody=false;
		synchronized(this){
			if(getChannelId()==-1){
				return;//ɐ؂Ă
			}
			if(isFlushFirstResponse==false && firstBody!=null){
				flushFirstResponse(buffers);
				isFlushFirstResponse=true;
				return;//TODO
			}else if(isFlushFirstResponse==false && firstBody==null){
				firstBody=buffers;//ɂ͏o͂
				isCallbackOnWrittenBody=true;
			}
		}
		if(isCallbackOnWrittenBody){
			onWrittenBody();
			return;//TODO
		}
		if(isFlushFirstResponse){
			buffers=zipedIfNeed(false, buffers);
			if(buffers==null){//kȂȂ
				onWrittenBody();
			}else{
				internalWriteBody(false,true,buffers);
			}
		}
		if(needMoreResponse()){
			return;
		}
		//X|XI
		responseEnd();
	}
	
	/**
	 * ̃NX́ASwb_ǂݍ܂ĂĂяôŁAbodyf[^ʉ߂B
	 * wb_͎ɓǂݍł܂bodýAIɌĂяoĂB
	 * @param buffers
	 */
	public void onReadPlain(Object userContext,ByteBuffer[] buffers) {
		logger.debug("#onReadPlain cid:"+getChannelId());
		if(requestReadBody>=requestContentLength){
			return;//Rec𒴂f[^MĂ
		}
		if(buffers!=null){
			requestReadBody+=BuffersUtil.remaining(buffers);
			//\ȏꍇAbodypeek
			ParameterParser parameterParser=getParameterParser();
			for(int i=0;i<buffers.length;i++){
				parameterParser.peek(buffers[i]);
			}
			requestBody(buffers);
		}
		if(requestReadBody<requestContentLength){
			asyncRead(null);
			return;
		}
		setTimeCheckPint(AccessLog.TIMEPOINT_requestBodyEnd);
		startResponseReqBody();
		return;
	}
	
	public ChannelHandler forwardHandler(Class handlerClass){
		logger.debug("#forwardHandler cid:"+getChannelId() +":"+handlerClass.getName());
		WebServerHandler handler= (WebServerHandler)super.forwardHandler(handlerClass);
		handler.startResponse();
		return handler;
	}
	
	public void waitForNextRequest(){
		logger.debug("#waitForNextRequest cid:"+getChannelId());
		Dispatcher handler=(Dispatcher)super.forwardHandler(Dispatcher.class);
		handler.onStartRequest();
	}
	
	public void onFinished() {
		logger.debug("#onFinished cid:"+getChannelId());
		responseEnd();//SSL proxynhandlerAшُI΍
		KeepAliveContext keepAliveContext=getKeepAliveContext();
		if(keepAliveContext!=null){
			keepAliveContext.finishedOfServerHandler();
		}
		super.onFinished();
	}
	
	public final void onWrittenPlain(Object userContext) {
		logger.debug("#onWrittenPlain cid:"+getChannelId());
		if(userContext==WRITE_CONTEXT_BODY){
			onWrittenBody();
		}
		if(userContext==WRITE_CONTEXT_BODY || userContext==WRITE_CONTEXT_BODY_INTERNAL ||userContext==WRITE_CONTEXT_LAST_HEADER){
			synchronized(this){
//				logger.debug("onWrittenPlain.orderCount:"+orderCount());
				if(isResponseEnd){
					if( doneKeepAlive() ){
						return;//keepalive
					}
				}
			}
		}
		super.onWrittenPlain(userContext);
	}
	
	/* responseBodyɒʒmA*/
	public void onWrittenBody(){
		logger.debug("#onWrittenBody cid:"+getChannelId());
	}
	
	/* o͂outputStreamwriteroRŎw肷郁\bh */
	private OutputStream responseBodyStream;
	private Writer responseBodyWriter;
	private class ResponseBodyStream extends OutputStream{
		private ByteBuffer buffer;
		private int capacity;
		private int limit;
		ResponseBodyStream(){
			buffer=null;
		}
		
		public void close() throws IOException {
			responseBodyStream=null;
			responseBodyWriter=null;
			flush();
		}

		public void flush() throws IOException {
			if(buffer!=null){
				buffer.flip();
				responseBody(new ByteBuffer[]{buffer});
			}
			buffer=null;
		}

		public void write(byte[] src, int offset, int length) throws IOException {
			if(buffer!=null && capacity<(limit+length)){
				flush();
			}
			if(buffer==null){
				buffer=PoolManager.getBufferInstance();
				capacity=buffer.capacity();
				limit=0;
				//pӂꂽobt@傫f[^writeĂ܂B
				if(capacity<length){
					PoolManager.poolBufferInstance(buffer);
					buffer=null;
					ByteBuffer[] buffers=BuffersUtil.buffers(src, offset, length);
					responseBody(buffers);
					return;
				}
			}
			buffer.put(src, offset, length);
			limit+=length;
		}

		public void write(byte[] src) throws IOException {
			write(src,0,src.length);
		}

		public void write(int src) throws IOException {
			write(new byte[]{(byte)src},0,1);
		}
	}
	
	public final OutputStream getResponseBodyStream(){
		if(responseBodyStream!=null){
			return responseBodyStream;
		}
		responseBodyStream=new ResponseBodyStream();
		return responseBodyStream;
	}
	
	public final Writer getResponseBodyWriter(String enc) throws UnsupportedEncodingException{
		if(responseBodyWriter!=null){
			return responseBodyWriter;
		}
		responseBodyWriter = new OutputStreamWriter(getResponseBodyStream(),enc);
		return responseBodyWriter;
	}
}
