package naru.phantom.http;

import java.nio.ByteBuffer;

import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;

import naru.async.pool.BuffersUtil;
import naru.async.pool.PoolBase;
import naru.async.pool.PoolManager;
import naru.async.ssl.SslHandler;
import naru.phantom.admin.Setting;
import naru.phantom.handler.ProxyHandler;
import naru.phantom.robot.CallScheduler;
import naru.phantom.util.HeaderParser;

public class WebClientHandler extends SslHandler {
	private static final int STAT_INIT = 1;
	private static final int STAT_CONNECT = 2;
	private static final int STAT_REQUEST_HEADER = 3;
	private static final int STAT_REQUEST_BODY = 4;
	private static final int STAT_RESPONSE_HEADER = 5;
	private static final int STAT_RESPONSE_BODY = 6;
	private static final int STAT_KEEP_ALIVE = 7;
	private static final int STAT_END = 8;

	public static final String CONTEXT_HEADER = "contextHeader";
	public static final String CONTEXT_BODY = "contextBody";
	public static final String CONTEXT_SSL_PROXY_CONNECT = "contextSslProxyConnect";

	private static Logger logger = Logger.getLogger(WebClientHandler.class);
	private static Setting config = Setting.getInstance();
//	private static Configuration configuration = config.getConfiguration();

	private Object lock = new Object();
	private int stat;
	private long connectTimeout = 5000;
	private boolean isKeepAlive;// keepAliveۂ
	private boolean isCallerKeepAlive;// keepAlive]邩ۂ
	private WebClientConnection webClientConnection=new WebClientConnection();
	private CallScheduler scheduler=null;

	private ByteBuffer[] requestHeaderBuffer;// NGXgwb_
	private ByteBuffer[] requestBodyBuffer;// NGXg{fB

	private long requestContentLength;
	private long requestContentWriteLength;
	private HeaderParser responseHeader = new HeaderParser();
	private ChunkContext responseChunk=new ChunkContext();
	
	private long requestHeaderLength;//NGXgwb_
	private long responseHeaderLength;//X|Xwb_
	
	private WebClient webClient;
	private Object userContext;

	private void setWebClient(WebClient webClient){
		PoolBase poolBase=null;
		if(webClient!=null){
			if(webClient instanceof PoolBase){
				poolBase=(PoolBase)webClient;
			}
			poolBase.ref();
			poolBase=null;
		}
		if(this.webClient!=null){
			if(this.webClient instanceof PoolBase){
				poolBase=(PoolBase)this.webClient;
			}
			poolBase.unref();
			poolBase=null;
		}
		this.webClient=webClient;
	}
	
	public void recycle() {
		stat = STAT_INIT;
		setScheduler(null);
		setWebClient(null);
		isKeepAlive = false;
		if(requestHeaderBuffer!=null){
			PoolManager.poolBufferInstance(requestHeaderBuffer);
			requestHeaderBuffer=null;
		}
		if(requestBodyBuffer!=null){
			PoolManager.poolBufferInstance(requestBodyBuffer);
			requestBodyBuffer=null;
		}
		requestContentLength = requestContentWriteLength = 0;
		requestHeaderLength=responseHeaderLength=0;
		scheduler=null;
		responseHeader.recycle();
		webClientConnection.recycle();
		super.recycle();
	}

	public void setScheduler(CallScheduler scheduler){
		if(scheduler!=null){
			scheduler.ref();
		}
		if(this.scheduler!=null){
			this.scheduler.unref();
		}
		this.scheduler=scheduler;
	}
	
	private void internalStartRequest() {
		synchronized (lock) {
			stat = STAT_REQUEST_HEADER;
			logger.info("startRequest requestHeaderBuffer length:"+BuffersUtil.remaining(requestHeaderBuffer)+":"+getPoolId()+":"+getChannelId());
			//for sceduler wb_̑M
			requestHeaderLength=BuffersUtil.remaining(requestHeaderBuffer);
			if(scheduler!=null){
				scheduler.scheduleWrite(CONTEXT_HEADER, requestHeaderBuffer);
			}else{
				asyncWrite(CONTEXT_HEADER, requestHeaderBuffer);
			}
			requestHeaderBuffer=null;
			if (requestBodyBuffer != null) {
				stat = STAT_REQUEST_BODY;
				//for sceduler body̑M
				long length = BuffersUtil.remaining(requestBodyBuffer);
				requestContentWriteLength += length;
				if(scheduler!=null){
					scheduler.scheduleWrite(CONTEXT_BODY, requestBodyBuffer);
				}else{
					asyncWrite(CONTEXT_BODY, requestBodyBuffer);
				}
				requestBodyBuffer=null;
			}
		}
		if (requestContentWriteLength >= requestContentLength) {
			//X|Xwb_̓ǂݍݗv́ANGXgJnɍs
//			asyncRead(CONTEXT_HEADER);
		}
	}

	public void onConnected(Object userContext) {
		logger.debug("#connected.id:" + getChannelId());
		if (webClientConnection.isHttps()) {
			if (webClientConnection.isUseProxy()) {
				// SSLproxyڑ
				//TODO proxyF
				StringBuffer sb = new StringBuffer(512);
				sb.append("CONNECT ");
				sb.append(webClientConnection.getTargetServer());
				sb.append(":");
				sb.append(webClientConnection.getTargetPort());
				sb.append(" HTTP/1.0\r\nHost: ");
				sb.append(webClientConnection.getTargetServer());
				sb.append(":");
				sb.append(webClientConnection.getTargetPort());
				sb.append("\r\nContent-Length: 0\r\n\r\n");
				ByteBuffer buf = ByteBuffer.wrap(sb.toString().getBytes());
				asyncWrite(CONTEXT_SSL_PROXY_CONNECT, new ByteBuffer[] { buf });
				asyncRead(CONTEXT_SSL_PROXY_CONNECT);
				return;
			} else {
				// proxyȂSSLڑ
				sslOpen(true);
				return;
			}
		}
		// httpڑ
		asyncRead(CONTEXT_HEADER);//NGXgĂȂAsăX|Xwb_vs
		internalStartRequest();
	}

	public boolean onHandshaked() {
		logger.debug("#handshaked.cid:" + getChannelId());
		// SSLڑꍇproxyoR̐ڑ̏ꍇɗ
		internalStartRequest();
		return false;
	}

	public final void onWrittenPlain(Object userContext) {
		logger.debug("#writtenPlain.cid:" + getChannelId());
		if (userContext == CONTEXT_BODY) {
			onWrittenRequestBody();
		}
	}

	public void onRead(Object userContext, ByteBuffer[] buffers) {
		if (userContext == CONTEXT_SSL_PROXY_CONNECT) {
			for (int i = 0; i < buffers.length; i++) {
				responseHeader.parse(buffers[i]);
			}
			if (responseHeader.isParseEnd()) {
				if (responseHeader.isParseError()) {
					logger.warn("ssl proxy header error");
					// client.doneResponse("500","fail to ssl proxy connect");
					asyncClose(null);
					return;
				}
			} else {
				asyncRead(CONTEXT_SSL_PROXY_CONNECT);
				return;
			}
			if(!"200".equals(responseHeader.getStatusCode())){
				logger.warn("ssl proxy fail to connect.statusCode;"+responseHeader.getStatusCode());
				onResponseHeader(responseHeader);
				asyncClose(null);
				return;
			}
			ByteBuffer[] body = responseHeader.getBodyBuffer();
			responseHeader.recycle();// {̃wb_[pɍėp
			sslOpen(true);
			// if(body!=null){
			// super.onRead(userContext, body);//g鎖͂Ȃ
			// }
			return;
		}
		super.onRead(userContext, buffers);
	}

	public void onReadPlain(Object userContext, ByteBuffer[] buffers) {
		logger.debug("#readPlain.cid:" + getChannelId());
		if (userContext == CONTEXT_BODY) {
			stat = STAT_RESPONSE_BODY;
			boolean isLast=responseChunk.isLastData(buffers);
			onResponseBody(buffers);
			if (isLast) {
				endOfResponse();
			} else {
				asyncRead(CONTEXT_BODY);
			}
			return;
		}
		stat = STAT_RESPONSE_HEADER;
		for (int i = 0; i < buffers.length; i++) {
			responseHeader.parse(buffers[i]);
		}
		if (!responseHeader.isParseEnd()) {
			// wb_IĂȂꍇ㑱̃wb_ǂݍ
			asyncRead(CONTEXT_HEADER);
			return;
		}
		// wb_ǂ݂
		if (responseHeader.isParseError()) {
			logger.warn("http header error");
			asyncClose(null);
			return;
		}
		responseHeaderLength=responseHeader.getHeaderLength();
		String statusCode = responseHeader.getStatusCode();
		String transfer=responseHeader.getHeader(HeaderParser.TRANSFER_ENCODING_HEADER);
		onResponseHeader(responseHeader);
		if ("304".equals(statusCode) || "204".equals(statusCode)) {
			endOfResponse();
			return;
		}
		
		long responseContentLength = responseHeader.getContentLength();
		if (responseContentLength < 0) {
			responseContentLength = Long.MAX_VALUE;
		}
		boolean isChunked=HeaderParser.TRANSFER_ENCODING_CHUNKED.equalsIgnoreCase(transfer);
		responseChunk.decodeInit(isChunked, responseContentLength);
		ByteBuffer[] body = responseHeader.getBodyBuffer();
		boolean isLast=responseChunk.isLastData(body);
		if (body != null) {
			stat = STAT_RESPONSE_BODY;
			onResponseBody(body);
		}
		if (isLast) {
			endOfResponse();
		}else{
			asyncRead(CONTEXT_BODY);
		}
	}

	private void endOfResponse() {
		if(stat==STAT_END){//؂ĂkeepAlive悤Ȃ
			isKeepAlive=false;
		}
		if (isKeepAlive) {// keepAliveCꍇ́AT[öӌ𕷂
			String connectionHeader = null;
			String httpVersion = responseHeader.getResHttpVersion();
			if (!webClientConnection.isHttps() && webClientConnection.isUseProxy()) {
				connectionHeader = responseHeader
						.getHeader(HeaderParser.PROXY_CONNECTION_HEADER);
			} else {
				connectionHeader = responseHeader
						.getHeader(HeaderParser.CONNECTION_HEADER);
			}
			// HTTP1.0̏ꍇ́AKeepAlivew肳ꂽꍇKeepAliveł
			if (HeaderParser.HTTP_VESION_10.equalsIgnoreCase(httpVersion)) {
				if (!HeaderParser.CONNECION_KEEP_ALIVE
						.equalsIgnoreCase(connectionHeader)) {
					isKeepAlive = false;
				}
			}
			// HTTP1.1̏ꍇ́AClosew肳ȂꍇKeepAliveł
			if (HeaderParser.HTTP_VESION_11.equalsIgnoreCase(httpVersion)) {
				if (HeaderParser.CONNECION_CLOSE
						.equalsIgnoreCase(connectionHeader)) {
					isKeepAlive = false;
				}
			}
		}
		onRequestEnd();
		if (isKeepAlive == false) {
			asyncClose(null);
			return;
		}
		stat = STAT_KEEP_ALIVE;
		requestHeaderBuffer = requestBodyBuffer = null;
		requestContentLength = requestContentWriteLength = 0;
		responseHeader.recycle();
		setReadTimeout(15000);//keepAlive^CAEg
		asyncRead(CONTEXT_HEADER);//keepAliveɐ؂ꂽ炷Ɍoł悤ɁAɃwb_̓ǂݍݗv
		logger.debug("WebClientHandler keepAlive.cid:"+getChannelId());
	}

	public void onFailure(Object userContext, Throwable t) {
		logger.debug("#failure.cid:" + getChannelId(), t);
		isKeepAlive = false;
		asyncClose(userContext);
		onRequestFailure(t);
		super.onFailure(userContext, t);
	}

	public void onTimeout(Object userContext) {
		logger.debug("#timeout.cid:" + getChannelId());
		isKeepAlive = false;
		asyncClose(userContext);
		onRequestFailure(new Exception("WebClientHandler timeout"));
		super.onTimeout(userContext);
	}

	public void onClosed(Object userContext) {
		logger.debug("#closed.cid:" + getChannelId());
		isKeepAlive = false;
		onRequestEnd();
		stat = STAT_END;
		super.onClosed();
	}

	public void onFinished() {
		logger.debug("#finished.cid:" + getChannelId());
		isKeepAlive = false;
		onRequestEnd();
		stat = STAT_END;
		super.onFinished();
	}
	
	public boolean isSameConnection(boolean isHttps, String targetServer,int targetPort){
		if(stat!=STAT_KEEP_ALIVE){
			logger.debug("isSameConnection not keepAlive stat:"+stat);
			return false;
		}
		return webClientConnection.equalsConnection(isHttps,targetServer,targetPort);
	}
	
	public void setConnection(boolean isHttps, String targetServer,int targetPort){
		webClientConnection.init(isHttps, targetServer, targetPort);
	}
	
	public ByteBuffer[] getRequestHeaderBuffer(HeaderParser requestHeader,boolean isCallerkeepAlive){
		String orgUri=requestHeader.getRequestUri();
		String uri = webClientConnection.requestUri(orgUri);
		requestHeader.setRequestUri(uri);
		requestHeader.setHeader(HeaderParser.HOST_HEADER,webClientConnection.getTargetServer()+":"+webClientConnection.getTargetPort());
		// keepAlive
		KeepAliveContext.setConnectionHandler(requestHeader,
				(!webClientConnection.isHttps() && webClientConnection.isUseProxy()),
				isCallerkeepAlive);
		ByteBuffer[] requestHeaderBuffer = requestHeader.getHeaderBuffer();
		//uriύXĂ܂mȂ̂Ōɖ߂irequestHeaderėpꍇssƂȂ)
		requestHeader.setRequestUri(orgUri);
		return requestHeaderBuffer;
	}
	
	public final boolean startRequest(WebClient webClient,Object userContext,ByteBuffer[] requestHeaderBuffer,long requestContentLength,boolean isCallerkeepAlive) {
		synchronized (lock) {
			if (this.webClient != null) {
				throw new IllegalStateException("aleardy had webClient:"+((ProxyHandler)this.webClient).getChannelId());
			}
			setWebClient(webClient);
			this.userContext=userContext;
		}
		this.isCallerKeepAlive = isCallerkeepAlive;
		this.isKeepAlive = isCallerKeepAlive;
		this.requestHeaderBuffer = requestHeaderBuffer;
		
		// TODO chunked̍l
		this.requestContentLength = requestContentLength;
		if(stat==STAT_KEEP_ALIVE){
			internalStartRequest();
			return true;
		}if(stat==STAT_INIT){
			stat = STAT_CONNECT;
			return asyncConnect(this, webClientConnection.getRemoteServer(), webClientConnection.getRemotePort(), connectTimeout);
		}
		logger.error("fail to doRequest.cid="+getChannelId() +":stat:"+stat);
		return false;
	}
	

	/**
	 * NGXgI[́Amethodcontent-lengthŔf I[FAX|XncallbacknhĂяoB
	 * @param clientIp ĂяoipAhXiݒQƗp)
	 * @param isCallerkeepAlive ĂяokeepAlive]邩ۂ
	 * @param targetServer ڑT[o
	 * @param targetPort ڑ|[g
	 * 
	 * @param webClient@CxgʒmC^tF[X
	 * @param requestHeader@NGXgwb_(uriwebT[oł邱'/'n܂邱ƑO)
	 * @return
	 */
	public final boolean startRequest(WebClient webClient,Object userContext,HeaderParser requestHeader,boolean isCallerkeepAlive) {
		ByteBuffer[] requestHeaderBuffer=getRequestHeaderBuffer(requestHeader,isCallerkeepAlive);
		long requestContentLength = requestHeader.getContentLength();
		if (requestContentLength < 0) {
			requestContentLength = 0;
		}
		return startRequest(webClient,userContext,requestHeaderBuffer,requestContentLength,isCallerkeepAlive);
	}
	
	public final void requestBody(ByteBuffer[] buffers) {
		//connectObodyBuffer󂯕tꍇ
		synchronized (lock) {
			if (stat == STAT_CONNECT) {
				requestBodyBuffer = BuffersUtil.concatenate(requestBodyBuffer,buffers);
				return;
			}
		}
		stat = STAT_REQUEST_BODY;
		//TODO for sceduler body̑M
		long length = BuffersUtil.remaining(buffers);
		requestContentWriteLength += length;
		if(scheduler!=null){
			scheduler.scheduleWrite(CONTEXT_BODY, requestBodyBuffer);
		}else{
			asyncWrite(CONTEXT_BODY, requestBodyBuffer);
		}
		requestBodyBuffer=null;
		if (requestContentWriteLength >= requestContentLength) {
			asyncRead(CONTEXT_HEADER);
		}
	}

	public final void cancelRequest() {
		webClient = null;
		asyncClose(null);
	}
	
	public boolean isKeepAlive(){
		return stat==STAT_KEEP_ALIVE;
	}

	/*
	 * ȍ~callback\bh
	 */
	private void onWrittenRequestBody() {
		if (webClient != null) {
			webClient.onWrittenRequestBody(userContext);
		}
	}

	private void onResponseHeader(HeaderParser responseHeader) {
		if (webClient != null) {
			webClient.onResponseHeader(userContext,responseHeader);
		}
	}

	private void onResponseBody(ByteBuffer[] buffer) {
		if (webClient != null) {
			webClient.onResponseBody(userContext,buffer);
		}
	}

	private void onRequestEnd() {
		if (webClient != null) {
			webClient.onRequestEnd(userContext);
		}
		synchronized (this) {
			setWebClient(null);
			userContext=null;
		}
	}

	private void onRequestFailure(Throwable t) {
		if (webClient != null) {
			webClient.onRequestFailure(userContext,t);
		}
		synchronized (this) {
			setWebClient(null);
			userContext=null;
		}
	}

	public long getRequestHeaderLength() {
		return requestHeaderLength;
	}

	public long getResponseHeaderLength() {
		return responseHeaderLength;
	}
	
	public boolean isConnect(){
		if(stat==STAT_INIT||stat==STAT_END){
			return false;
		}
		return true;
	}
}
