package naru.phantom.http;

import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;

import naru.async.pool.PoolBase;
import naru.phantom.admin.Setting;

public class WebClientConnection extends PoolBase {
	private static Logger logger = Logger.getLogger(WebClientConnection.class);
	
	public void recycle() {
		isUseProxy=isHttps=false;
		remoteServer=targetServer=null;
		remotePort=targetPort=-1;
		super.recycle();
	}

	private static Setting config = Setting.getInstance();
//	private static Configuration configuration = config.getConfiguration();
	
	private boolean isUseProxy;// proxyoRĐڑۂ
	private boolean isHttps;// httpsۂ
	private String remoteServer;// ڑĂT[o,isUseProxy̏ꍇproxyT[o
	private int remotePort;// ڑĂT[õ|[g,isUseProxy̏ꍇproxyT[o
	private String targetServer;// NGXgT[o
	private int targetPort;// NGXg|[g
	
	public void init(boolean isHttps, String targetServer,int targetPort){
		this.targetServer = targetServer;
		this.targetPort = targetPort;
		this.isUseProxy = config.isUseProxy(targetServer);
		this.isHttps = isHttps;
		if (this.isUseProxy) {
			if (isHttps) {
				this.remoteServer = config.getString("sslProxyServer");
				this.remotePort = config.getInt("sslProxyPort");
			} else {
				this.remoteServer = config.getString("proxyServer");
				this.remotePort = config.getInt("proxyPort");
			}
		} else {
			this.remoteServer = targetServer;
			this.remotePort = targetPort;
		}
	}
	
	/**
	 * NGXgC̕ҏW
	 */
	public String requestUri(String uri) {
		if (!isUseProxy || isHttps) {
			// ڃNGXgꍇAhttps̏ꍇ
			return uri;
		}
		// http proxyʉ߂ꍇ
		return "http://" + targetServer + ":" + targetPort + uri;
	}
	
	public boolean equalsConnection(boolean isHttps, String targetServer,int targetPort){
		if(this.isHttps!=isHttps){
			logger.debug("equalsConnection not equals isHttps:"+this.isHttps+":"+isHttps);
			return false;
		}
		if(!this.targetServer.equals(targetServer)){
			logger.debug("equalsConnection not equals targetServer:"+this.targetServer+":"+targetServer);
			return false;
		}
		if(this.targetPort!=targetPort){
			logger.debug("equalsConnection not equals targetPort:"+this.targetPort+":"+targetPort);
			return false;
		}
		return true;
		
	}

	public boolean isUseProxy() {
		return isUseProxy;
	}

	public boolean isHttps() {
		return isHttps;
	}

	public String getRemoteServer() {
		return remoteServer;
	}

	public int getRemotePort() {
		return remotePort;
	}

	public String getTargetServer() {
		return targetServer;
	}

	public int getTargetPort() {
		return targetPort;
	}
}
