package naru.phantom.http;

import java.nio.ByteBuffer;

import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;

import naru.async.pool.BuffersUtil;
import naru.async.pool.PoolBase;
import naru.async.pool.PoolManager;
import naru.phantom.AccessLog;
import naru.phantom.admin.MappingResult;
import naru.phantom.admin.Setting;
import naru.phantom.admin.MappingEntry;
import naru.phantom.util.HeaderParser;
import naru.phantom.util.ParameterParser;
/**
 * 
 * @author Naru
 *
 */
public class RequestContext extends PoolBase {
	private static Logger logger = Logger.getLogger(RequestContext.class);
	private static Setting config=Setting.getInstance();
//	private static Configuration configuration=config.getConfiguration();
	
	private KeepAliveContext keepAliveContext;
	private AccessLog accessLog=new AccessLog();
	private MappingResult mapping;
	private ChunkContext chunkContext;//gȂ
	private GzipContext gzipContext;//Kvȏꍇɐݒ
	private HeaderParser requestHeader=new HeaderParser();
	private ParameterParser parameterParser=new ParameterParser();
	private String userName;
	private Setting userSetting;
	
	public void recycle() {
		setKeepAliveContext(null);
		mapping=null;
		chunkContext=null;
		accessLog.recycle();
		if(gzipContext!=null){
			gzipContext.unref();
			gzipContext=null;
		}
		userName=null;
		userSetting=null;
		requestHeader.recycle();
		parameterParser.recycle();
		super.recycle();
	}

	public KeepAliveContext getKeepAliveContext() {
		return keepAliveContext;
	}

	public void setKeepAliveContext(KeepAliveContext keepAliveContext) {
		if(keepAliveContext!=null){
			keepAliveContext.ref();
//			keepAliveContext.setRequestContext(this);
		}
		if(this.keepAliveContext!=null){
//			if(keepAliveContext!=this.keepAliveContext){
//				this.keepAliveContext.setRequestContext(null);
//			}
			this.keepAliveContext.unref();
		}
		this.keepAliveContext = keepAliveContext;
	}

	public AccessLog getAccessLog() {
		return accessLog;
	}

	public void setAccessLog(AccessLog accessLog) {
		this.accessLog = accessLog;
	}

	public ChunkContext getChunkContext() {
		return chunkContext;
	}

	public void setChunkContext(ChunkContext chunkContext) {
		this.chunkContext = chunkContext;
	}

	public HeaderParser getRequestHeader() {
		return requestHeader;
	}

	public ParameterParser getParameterParser() {
		return parameterParser;
	}

	public GzipContext getGzipContext() {
		return gzipContext;
	}

	public void setGzipContext(GzipContext gzipContext) {
		this.gzipContext = gzipContext;
	}

	public MappingResult getMapping() {
		return mapping;
	}

	public void setMapping(MappingResult mapping) {
		this.mapping = mapping;
	}

	public Setting getUserSetting() {
		return userSetting;
	}
	
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName=userName;
		this.userSetting=Setting.getUserSetting(userName);
	}
}
