package naru.phantom.http;

import java.nio.ByteBuffer;

import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;

import naru.async.pool.BuffersUtil;
import naru.async.pool.PoolBase;
import naru.async.pool.PoolManager;
import naru.phantom.admin.MappingEntry;
import naru.phantom.admin.MappingResult;
import naru.phantom.admin.Setting;
import naru.phantom.util.HeaderParser;
/**
 * 
 * @author Naru
 *
 */
public class KeepAliveContext extends PoolBase {
	private static Logger logger = Logger.getLogger(KeepAliveContext.class);
	private static Setting config=Setting.getInstance();
//	private static Configuration configuration=config.getConfiguration();
	
	public static void setConnectionHandler(HeaderParser responseHeader,boolean isProxy,boolean isKeepAlive){
		String value;
		if(isKeepAlive){
			value=HeaderParser.CONNECION_KEEP_ALIVE;
		}else{
			value=HeaderParser.CONNECION_CLOSE;
		}
		if(isProxy){
			responseHeader.setHeader(HeaderParser.PROXY_CONNECTION_HEADER, value);
		}else{
			responseHeader.setHeader(HeaderParser.CONNECTION_HEADER, value);
		}
	}
	private RequestContext requestContext;//requestPʂ̏

	private String realHostName;
//	private String sslPeekServer;
//	private int sslPeekPort;
	private MappingResult sslProxyMapping;
	
	private boolean isKeepAlive;
	private boolean isChunked;
	private int requestsCount;
	private int maxKeepAliveRequests;
	private long keepAliveTimeout;
	private boolean isAllowChunked;//NGXgchunkedT|[g邩ۂ
	private boolean isProxy;
	private boolean isSendLastChunk;
	private boolean isCloseServerHandle=false;
	
	private WebClientHandler webClientHandler;//|CgėpȂ
	
	public void recycle() {
		maxKeepAliveRequests=config.getMaxKeepAliveRequests();
		keepAliveTimeout=config.getKeepAliveTimeout();
		requestsCount=0;
		isSendLastChunk=isChunked=isProxy=isKeepAlive=isAllowChunked=false;
		setupedHandler=null;
		setWebClientHandler(null);
		if(requestContext!=null){
			requestContext.unref(true);
			requestContext=null;
		}
		isCloseServerHandle=false;
		sslProxyMapping=null;
		realHostName=null;
	}
	
	private void setWebClientHandler(WebClientHandler webClientHandler){
		if(webClientHandler!=null){
			webClientHandler.ref();
		}
		if(this.webClientHandler!=null){
			if(this.webClientHandler.isConnect()){
				this.webClientHandler.asyncClose(null);
			}
			this.webClientHandler.unref();
		}
		this.webClientHandler=webClientHandler;
	}
	
	/**
	 * NGXgwb_āAKeepAliveContextԋpB
	 * 
	 * @param context@keepAliveContext
	 * @param requestHeader NGXgwb_
	 * @return
	 */
	public void startRequest(HeaderParser requestHeader){
		isSendLastChunk=isChunked=isKeepAlive=isAllowChunked=false;
		isProxy=requestHeader.isProxy();
		
		/* őkeepAlive񐔂𒴂ĂkeepAliveȂ */
		if(requestsCount>=maxKeepAliveRequests){
			logger.debug("reach maxKeepAliveRequests."+maxKeepAliveRequests);
			isKeepAlive=false;
			return;
		}
		String connection=null;
		if(isProxy){//proxyT[ȍꍇ
			if(!config.isProxyKeepAlive()){
				isKeepAlive=false;
				return;
			}
			/* IconnectionؒfxĂꍇ́AKeepAliveȂ */
			connection=requestHeader.getHeader(HeaderParser.PROXY_CONNECTION_HEADER);
			if(connection!=null){
				connection.trim();
			}
			if(HeaderParser.CONNECION_CLOSE.equalsIgnoreCase(connection)){
				isKeepAlive=false;
				return;
			}
		}else{//webT[ȍꍇ
			/* keepAliveݒ肪falsȅꍇAKeepAliveȂ */
			if(!config.isWebKeepAlive()){
				isKeepAlive=false;
				return;
			}
			/* IconnectionؒfxĂꍇ́AKeepAliveȂ */
			connection=requestHeader.getHeader(HeaderParser.CONNECTION_HEADER);
			if(connection!=null){
				connection.trim();
			}
			if(HeaderParser.CONNECION_CLOSE.equalsIgnoreCase(connection)){
				isKeepAlive=false;
				return;
			}
		}
		/* HTTP1.0ŖꂽKeepAlivew肪KeepAlive\@*/
		boolean isAllowChunked=config.getBoolean("allowChunked",false);
		String version=requestHeader.getReqHttpVersion();
		if(HeaderParser.HTTP_VESION_10.equalsIgnoreCase(version)){
			if(!HeaderParser.CONNECION_KEEP_ALIVE.equalsIgnoreCase(connection)){
				isKeepAlive=false;
				return;
			}
			isAllowChunked=false;/* HTTP1.0́AchunkedT|[gȂ */
		}
		//if(context.isProxy){//ȂproxyoR̃RecchnkedƃuEU\ĂȂ
		//	isAllowChunked=false;
		//}
		this.isKeepAlive=true;
		this.isAllowChunked=isAllowChunked;
		this.requestsCount++;
		return;
	}
	

	public WebClientHandler getWebClientHandler(boolean isHttps, String targetServer,int targetPort){
		if(webClientHandler!=null){
			if( webClientHandler.isSameConnection(isHttps,targetServer,targetPort) ){
				return webClientHandler;
			}
		}
		WebClientHandler newWebClientHandler=(WebClientHandler)PoolManager.getInstance(WebClientHandler.class);
		newWebClientHandler.setConnection(isHttps, targetServer, targetPort);
		setWebClientHandler(newWebClientHandler);
		return newWebClientHandler;
	}
	
	public boolean isKeepAlive() {
		return isKeepAlive;
	}
	
	public boolean isChunked() {
		return isChunked;
	}

	public long getKeepAliveTimeout() {
		return keepAliveTimeout;
	}
	
	private static final byte[] DATA_AND_LAST_CHUNK="\r\n0\r\n\r\n".getBytes();
	private static final byte[] LAST_CHUNK="0\r\n\r\n".getBytes();
	private static final byte[] CRLF = "\r\n".getBytes();
	
	/**
	 * 
	 * @param buffers@null̏ꍇX|XI[킷
	 * @return
	 */
	public ByteBuffer[] chunkedIfNeed(boolean isLast,ByteBuffer[] buffers){
		if(!isChunked){
			return buffers;
		}
		ByteBuffer head=null;
		if(buffers==null){
			if(isLast && !isSendLastChunk){
				isSendLastChunk=true;
				return new ByteBuffer[]{ByteBuffer.wrap(LAST_CHUNK)};
			}
			/* buffersnullōŌ̃f[^ȂƂُ͈̂ */
			throw new IllegalArgumentException("chunkedIfNeed");
		}else{
			long length=BuffersUtil.remaining(buffers);
			String headString=Long.toHexString(length)+"\r\n";
			head=ByteBuffer.wrap(headString.getBytes());
		}
		ByteBuffer tail=null;
		if(isLast){
			isSendLastChunk=true;
			tail=ByteBuffer.wrap(DATA_AND_LAST_CHUNK);
		}else{
			tail=ByteBuffer.wrap(CRLF);
		}
		ByteBuffer[] chunkedBuffer=BuffersUtil.concatenate(head, buffers, tail);
		return chunkedBuffer;
	}

	/* prepareResponseendOfResponséA΂̃\bh handlerĂяo */
	private WebServerHandler setupedHandler;
	public boolean prepareResponse(WebServerHandler handler,HeaderParser responseHeader,long commitContentLength) {
		logger.debug("prepareResponse handler.cid:"+handler+ ":webClientHandler.cid:"+webClientHandler);
		if(setupedHandler!=null){
			throw new IllegalStateException("fail to setup."+setupedHandler);
		}
		//responsem肵ĂȂB
		if(responseHeader.getStatusCode()==null){
			isKeepAlive=false;
		}
		setupedHandler=handler;
		isChunked=false;
		if(!isKeepAlive){
			setConnectionHandler(responseHeader,isProxy,false);
			return false;
		}
		/* ʃAvP[VkeepAlive߂邱Ƃw肵ꍇ] */
		/*
		String orgConnectionHeader;
		if(isProxy){
			orgConnectionHeader=responseHeader.getHeader(HeaderParser.PROXY_CONNECTION_HEADER);
		}else{
			orgConnectionHeader=responseHeader.getHeader(HeaderParser.CONNECTION_HEADER);
		}
		if(HeaderParser.CONNECION_CLOSE.equalsIgnoreCase(orgConnectionHeader)){
			isKeepAlive=false;
			setConnectionHandler(responseHeader,isProxy,false);
			return false;
		}
		*/
		String transferEncoding=responseHeader.getHeader(HeaderParser.TRANSFER_ENCODING_HEADER);
		boolean isAreadyChunked=HeaderParser.TRANSFER_ENCODING_CHUNKED.equalsIgnoreCase(transferEncoding);
		long contentLength=responseHeader.getContentLength();
		/*@keepAlivełARecm肵ĂȂꍇAchunkedŕԋpKv */
		if(isAreadyChunked){
			isChunked=false;//chunkedĂ̂d˂chunkedKvȂ
		}else if(contentLength<0&&commitContentLength<0){
			if(!isAllowChunked){
				//keepAliveĂARecm肵ĂȂAchunkedłȂꍇAKeepAlive͂łȂ
				isKeepAlive=false;
				setConnectionHandler(responseHeader,isProxy,false);
				return false;
			}
			isChunked=true;
		}
		
		setConnectionHandler(responseHeader,isProxy,true);
		/*Keep-Alive: timeout=15, max=100 Ȋ*/
		responseHeader.setHeader(HeaderParser.KEEP_ALIVE_HEADER,"timeout=" +(keepAliveTimeout/1000) + ", max=" +(maxKeepAliveRequests-requestsCount));
		if(isChunked){
			responseHeader.removeHeader(HeaderParser.CONTENT_LENGTH_HEADER);
			responseHeader.setHeader(HeaderParser.TRANSFER_ENCODING_HEADER, HeaderParser.TRANSFER_ENCODING_CHUNKED);
			responseHeader.setResHttpVersion(HeaderParser.HTTP_VESION_11);
		}else if(contentLength<0 && commitContentLength>=0){
			responseHeader.setContentLength(commitContentLength);
		}
		return true;
	}
	
	/*
	 * KeepAliveContextPɂServer handle𖳌̂1
	 */
	private void closeServerHandleOnce(WebServerHandler handler){
		if(isCloseServerHandle==false){
			handler.asyncClose(null);
			isCloseServerHandle=true;
		}
	}
	
	/**
	 * X|XIƍl^C~OŌĂяo
	 * PNGXgŌĂяoP񂾂Ƃ͌Ȃ_ɒ
	 * @param handler uEUƂȂĂhandler
	 * @return
	 */
	public synchronized boolean commitResponse(WebServerHandler handler){
		logger.debug("commitResponse handler.cid:"+handler+ ":webClientHandler.cid:"+webClientHandler);
		if(setupedHandler==null){
			setWebClientHandler(null);
			logger.debug("commitResponse done end of keepAlive not prepareResponse.handler:"+handler);
			closeServerHandleOnce(handler);
			return false;
		}
		if(handler!=setupedHandler){
			throw new IllegalStateException("fail to endOfResponse.setupedHandler:"+setupedHandler);
		}
		setupedHandler=null;
		if(!isKeepAlive || handler.isHandlerClosed()){
			setWebClientHandler(null);
			logger.debug("commitResponse done end of keepAlive.handler:"+handler);
			closeServerHandleOnce(handler);
			return false;
		}
		if(handler.orderCount()!=0){//order(write)cĂ
			return false;
		}
		if(webClientHandler!=null){
			if(!webClientHandler.isKeepAlive()){
				setWebClientHandler(null);
			}
		}
		logger.debug("commitResponse.handler.orderCount():"+handler.orderCount());
		logger.debug("commitResponse done keepAlive.handler:"+handler);
		logger.debug("commitResponse done keepAlive.webClientHandler:"+webClientHandler);
		isSendLastChunk=isChunked=isProxy=isKeepAlive=isAllowChunked=false;
		handler.setReadTimeout(keepAliveTimeout);
		handler.waitForNextRequest();
		return true;
	}
	
	public void finishedOfServerHandler(){
		setWebClientHandler(null);
	}
	
	/*
	public String getSslPeekServer() {
		return sslPeekServer;
	}

	public void setSslPeekServer(String sslPeekServer) {
		this.sslPeekServer = sslPeekServer;
	}

	public int getSslPeekPort() {
		return sslPeekPort;
	}

	public void setSslPeekPort(int sslPeekPort) {
		this.sslPeekPort = sslPeekPort;
	}
	*/

	public RequestContext getRequestContext() {
		if(requestContext==null){
			requestContext=(RequestContext) PoolManager.getInstance(RequestContext.class);
		}
		return requestContext;
	}
	
	public void endOfResponse(){
		if(requestContext!=null){
			requestContext.unref(true);
			requestContext=null;
		}
	}

	public MappingResult getSslProxyMapping() {
		return sslProxyMapping;
	}

	public void setSslProxyMapping(MappingResult sslProxyMapping) {
		this.sslProxyMapping = sslProxyMapping;
	}

	public String getRealHostName() {
		return realHostName;
	}

	public void setRealHostName(String realHostName) {
		this.realHostName = realHostName;
	}
}
