package naru.phantom.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import naru.async.pool.BuffersUtil;
import naru.async.pool.PoolBase;
import naru.async.pool.PoolManager;
import naru.async.store.Page;

public class GzipContext extends PoolBase{
	private GZIPOutputStream gzipOutputStream;
	private GZIPInputStream gzipInputStream;
	private ZipedOutputStream zipedOutputStream=new ZipedOutputStream();
	private ZipedInputStream zipedInputStream=new ZipedInputStream();
	//t@CgȂStore
	private Page page=new Page();
	private long inputLength;
	private long outputLength;
	
	public void recycle() {
		if(gzipOutputStream!=null){
			try {
				gzipOutputStream.close();
			} catch (IOException ignore) {
			}
			gzipOutputStream=null;
		}
		if(gzipInputStream!=null){
			try {
				gzipInputStream.close();
			} catch (IOException ignore) {
			}
			gzipInputStream=null;
		}
		page.recycle();
		inputLength=outputLength=0;
		super.recycle();
	}
	
	public void putPlainBuffer(ByteBuffer[] buffers){
		for(int i=0;i<buffers.length;i++){
			putPlainBuffer(buffers[i]);
		}
	}
	
	public void putPlainBuffer(ByteBuffer buffer){
		try {
			inputLength=buffer.remaining();
			if(gzipOutputStream==null){
				gzipOutputStream=new GZIPOutputStream(zipedOutputStream);
			}
			synchronized(gzipOutputStream){//closeƃobeBOƖ[vƂȂ
				byte[] writeBytes=new byte[buffer.remaining()];
				buffer.get(writeBytes);
				gzipOutputStream.write(writeBytes);
			}
			PoolManager.poolBufferInstance(buffer);
		} catch (IOException e) {
			throw new IllegalStateException("fail to gzipOutputStream.write",e);
		}
	}
	
	public ByteBuffer[] getZipedBuffer(boolean isLast){
		if(gzipOutputStream==null){
			return null;
		}
		try {
			synchronized(gzipOutputStream){//writeƃobeBOƖ[vƂȂ
				if(isLast){
					gzipOutputStream.close();
				}else{
					gzipOutputStream.flush();
				}
			}
		} catch (IOException e) {
			throw new IllegalStateException("fail to gzipOutputStream.getZipedBuffer",e);
		}
		ByteBuffer[] buffers=page.getBuffer();
		if(buffers!=null){
			outputLength+=BuffersUtil.remaining(buffers);
		}
		return buffers;
	}
	
	public ByteBuffer[] getZipedBuffer(boolean isLast,ByteBuffer[] src){
		try {
			if(gzipOutputStream==null){
				gzipOutputStream=new GZIPOutputStream(zipedOutputStream);
			}
			synchronized(gzipOutputStream){//writeƃobeBOƖ[vƂȂ
				putPlainBuffer(src);
				if(isLast){
					gzipOutputStream.close();
				}else{
					gzipOutputStream.flush();
				}
			}
		} catch (IOException e) {
			throw new IllegalStateException("fail to gzipOutputStream.getZipedBuffer",e);
		}
		ByteBuffer[] buffers=page.getBuffer();
		if(buffers!=null){
			outputLength+=BuffersUtil.remaining(buffers);
		}
		return buffers;
	}
	
	public void putZipedBuffer(ByteBuffer[] buffers){
		inputLength=BuffersUtil.remaining(buffers);
		page.putBuffer(buffers,false);
	}
	
	public void putZipedBuffer(ByteBuffer buffers){
		inputLength=buffers.remaining();
		page.putBuffer(buffers,false);
	}
	
	private boolean fillBuffer(ByteBuffer buffer) throws IOException{
		while(buffer.hasRemaining()){
			//storebuffer̂mFĂread
			if(zipedInputStream.isBuffer()==false){
				buffer.flip();
				return false;//obt@s
			}
			synchronized(gzipInputStream){
				int pos=buffer.position();
				int len=gzipInputStream.read(buffer.array(),pos,buffer.remaining());
				buffer.position(pos+len);
			}
		}
		buffer.flip();
		return true;//
	}
	
	public ByteBuffer[] getPlainBuffer(){
		ArrayList<ByteBuffer> bufs=new ArrayList<ByteBuffer>();
		try {
			ByteBuffer[] ziped=page.getBuffer();
			if(ziped==null){
				return null;
			}
			zipedInputStream.putBuffers(ziped);
			if(gzipInputStream==null){
				gzipInputStream=new GZIPInputStream(zipedInputStream);
			}
			while(true){
				ByteBuffer buffer=PoolManager.getBufferInstance();
				if( fillBuffer(buffer)==false ){
					if(buffer.hasRemaining()){
						bufs.add(buffer);
					}else{
						PoolManager.poolBufferInstance(buffer);
					}
					break;
				}
				bufs.add(buffer);
			}
		} catch (IOException e) {
			throw new IllegalStateException("fail to gzipOutputStream.write",e);
		}
		if(bufs.size()==0){
			return null;
		}
		ByteBuffer[] buffers=bufs.toArray(new ByteBuffer[bufs.size()]);
		outputLength+=BuffersUtil.remaining(buffers);
		return buffers;
	}
	
	private class ZipedOutputStream extends OutputStream{
		public void close() throws IOException {
		}
		public void flush() throws IOException {
		}
		public void write(byte[] src, int offset, int length) throws IOException {
			page.putBytes(src, offset, length);
		}
		public void write(byte[] src) throws IOException {
			write(src,0,src.length);
		}
		public void write(int src) throws IOException {
			write(new byte[]{(byte)src},0,1);
		}
	}
	
	private class ZipedInputStream extends InputStream{
		private ArrayList<ByteBuffer> buffers=new ArrayList<ByteBuffer>();
		public void putBuffers(ByteBuffer[] buffers){
			for(int i=0;i<buffers.length;i++)
				this.buffers.add(buffers[i]);
		}
		public boolean isBuffer(){
			return (buffers.size()!=0);
		}
		
		public void close() throws IOException {
		}
		public void flush() throws IOException {
		}
		public int read() throws IOException {
			byte[] b=new byte[1];
			if( read(b)<=0 ){
				return -1;
			}
			return (int)(b[0]&0xff);
		}
		public int read(byte[] b) throws IOException {
			return read(b,0,b.length);
		}
		public int read(byte[] b, int off, int len) throws IOException {
			synchronized(buffers){
				ByteBuffer buffer=buffers.get(0);
				int remaining=buffer.remaining();
				int length=remaining;
				if(len<length){
					length=len;
				}
				int pos=buffer.position();
				System.arraycopy(buffer.array(), pos, b, off, length);
				buffer.position(pos+length);
				if(buffer.remaining()==0){
					PoolManager.poolBufferInstance(buffer);
					buffers.remove(0);
					buffer=null;
				}
				return length;
			}
		}
	}

	public long getInputLength() {
		return inputLength;
	}

	public long getOutputLength() {
		return outputLength;
	}
	
}
