package naru.phantom.http;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

import naru.async.pool.BuffersUtil;
import naru.phantom.util.HeaderParser;

public class ChunkContext {
	private static int MODE_CHUNK_START=0;
	private static int MODE_CHUNK_START_R=1;
	private static int MODE_CHUNK=2;
	private static int MODE_CHUNK_END_R=3;
	private static int MODE_CHUNK_DATA=4;
	private static int MODE_END_OF_DATA=5;
	private static final byte[] DATA_AND_LAST_CHUNK="\r\n0\r\n\r\n".getBytes();
	private static final byte[] LAST_CHUNK="0\r\n\r\n".getBytes();
	public static final byte[] CRLF = "\r\n".getBytes();
	
	private boolean isChunked;
	private long contentLength;
	private long processContentLength;
	
	private long nextChunk;
	private boolean isSendLastChunk;
	private int mode;
	private int chunkBufferPtr;
	private byte[] chunkBuffer=new byte[1024];
	
	public void encodeInit(boolean isChunked){
		this.isChunked=isChunked;
		this.isSendLastChunk=false;
	}
	
	/**
	 * 
	 * @param buffers@null̏ꍇX|XI[킷
	 * @return
	 */
	public ByteBuffer[] encodeChunk(boolean isLast,ByteBuffer[] buffers){
		if(!isChunked){
			return buffers;
		}
		ByteBuffer head=null;
		if(buffers==null){
			if(isLast && !isSendLastChunk){
				isSendLastChunk=true;
				return new ByteBuffer[]{ByteBuffer.wrap(LAST_CHUNK)};
			}
			/* buffersnullōŌ̃f[^ȂƂُ͈̂ */
			throw new IllegalArgumentException("chunkedIfNeed");
		}else{
			long length=BuffersUtil.remaining(buffers);
			String headString=Long.toHexString(length)+"\r\n";
			head=ByteBuffer.wrap(headString.getBytes());
		}
		ByteBuffer tail=null;
		if(isLast){
			isSendLastChunk=true;
			tail=ByteBuffer.wrap(DATA_AND_LAST_CHUNK);
		}else{
			tail=ByteBuffer.wrap(CRLF);
		}
		ByteBuffer[] chunkedBuffer=BuffersUtil.concatenate(head, buffers, tail);
		return chunkedBuffer;
	}
	
	private boolean nextMode(byte c){
		if(mode==MODE_CHUNK){
			if(c=='\r'){
				mode=MODE_CHUNK_END_R;
				return false;
			}
			if(chunkBufferPtr>=chunkBuffer.length){
				String msg=null;
				try {
					msg=new String(chunkBuffer,"utf-8");
					msg=new String(chunkBuffer,HeaderParser.HEADER_ENCODE);
				} catch (UnsupportedEncodingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				throw new IllegalStateException("too long chunk.chunk:"+new String(chunkBuffer));
			}
			chunkBuffer[chunkBufferPtr]=c;
			chunkBufferPtr++;
			return false;
		}else if(mode==MODE_CHUNK_END_R){
			if(c=='\n'){
				mode=MODE_CHUNK_DATA;
				String chunk=null;
				try {
					chunk = new String(chunkBuffer,0,chunkBufferPtr,HeaderParser.HEADER_ENCODE);
				} catch (UnsupportedEncodingException e) {
					throw new IllegalStateException("nextMode.MODE_CHUNK_END_R",e);
				}
				nextChunk=Long.parseLong(chunk.split(" ")[0],16);
				if(nextChunk==0){
					mode=MODE_END_OF_DATA;
				}
				return true;
			}else{
				if(chunkBufferPtr>=(chunkBuffer.length-1)){
					throw new IllegalStateException("too long chunk. chunk:"+new String(chunkBuffer));
				}
				chunkBuffer[chunkBufferPtr]='\r';
				chunkBufferPtr++;
				chunkBuffer[chunkBufferPtr]=c;
				chunkBufferPtr++;
				mode=MODE_CHUNK;
				return false;
			}
		}else if(mode==MODE_CHUNK_START){
			if(c==(byte)'\r'){
				mode=MODE_CHUNK_START_R;
				return false;
			}
			throw new IllegalStateException("nextMode.MODE_CHUNK_START c:"+c);
		}else if(mode==MODE_CHUNK_START_R){
			if(c=='\n'){
				mode=MODE_CHUNK;
				chunkBufferPtr=0;
				return false;
			}
			throw new IllegalStateException("nextMode.MODE_CHUNK_START_R c:"+c);
		}
		throw new IllegalStateException("nextMode.illegalmode mode:"+mode);
	}
	
	private boolean readChunk(ByteBuffer[] body){
		for(int i=0;i<body.length;i++){
			ByteBuffer buf=body[i];
			while(buf.hasRemaining()){
				if( nextMode(buf.get()) ){
					return true;
				}
			}
		}
		return false;
	}
	
	public void decodeInit(boolean isChunked,long contentLength){
		this.isChunked=isChunked;
		this.contentLength=contentLength;
		this.processContentLength=0;
		mode=MODE_CHUNK;
		
	}
	
	public boolean isLastData(ByteBuffer[] body){
		if(!isChunked){
			long processLength=BuffersUtil.remaining(body);
			processContentLength += processLength;
			if (contentLength <= processContentLength) {
				return true;
			}
			return false;
		}
		if(body==null){
			return (mode==MODE_END_OF_DATA);
		}
		BuffersUtil.mark(body);
		while(true){
			if( mode!=MODE_CHUNK_DATA ){
				if(readChunk(body)==false){
					BuffersUtil.reset(body);
					return false;
				}
			}
			if( mode==MODE_END_OF_DATA ){
				BuffersUtil.reset(body);
				return true;
			}
			long processLength=BuffersUtil.remaining(body);
			if(nextChunk>processLength){
				nextChunk-=processLength;
				BuffersUtil.reset(body);
				return false;
			}
			BuffersUtil.skip(body,nextChunk);
			nextChunk=0;
			mode=MODE_CHUNK_START;
		}
	}
	
	/*
	public ByteBuffer[] decodeChunk(ByteBuffer[] body){
		if(!isChunked){
			long processLength=BuffersUtil.remaining(body);
			processContentLength += processLength;
			if (contentLength <= processContentLength) {
				return body;
			}
			return body;
		}
		BuffersUtil.mark(body);
		while(true){
			if( mode!=MODE_CHUNK_DATA ){
				if(readChunk(body)==false){
					BuffersUtil.reset(body);
					return false;
				}
			}
			if( mode==MODE_END_OF_DATA ){
				BuffersUtil.reset(body);
				return true;
			}
			long processLength=BuffersUtil.remaining(body);
			if(nextChunk>processLength){
				nextChunk-=processLength;
				BuffersUtil.reset(body);
				return false;
			}
			BuffersUtil.skip(body,nextChunk);
		}
	}
	*/
}
