﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns="http://www.w3.org/1999/xhtml"> 
    <xsl:output 
        omit-xml-declaration="no" 
        encoding="utf-8" 
        method="html" 
        version="1.0" 
        doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" 
        doctype-system="http://www.w3.org/TR/html4/loose.dtd" 
        indent="yes" /> 
    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>

<xsl:template match="comic">
	<html xmlns:v="urn:schemas-microsoft-com:vml">
		<head>
			<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
			<meta http-equiv="Content-Style-Type" content="text/css" />
			<meta http-equiv="imagetoolbar" content="no" />
			<meta name="description">
				<xsl:attribute name="content">
					<xsl:value-of select="@description" />
				</xsl:attribute>
			</meta>
			<title>
	            <xsl:if test="@subtitle">
	                <xsl:value-of select="concat(@episode,' | ')"/>
	            </xsl:if>
				<xsl:value-of select="@title" />
	            <xsl:if test="@author">
	                <xsl:value-of select="concat(' | ',@author)"/>
	            </xsl:if>
			</title>
			<link rel='index' title='index | pettanR' href='http://pettanr.sourceforge.jp/index.html' />
			<link rel='start' title='pettanR' href='http://pettanr.sourceforge.jp/' />
			<link rel="stylesheet" type="text/css" href="../stylesheets/common.css" />
			<link rel="stylesheet" type="text/css" href="pettanr.css" />
		</head>
		<body>
			<div id="general-content">
				<div id="outer-wrapper">
					
					<div id="header">
						<div class="base-content-width" style="position:relative;">
							<h1><a href="http://pettanr.sourceforge.jp/">pettanR</a></h1>
							<div id="global-navi">
								<noscript id="noscript-alert">You need to have JavaScript enabled.</noscript>
							</div>
						</div>
					</div>
					
					<div id="inner-wrapper" class="base-content-width">
						<div id="main">
							<div id="breadcrumb"><a href="index.html">テスト インデックス</a> &gt; xml テスト</div>
							<h2><xsl:value-of select="@title" /></h2>
							<h3><xsl:value-of select="@episode" /></h3>
							<p class='author'>author:<xsl:value-of select="@author" /></p>
							<div id="panelContainer">
								<xsl:attribute name="style">
									<xsl:value-of select="concat('width:',@w,'px;')"/>
								</xsl:attribute>
								
								<xsl:apply-templates/>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<div id="footer-content"><!-- #BeginLibraryItem "/Library/footer.lbi" -->

        <div id="footer">
            <div id="footer-item-container" class="base-content-width clearfix">
                <div class="footer-item-wrapper">
                    <div class="footer-item">
                        <h2>ぺったんR にようこそ</h2>
                        <ul>
                            <li>サンプル</li>
                            <li>ぺったんRの特徴</li>
                            <li>沿革</li>
                        </ul>
                        <h2>Test</h2>
                        <ul>
                            <li><a href="../test/index.html">Test Index</a></li>
                        </ul>
                    </div>
                </div>
                <div class="footer-item-wrapper">
                    <div class="footer-item">
                        <h2>ドキュメント</h2>
                        <ul>
                            <li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForAuthors" rel="me" target="_blank">作家向けドキュメント</a></li>
                            <li>絵師向けドキュメント</li>							
                            <li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForDevelopers" rel="me" target="_blank">開発者向けドキュメント</a></li>
                            <li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForWebmasters" rel="me" target="_blank">編集長向けドキュメント</a></li>
                        </ul>
                    </div>
                </div>
                <div class="footer-item-wrapper">
                    <div class="footer-item">
                        <h2>プロトタイプ</h2>
                        <ul>
                            <li><a href="http://pettanr.heroku.com/" rel="me" target="_blank">pettanr.heroku.com</a></li>
                            <li><a href="../work.html" rel="console">ユーザーコンソール</a></li>
                        </ul>
                        <h2>Ajax contents</h2>
                        <ul>
                            <li><a href="jp.xml">help | jp</a></li>
                        </ul>
                    </div>
                </div>
                <div class="footer-item-wrapper" style="width:170px;">
                    <div class="footer-item" style="padding-right:0;">
                        <h2>ぺったんRチーム</h2>
                        <ul>
                            <li>わたしたちについて</li>
                            <li>ミッション</li>
                            <li><a href="../diary/itozyun.xml">itozyun's diary</a></li>
                            <li>個人情報保護方針</li>
                            <li>作品の取り扱い</li>
                            <li>お問い合わせ</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div id="copyright">Copyright (c) <xsl:value-of select="/comic/@author" />, comic publishing system 'pettanR' is powered by pettanR team.</div>
        </div><!-- #EndLibraryItem --></div>
			<script type="text/javascript" src="../javascripts/common.js"></script>
		</body>
	</html>
</xsl:template>

    <xsl:template match="panel">
    	<div class="panel-wrapper">
			<xsl:for-each select=".">
				<div class="panel">
					<xsl:variable name="height" select="concat('height:',@h,'px;')" />
					<xsl:variable name="bgcolor" select="concat('background-color:',@bgcolor,';')" />
					<xsl:attribute name="style">
						<xsl:value-of select="concat($height,$bgcolor)"/>
					</xsl:attribute>
					<xsl:apply-templates/>
				</div>
			</xsl:for-each>
			<xsl:for-each select="./picture">
				<xsl:if test="@name">
					
					<div class="tooltip-container">
						<xsl:comment><![CDATA[[if lte IE 6]><a href="#"><table><tr><td><![endif]]]></xsl:comment>
						<img src="4x4.gif" class="image-shadow"><!-- 当初divで書いていたら、ie5.5～8で正しくレンダリングできない。なぜかDomが狂う、、、xsl:attribute name="style"が頭にきたせい? -->
							<xsl:attribute name="width">
								<xsl:value-of select="@w"/>
							</xsl:attribute>
							<xsl:attribute name="height">
								<xsl:value-of select="@h"/>
							</xsl:attribute>
							<xsl:attribute name="style">
								<xsl:value-of select="concat('left:',@x,'px;','top:',@y,'px;')"/>
							</xsl:attribute>
						</img>
						<dl class="tooltip">
							<xsl:attribute name="style">
								<xsl:value-of select="concat('margin-left:',position(),'9px;left:',/comic/@w,'px;','top:',@y,'px;')"/><!-- 要素が完全に重なることを防ぐためにposition()で要素のindexを取ってmargin-leftしている -->
							</xsl:attribute>
							<dt>作品名</dt>
							<dd><xsl:value-of select="@name" /></dd>
							<dt>作者</dt>
							<dd><xsl:value-of select="@author" /></dd>
							<dt>サイト</dt>
							<dd><xsl:value-of select="@site" /></dd>
						</dl>
						<xsl:comment><![CDATA[[if lte IE 6]></td></tr></table></a><![endif]]]></xsl:comment>
					</div>
					
				</xsl:if>
			</xsl:for-each>
		</div>
    </xsl:template>

    <xsl:template match="picture">
		<xsl:for-each select=".">
			<img>
				<xsl:attribute name="src">
					<xsl:value-of select="@url"/>
				</xsl:attribute>
				<xsl:attribute name="width">
					<xsl:value-of select="@w"/>
				</xsl:attribute>
				<xsl:attribute name="height">
					<xsl:value-of select="@h"/>
				</xsl:attribute>
				<xsl:variable name="left" select="concat('left:',@x,'px;')" />				
				<xsl:variable name="top" select="concat('top:',@y,'px;')" />	
				<xsl:attribute name="style">
					<xsl:value-of select="concat($left,$top)"/>
				</xsl:attribute>
			</img>
		</xsl:for-each>		
    </xsl:template>

    <xsl:template match="balloon">
		<xsl:for-each select=".">
			<img>
		        <xsl:variable name="type">
		            <xsl:if test="contains(@type,'0')">../system_pictures/_w</xsl:if>
		            <xsl:if test="contains(@type,'1')">../system_pictures/think</xsl:if>
		        </xsl:variable>
				<xsl:attribute name="src">
					<xsl:value-of select="concat($type,@tail,'.gif')"/>
				</xsl:attribute>
				<xsl:attribute name="width">
					<xsl:value-of select="@w"/>
				</xsl:attribute>
				<xsl:attribute name="height">
					<xsl:value-of select="@h"/>
				</xsl:attribute>
				<xsl:variable name="left" select="concat('left:',@x,'px;')" />			
				<xsl:variable name="top" select="concat('top:',@y,'px;')" />
				<xsl:attribute name="style">
					<xsl:value-of select="concat($top,$left)"/>
				</xsl:attribute>
			</img>
			
			<div class="speach">
				<xsl:variable name="width" select="concat('width:',@w,'px;')" />			
				<xsl:variable name="height" select="concat('height:',@h,'px;')" />
				<xsl:variable name="left2" select="concat('left:',@x,'px;')" />			
				<xsl:variable name="top2" select="concat('top:',@y,'px;')" />	
				<xsl:variable name="fontsize">
		            <xsl:if test="@size">
		                <xsl:value-of select="concat('font-size:',@size,'px;')"/>
		            </xsl:if>
				</xsl:variable>
				<xsl:variable name="fontbold">
		            <xsl:if test="@bold">font-weight:bold;</xsl:if>
				</xsl:variable>
				<xsl:attribute name="style">
					<xsl:value-of select="concat($width,$height,$top2,$left2,$fontsize,$fontbold)"/>
				</xsl:attribute>
				<xsl:comment><![CDATA[[if lte IE 7]><table><tr><td><![endif]]]></xsl:comment>
					<span>
					<xsl:apply-templates/>
					</span>
				<xsl:comment><![CDATA[[if lte IE 7]></td></tr></table><![endif]]]></xsl:comment>
			</div>
		</xsl:for-each>		
    </xsl:template>

</xsl:stylesheet>