﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns="http://www.w3.org/1999/xhtml"> 
    <xsl:output 
        omit-xml-declaration="no" 
        encoding="utf-8" 
        method="html" 
        version="1.0" 
        doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" 
        doctype-system="http://www.w3.org/TR/html4/loose.dtd" 
        indent="yes" /> 
    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>
	
<xsl:template match="urlset">
	<html>
		<head>
			<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
			<meta http-equiv="Content-Style-Type" content="text/css" />
			<meta http-equiv="imagetoolbar" content="no" />
			<meta name="description" content="this is sitemap" />
			<title>sitemap | pettanR</title>
			<link rel='index' title='index | pettanR' href='http://pettanr.sourceforge.jp/index.html' />
			<link rel='start' title='pettanR' href='http://pettanr.sourceforge.jp/' />
			<link rel="stylesheet" type="text/css" href="../stylesheets/common.css" />
		</head>
		<body>
			<div id="general-content">
				<div id="outer-wrapper">
					
					<div id="header">
						<div class="base-content-width" style="position:relative;">
							<h1><a href="http://pettanr.sourceforge.jp/">pettanR</a></h1>
							<div id="global-navi">
								<noscript id="noscript-alert">You need to have JavaScript enabled.</noscript>
							</div>
						</div>
					</div>
					
					<div id="inner-wrapper" class="base-content-width">
						<div id="main">
							<h2>sitemap</h2>
														
							<xsl:apply-templates/>
						</div>
					</div>
				</div>
			</div>
			
			<div id="footer-content">
				<div id="footer">
					<div id="footer-item-container" class="base-content-width clearfix">
						<div class="footer-item-wrapper">
							<div class="footer-item">
								<h2>ぺったんR にようこそ</h2>
								<ul>
									<li>サンプル</li>
									<li>ぺったんRの特徴</li>
									<li>沿革</li>
								</ul>
							</div>
						</div>
						<div class="footer-item-wrapper">
							<div class="footer-item">
								<h2>ドキュメント</h2>
								<ul>
                                    <li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForAuthors" rel="me" target="_blank">作家向けドキュメント</a></li>
                                    <li>絵師向けドキュメント</li>                         
                                    <li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForDevelopers" rel="me" target="_blank">開発者向けドキュメント</a></li>
                                    <li><a href="http://sourceforge.jp/projects/pettanr/wiki/ForWebmasters" rel="me" target="_blank">編集長向けドキュメント</a></li>
								</ul>
							</div>
						</div>
						<div class="footer-item-wrapper">
							<div class="footer-item">
								<h2>プロトタイプ</h2>
								<ul>
									<li><a href="http://pettanr.heroku.com/" rel="me" target="_blank">pettanr.heroku.com</a></li>
									<li><a href="../work.html" rel="console">ユーザーコンソール</a></li>
								</ul>
								<h2>Ajax contents</h2>
								<ul>
									<li><a href="../help/jp.xml">help | jp</a></li>
								</ul>
							</div>
						</div>
						<div class="footer-item-wrapper" style="width:170px;">
							<div class="footer-item" style="padding-right:0;">
								<h2>ぺったんRチーム</h2>
								<ul>
									<li>わたしたちについて</li>
									<li>ミッション</li>
									<li><a href="../diary/itozyun.xml">itozyun's diary</a></li>
									<li>個人情報保護方針</li>
									<li>作品の取り扱い</li>
									<li>お問い合わせ</li>
								</ul>
							</div>
						</div>
					</div>
					<div id="copyright">
						Copyright (c) 2011-2012 pettanR team, some rights reserved.
					</div>
				</div>
			</div>
			<script type="text/javascript" src="../javascripts/common.js"></script>
		</body>
	</html>
</xsl:template>

    <xsl:template match="url">
    	<dl class="dl-table clearfix">
		<xsl:for-each select=".">
			<xsl:apply-templates/>
		</xsl:for-each>
		</dl>
    </xsl:template>

    <xsl:template match="loc">
		<dt>
    		<a>
    			<xsl:attribute name="href">
    				<xsl:apply-templates/>
    			</xsl:attribute>
    			<xsl:apply-templates/>
    		</a>
		</dt>
		<dd><xsl:apply-templates/></dd>
    </xsl:template>
    <xsl:template match="lastmod">
		<dd class="lastmod">
			<xsl:apply-templates/>
		</dd>
    </xsl:template>	
    <xsl:template match="priority">
		<dd class="priority">
			<xsl:apply-templates/>
		</dd>
    </xsl:template>	

</xsl:stylesheet>