﻿/*
 * pettanR common.js
 *   version 0.1.0
 * 
 * author: itozyun
 */

( function(){
	var noscripts = document.getElementsByTagName('NOSCRIPT'),
		noscript;
	for(var i=0; i<noscripts.length; ++i){
		noscript = noscripts[i];
		noscript.parentNode && noscript.parentNode.removeChild( noscript);
	}
	
	var location = document.location.pathname,
		isWorkPage = location.indexOf( '\/work.html') !== -1,
		deep =	location.indexOf( '\/diary\/') !== -1 ||
				location.indexOf( '\/text\/') !== -1 ||
				location.indexOf( '\/help\/') !== -1 ||
				location.indexOf( '\/sitemap\/') !== -1 ||
				location.indexOf( '\/wiki\/') !== -1;

	var LoginUserConsole = isWorkPage === false ?
		( function(){
			var _body = document.body,
				_root = document.getElementsByTagName( 'HTML')[ 0],
				filter,
				iframe, visible = false;
			return {
				init: function(){
					filter = document.createElement( 'DIV');
					filter.style.position = 'absolute';
					filter.style.left = filter.style.top = '0px';
					filter.style.width = filter.style.height ='100%';
					filter.style.backgroundColor = '#fff';
	
					var id = 'work',
						src = deep === true ? '../work.html' : 'work.html';
					
					var el = document.createElement(ua.isIE ? '<iframe name="' + id + '" src="' + src + '">' : 'iframe');
					el.id = el.name = id;
					el.setAttribute( 'name', id);
					
					el.style.position = 'absolute';
					el.style.left = el.style.top = '0px';
					el.style.width = el.style.height ='100%';
					el.style.overflow = 'hidden';
					el.hspace = el.vspace = el.marginheight = el.marginwidth = 0;
					
					_body.appendChild(el);
					window[id] = el;
					iframe = el;
					
					if (!ua.isIE) {
						var idoc;//WebKit > 521 corresponds with Safari 3, which started with 522 WebKit version.
						if (ua.isWebKit > 521) {
							idoc = el.contentWindow.document;
						} else if (ua.isSafari) {
							idoc = el.document;
						} else { //  if(d.isMozilla){
							idoc = el.contentWindow;
						}
						
						if ( !idoc) {
							try {
								el.src = src;
								el.contentWindow.location.replace = src;							
							} catch (e){}
							try {
								//el.contentWindow.location = src;							
							} catch (e){}
							try {
								el.location = src; // for Safari 2.0.3 ??
							} catch (e){}
							
						} else if( ua.isOpera){
							el.src = src; // for Opera
							el.contentWindow.location.replace = src; // for Opera
						} else {
							//el.src = src; // for firefox
							idoc.location.replace(src);
						}
					}
					
					delete LoginUserConsole.init;
				},
				show: function(){
					if(visible === true) return;
					if (_root) {
						_root.style.overflow = 'hidden';
					}
					_body.style.overflow = 'hidden';
					
					LoginUserConsole.init && LoginUserConsole.init();
					
					iframe.parentNode !== _body && _body.appendChild(iframe);
					
					_body.insertBefore(filter, iframe);				
					
					visible = true;
				},
				hide: function(){
					if(visible === false) return;
					
					_body.removeChild(filter);
					_body.style.overflow = '';
					if (_root) {
						_root.style.overflow = '';
					}
					_body.removeChild(iframe);
					
					visible = false;
				}
			}
		})() :
		( function(){
			return {
				show: function(){
					h2c.view.show( h2c.editor);
				},
				hide: function(){}
			}
		})();

	var ua = (function(){
			var acme = {};
			
			var n = navigator;
			var dua = n.userAgent;
			var dav = n.appVersion;
			var tv = parseFloat(dav);
			acme.isOpera = (dua.indexOf("Opera") >= 0) ? tv: undefined;
			acme.isKhtml = (dav.indexOf("Konqueror") >= 0) ? tv : undefined;
			acme.isWebKit = parseFloat(dua.split("WebKit/")[1]) || undefined;
			acme.isChrome = parseFloat(dua.split("Chrome/")[1]) || undefined;
			var index = Math.max(dav.indexOf("WebKit"), dav.indexOf("Safari"), 0);
			if(index && !acme.isChrome){
				acme.isSafari = parseFloat(dav.split("Version/")[1]);
				if(!acme.isSafari || parseFloat(dav.substr(index + 7)) <= 419.3){
					acme.isSafari = 2;
				}
			}
			if(document.all && !acme.isOpera){
				acme.isIE = parseFloat(dav.split("MSIE ")[1]) || undefined;
			}
			
			return acme;
		})();
	
	var navi = document.getElementById('global-navi'),
		origin = document.createElement('A'),
		items = ['Home', 'Comic list', 'Picture', 'Setting'],
		l = items.length,
		item;
	for(var i=0; i<l; ++i){
		item = origin.cloneNode(true);
		item.innerHTML = items[i];
		item.href = '#';
		item.onclick = LoginUserConsole.show;
		navi.appendChild(item);
	}
})();

var _gaq = _gaq || [];
_gaq.push(['_setAccount', 'UA-28023955-1']);
_gaq.push(['_trackPageview']);

(function() {
	var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
	ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
	var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
})();