/**
 *  sourceforge wiki.xml to multi page html
 *  version 1.1.2
 */

( function(){
	var startTime = ( new Date()).getTime(),
		DOC = document,
		CLEAN_TARGET_ELEMENT = 'script,style,object,applet,embed,iframe,frame,base,bgsound,frameset,listing'.split( ','),
		root = DOC.getElementById('wiki-container'),
		navi = DOC.getElementById('page-navi-container'),
		ELM_BODY_CONTAINER = DOC.getElementById('page-body-container'),
		titleArray = [],
		anchorArray = [],
		elmBuilder = DOC.createElement( 'div'),
		WikiPageClass = function( id, title, elmNavi, elmAnchor, elmWrapper, elmBody){
			var visible = false;
			
			titleArray.push( title);
			anchorArray.push( elmAnchor);
			
			elmAnchor.onclick = jumpPage;
			
			setTimeout( buildInnerLink, 0);
			
			function buildInnerLink(){
				var _nodes = elmBody.getElementsByTagName( 'a'),
					i, l = _nodes.length,
					_array = [],
					_jump, _index;
				for( i=0; i<l; ++i){
					_array.push( _nodes[ i]);
				}
				while( _array.length > 0){
					_jump = _array.shift();
					_index = getPageIndexByTitle( _jump.childNodes[0].nodeValue);
					if( _index !== -1){
						_jump.href = '#page' +( _index +1);
						_jump.onclick = jumpPage;
						_jump.className += ' internalLink';						
					} else {
						_jump.target = '_blank';
						_jump.className += ' externalLink';
					}
				}
			}
			
			return {
				fixCommentToHtml: function(){
					elmBuilder.innerHTML = elmBody.childNodes[0].nodeValue.replace( /\[\[BR\]\]/g, '');
					cleanElement( elmBuilder);

					var _fragment = DOC.createDocumentFragment();
					while( elmBody.firstChild){
						elmBody.removeChild( elmBody.firstChild);
					}
					while( elmBuilder.firstChild){
						_fragment.appendChild( elmBuilder.firstChild);
					}
					elmBody.appendChild( _fragment);
					delete this.fixCommentToHtml;
				},
				show: function( _id){
					if( id === _id && visible === false){
						elmWrapper.className = 'page-wrapper-current';
						elmWrapper.style.display = 'block';
						elmNavi.className = 'page-navi-current';
						ELM_BODY_CONTAINER.appendChild( elmWrapper);
						visible = true;
					}
					if( id !== _id && visible === true){
						elmWrapper.className = 'page-wrapper';
						elmWrapper.style.display = '';
						elmNavi.className = 'page-navi';
						ELM_BODY_CONTAINER.removeChild( elmWrapper);
						visible = false;
					}
				}
			}
		},
		hierarchyTmp = {},
		wikiPageArray = ( function(){
			var ret = [],
				_body = DOC.body,
				_children = ( function(){
					var _ret = [],
						_nodes = navi.getElementsByTagName( 'li');
					for( var i=0, l=_nodes.length; i<l; ++i){
						_ret.push( _nodes[ i]);
					}
					return _ret;
				})(),
				l = _children.length,
				_child, _a, _title, _id, _wrap,
				_page;
				
			_body.appendChild( elmBuilder);

			for(var i=0; i<l; ++i){
				_child = _children[i];
				if( _child.className.indexOf( 'page-navi') !== -1){
					_a = _child.getElementsByTagName( 'a')[0];
					_title = _a ? _a.firstChild.nodeValue : null;
					_id = _a ? _a.href.split('#')[1] : null;
					_wrap = DOC.getElementById( _id);
					_page = new WikiPageClass( _id, _title, _child, _a, _wrap, _wrap.getElementsByTagName( 'div')[1]);
					!DOC.all && _page.fixCommentToHtml();
					ret.push( _page);
				}
			}
			_body.removeChild( elmBuilder);
			
			return ret;
		})(),
		NUM_PAGE = wikiPageArray.length,
		FRONT_ID = 'FrontPage',
		FRONT_INDEX = getPageIndexByTitle( FRONT_ID) +1,
		CLASS_OPEN = 'expander-open',
		CLASS_CLOSE = 'expander-close',
		ANGLE_OPEN = String.fromCharCode( 9660),
		ANGLE_CLOSE = String.fromCharCode( 9658),
		hash = DOC.location.href.split('#')[1],
		i, j, l, _array,
		_fragment = DOC.createDocumentFragment(),
		_elmOrign = ( function(){
			var ret = DOC.createElement( 'li'),
				a = DOC.createElement( 'a'),
				toggle = DOC.createElement( 'span'),
				title = DOC.createElement( 'span'),
				count = DOC.createElement( 'span'),
				ul = DOC.createElement( 'ul');
			ret.appendChild( a);
			a.className = 'group';
			a.href = '#';

			toggle.appendChild( DOC.createTextNode( ANGLE_CLOSE));
			a.appendChild( toggle);
			toggle.className = 'group-toggle';

			a.appendChild( title);
			title.className = 'group-title';
			
			a.appendChild( count);
			count.className = 'group-count';
			
			ret.appendChild( ul);
			ret.className = CLASS_CLOSE;
			return ret;
		})(),
		_elmLi, _index,
		_groupArray = [], _title,
		_group,
		_regTitle2 = /(^[A-Z][a-z0-9]+[A-Z][a-z0-9]+)\w+/,
		_regTitle1 = /(^[A-Z][a-z0-9]+)\w+/,
		_checkArray = new Array( NUM_PAGE );
	
	DOC.all && cleanElement( ELM_BODY_CONTAINER);
	
	// build hierarchy to navi
	for( i=0; i<NUM_PAGE; ++i){
		_title = titleArray[ i ];
		if( _title.match( _regTitle2)){
			_group = _title.replace( _regTitle2, '$1');
			if( !hierarchyTmp[ _group]){
				hierarchyTmp[ _group] = [];
			}
			hierarchyTmp[ _group].push( _title);
			
			if( hierarchyTmp[ _group].length === 1){
				if( _title.match( _regTitle1)){
					_group = _title.replace( _regTitle1, '$1');
					if( !hierarchyTmp[ _group]){
						hierarchyTmp[ _group] = [];
					}
					hierarchyTmp[ _group].push( _title);
				}
			}
		}
	}
	for( var _group in hierarchyTmp){
		_array = hierarchyTmp[ _group];
		if( _array.length > 1){
			_groupArray.push( _group);
		}
	}
	_groupArray.sort();
	
	for( i=_groupArray.length; i>0; --i){
		_group = _groupArray[ i - 1 ];
		_array = hierarchyTmp[ _group];
		if( _array.length > 1){
			j = 0;
			while( j<_array.length ){
				_index = getPageIndexByTitle( _array[ j ]);
				if( _index === -1 || _checkArray[ _index ] === true){
					_array.splice( j, 1);
				} else {
					_checkArray[ _index ] = true;
					++j;
				}
			}
		}
	}
	
	for( i=_groupArray.length; i>0; --i){
		_group = _groupArray[ i - 1 ];
		_array = hierarchyTmp[ _group];
		if( _array.length > 1){
			_elmLi = _elmOrign.cloneNode( true);
			for( j=0, l=_array.length; j<l; ++j){
				_index = getPageIndexByTitle( _array[ j ]);
				_index !== -1 && _elmLi.getElementsByTagName( 'ul')[ 0].appendChild( anchorArray[ _index].parentNode );
			}
			_elmLi.onclick = switchExpander;
			_elmLi.getElementsByTagName( 'span')[ 1].appendChild( DOC.createTextNode( _group));
			_elmLi.getElementsByTagName( 'span')[ 2].appendChild( DOC.createTextNode( l));
			_fragment.appendChild( _elmLi);
		}
	}
	
	navi.appendChild( _fragment);
	_array = _fragment = _elmOrign = _elmLi = _group = hierarchyTmp = root = navi = elmBuilder = _jump = null;
	
	// show current
	setTimeout(
		function(){
			jumpPage( hash && hash.match( /page\d/) ? hash : 'page' + FRONT_INDEX);
			hash = null;
		}, 0
	);
	
	DOC.getElementById( 'boot-time').appendChild( DOC.createTextNode(( new Date()).getTime() - startTime ));
	
	function cleanElement( _targetElm){
		var l = CLEAN_TARGET_ELEMENT.length,
			elms, array, elm, i, j, m;
		for( i=0; i<l; ++i){
			elms = _targetElm.getElementsByTagName( CLEAN_TARGET_ELEMENT[ i]);
			array = [];
			for( j=0, m = elms.length; j<m; ++j){
				array.push( elms[ j]);
			}
			while( array.length > 0){
				elm = array.shift();
				elm.parentNode && elm.parentNode.removeChild( elm);
			}
		}
		elms = _targetElm.getElementsByTagName( '*');
		array = [];
		for( i=0, l = elms.length; i<l; ++i){
			array.push( elms[ i]);
		}
		while( array.length > 0){
			elm = array.shift();
			if( elm.nodeType === 3){
				elm.parentNode && elm.parentNode.removeChild( elm);
			}
			if( elm.style.filter || elm.style.filter !== ''){
				elm.style.filter = '';
			}
			if( elm.style.behavior ||  elm.style.behavior !== ''){
				elm.style.behavior = '';
			}
		}
	}
	function getPageIndexByTitle( _title){
		for(var i=0; i<NUM_PAGE; ++i){
			if( titleArray[ i] === _title) return i;
		}
		return -1;
	}
	function jumpPage( id){
		var id = typeof id === 'string' ? id : this.href.split('#')[1];
		for(var i=0; i<NUM_PAGE; ++i){
			wikiPageArray[i].show( id);
		}
		return false;
	}
	function switchExpander(){
		var _open = this.className.indexOf( CLASS_CLOSE) !== -1;
		this.className = _open ? CLASS_OPEN : CLASS_CLOSE;
		this.getElementsByTagName( 'span')[ 0].firstChild.data = _open ? ANGLE_OPEN : ANGLE_CLOSE;
		return false;
	}
})();



/* Smooth scrolling
   Changes links that link to other parts of this page to scroll
   smoothly to those links rather than jump to them directly, which
   can be a little disorienting.
   
   sil, http://www.kryogenix.org/
   
   v1.0 2003-11-11
   v1.1 2005-06-16 wrap it up in an object
*/

var ss = {
  fixAllLinks: function() {
    // Get a list of all links in the page
    var allLinks = document.getElementsByTagName('a');
    // Walk through the list
    for (var i=0;i<allLinks.length;i++) {
      var lnk = allLinks[i];
      if ((lnk.href && lnk.href.indexOf('#') != -1) && 
          ( (lnk.pathname == location.pathname) ||
	    ('/'+lnk.pathname == location.pathname) ) && 
          (lnk.search == location.search)) {
        // If the link is internal to the page (begins in #)
        // then attach the smoothScroll function as an onclick
        // event handler
        ss.addEvent(lnk,'click',ss.smoothScroll);
      }
    }
  },

  smoothScroll: function(e) {
    // This is an event handler; get the clicked on element,
    // in a cross-browser fashion
    if (window.event) {
      target = window.event.srcElement;
    } else if (e) {
      target = e.target;
    } else return;

    // Make sure that the target is an element, not a text node
    // within an element
    if (target.nodeName.toLowerCase() != 'a') {
      target = target.parentNode;
    }
  
    // Paranoia; check this is an A tag
    if (target.nodeName.toLowerCase() != 'a') return;
  
    // Find the <a name> tag corresponding to this href
    // First strip off the hash (first character)
    anchor = target.hash.substr(1);
    // Now loop all A tags until we find one with that name
    var allLinks = document.getElementsByTagName('a');
    var destinationLink = null;
    for (var i=0;i<allLinks.length;i++) {
      var lnk = allLinks[i];
      if (lnk.name && (lnk.name == anchor)) {
        destinationLink = lnk;
        break;
      }
    }
    if (!destinationLink) destinationLink = document.getElementById(anchor);

    // If we didn't find a destination, give up and let the browser do
    // its thing
    if (!destinationLink) return true;
  
    // Find the destination's position
    var destx = destinationLink.offsetLeft; 
    var desty = destinationLink.offsetTop;
    var thisNode = destinationLink;
    while (thisNode.offsetParent && 
          (thisNode.offsetParent != document.body)) {
      thisNode = thisNode.offsetParent;
      destx += thisNode.offsetLeft;
      desty += thisNode.offsetTop;
    }
  
    // Stop any current scrolling
    clearInterval(ss.INTERVAL);
  
    cypos = ss.getCurrentYPos();
  
    ss_stepsize = parseInt((desty-cypos)/ss.STEPS);
    ss.INTERVAL = setInterval('ss.scrollWindow('+ss_stepsize+','+desty+',"'+anchor+'")',10);

    // And stop the actual click happening
    if (window.event) {
      window.event.cancelBubble = true;
      window.event.returnValue = false;
    }
    if (e && e.preventDefault && e.stopPropagation) {
      e.preventDefault();
      e.stopPropagation();
    }
  },

  scrollWindow: function(scramount,dest,anchor) {
    wascypos = ss.getCurrentYPos();
    isAbove = (wascypos < dest);
    window.scrollTo(0,wascypos + scramount);
    iscypos = ss.getCurrentYPos();
    isAboveNow = (iscypos < dest);
    if ((isAbove != isAboveNow) || (wascypos == iscypos)) {
      // if we've just scrolled past the destination, or
      // we haven't moved from the lpageWrapperArraycroll (i.e., we're at the
      // bottom of the page) then scroll exactly to the link
      window.scrollTo(0,dest);
      // cancel the repeating timer
      clearInterval(ss.INTERVAL);
      // and jump to the link directly so the URL's right
      location.hash = anchor;
    }
  },

  getCurrentYPos: function() {
    if (document.body && document.body.scrollTop)
      return document.body.scrollTop;
    if (document.documentElement && document.documentElement.scrollTop)
      return document.documentElement.scrollTop;
    if (window.pageYOffset)
      return window.pageYOffset;
    return 0;
  },

  addEvent: function(elm, evType, fn, useCapture) {
    // addEvent and removeEvent
    // cross-browser event handling for IE5+,  NS6 and Mozilla
    // By Scott Andrew
    if (elm.addEventListener){
      elm.addEventListener(evType, fn, useCapture);
      return true;
    } else if (elm.attachEvent){
      var r = elm.attachEvent("on"+evType, fn);
      return r;
    } else {
      alert("Handler could not be removed");
    }
  }
}

ss.STEPS = 25;

ss.addEvent(window,"load",ss.fixAllLinks);
