var X_UI_Repeater_SUPPORT_ATTRS = {
		dataSource   : [ null, XUI_Dirty.LAYOUT, XUI_Attr_USER.UINODE, XUI_Attr_Type.OBJECT ],
		itemRenderer : [ null, XUI_Dirty.LAYOUT, XUI_Attr_USER.UINODE, XUI_Attr_Type.OBJECT ]
};

var XUI_Repeater = XUI_Box.inherits(
	'_Repeater',
	X_Class.NONE,
	{
		layout       : XUI_Layout_Vertical,
		
		dataSource   : null, // Array.<object>, Array.<ItemData>
		
		itemRenderer     : null,
		
		itemNodes        : null,
		
		startIndex       : 0,
		startRenderIndex : 0,
		numItemsParPage  : 0,
		numItemsPrev     : 0,
		numItems         : 0,
		itemHeightLast   : 0,
		itemHeightLastEM : 0,
		
		Constructor : function( user, dataSource, itemRenderer, attr ){
			this.Super( user, null, [ attr ] );
			this.dataSource   = dataSource;
			this.itemRenderer = itemRenderer;
			this.itemNodes    = [];
			this.__item__     = X_Pair_get( itemRenderer );
		},
		
		initialize : function(){
			XUI_AbstractUINode.prototype.initialize.apply( this, arguments );
			
			this.parent[ 'listen' ]( XUI_Event.SCROLL_END, this );
		},
		
		/*
		 * ここに来るのは、初描画とリサイズ
		 */
		calculate : function( isNeedsDetection, x, y, allowedW, allowedH ){
			var dataSource = this[ 'dataSource' ];

			if( allowedW + allowedH === XUI_Attr_AUTO ) return false;
		
			this.scrollPortWidth  = allowedW;
			this.scrollPortHeight = allowedH;			
			
			this.preMesure( allowedW, allowedH );
			
			if( dataSource && dataSource.length ){
				this.updateItemRenderer( this.contentWidth, allowedH );
			} else
			if( this.contentHeight === XUI_Attr_AUTO ){
				this.contentHeight = this.contentHeightMin !== XUI_Attr_AUTO ? this.contentHeightMin : 0;
			};
			
			this.postMesure();
	
			if( !isNeedsDetection ){
				this.boxX += x;
				this.boxY += y;
			};
			return true;
		},
		
		handleEvent : function( e ){
			var scrollBox, scrollY, dataSource, offsetY, startIndex, maxIndex, offset, itemNodes, ary, i, l;
			
			switch( e.type ){
				case XUI_Event.SCROLL_END :
					scrollBox  = this.parentData;
					scrollY    = - scrollBox.scrollY;
					dataSource = this[ 'dataSource' ];
					itemNodes  = this.itemNodes;
					itemH      = this.itemHeightLast;
					
					// transition Y を 0 付近に。
				
					
					// startIndex の計算
					startIndex = scrollY / itemH | 0;
					
					/*maxIndex   = dataSource.length <= this.numItems ? 0 : dataSource.length - this.numItems;
					console.log( ' >>> ' + startIndex + ' ' + maxIndex );
					
					startIndex =
						startIndex < 0 ? 0 :
						maxIndex < startIndex ? maxIndex : startIndex; */
					// アイテムの座標の修正とレンジ外のアイテムを配列内で再配置
					offset = startIndex - this.startIndex; // visible な stratIndex renderStartIndex
					this.startIndex = startIndex;
					
					console.log(  this.numItemsPrev + ' oo ' + offset )
					
					if( 0 < offset ){
						itemNodes.push.apply( itemNodes, itemNodes.splice( 0, offset ) );
					} else
					if( offset < - 0 ){
						itemNodes.unshift.apply( itemNodes, itemNodes.splice( itemNodes.length + offset ) );
					};

					// 再配置されたアイテムにitemData のセット
					this.updateItemRenderer( this.contentWidth, this.scrollPortHeight );
					
					
					
					offsetY  = scrollY % itemH;
					offsetY  = offsetY === 0 ? 0 : ( offsetY - itemH );
					offsetY += ( this.startRenderIndex - this.startIndex ) * itemH;
					//console.log( ' ====> ' + this.startRenderIndex + ' -> ' + this.startIndex + ' scrollY:' + offsetY );

					//scrollBox.scrollTo( 0, - scrollY, 0, '', 0 ); // anime無し							
					//console.log( '  <==== ' );
					break;
			};
		},
		
		updateItemRenderer : function( _w, _h ){
			var itemNodes  = this.itemNodes,
				attrs      = this.attrObject || this.attrClass.prototype,
				gapY       = XUI_AbstractUINode_calcValue( attrs[ this.usableAttrs.gapY.No ], _w ),
				dataSource = this[ 'dataSource' ],
				render     = this[ 'itemRenderer' ],
				l          = dataSource.length,
				start      = this.startIndex - this.numItemsPrev,
				itemH      = this.itemHeightLastEM,
				i, data, node, _y = 0, last, n;
			
			i = this.startRenderIndex = start = start < 0 ? 0 : start;
			
			_y = ( itemH + gapY ) * i;
			
			for( ; i < l; ++i ){
				if( !( data = itemNodes[ i ] ) ){
					node = render.clone( true );
					this.addAt( i, [ node ] );
					data = itemNodes[ i ] = X_Pair_get( node );
					// init -> addToParent -> creationComplete
				};
				data.setItemData( dataSource[ i ] );
				
				data.calculate( false, 0, _y, _w, _h );
				_y += ( itemH || data.boxHeight ) + gapY;
				
				// 一番最初のループ。ここでページあたりのアイテム数を計算
				if( !itemH && i === start ){
					itemH = _y - gapY;
					this.itemHeightLastEM = itemH;
					this.itemHeightLast   = itemH * X_ViewPort_baseFontSize,
					// scroller の miniHeight は(例えば)親の高さの300% そこにいくつのアイテムを並べることが出来るか？端数切り上げ
					this.numItemsParPage = _h / itemH + 0.999 | 0;
					n    = this.numItems = ( _h * 3 ) / itemH + 0.999 | 0; // TODO boxHeight
					this.numItemsPrev    = ( this.numItems - this.numItemsParPage ) / 2 | 0;
					last = i + n;
					// データの最後まで、または、開始位置から 3ページ分を生成する
					l    = last < l ? last : l;
				};
			};
			
			for( l = itemNodes.length; i < l; ++i ){
				// itemNodes[ i ] hide
			};
			
			// TODO contentHeight は　attr を無視する -> 未表示領域につくるアイテム数 GPU の有無で変わる
			this.contentHeight = dataSource.length * ( itemH + gapY ) - gapY;
		},
		
		onPropertyChange : function( name, newValue ){
			var itemNodes, i, l, uinode, dataList, from;
			
			switch( name ){
				case 'itemRenderer' :
					for( itemNodes = this.itemNodes, i = itemNodes && itemNodes.length; i; ){
						itemNodes[ --i ][ 'kill' ]();
					};
					
				case 'dataSource' :
					if( itemNodes = this.itemNodes ){
						i = itemNodes.length;
						l = this[ 'dataSource' ].length;
						while( l < i ){
							itemNodes[ --i ][ 'kill' ]();
							itemNodes.length = i;
						};						
					};

					
					break;
			};
		}
	}
);

X.UI.Repeater = X.UI.Box.inherits(
	'Repeater',
	X_Class.NONE,
	{
		Constructor : function( dataSource, itemRenderer ){
			var supports;
			
			if( XUI_Repeater.prototype.usableAttrs === XUI_Box.prototype.usableAttrs ){
				supports = XUI_Attr_createAttrDef( XUI_Attr_Support, X_UI_Repeater_SUPPORT_ATTRS );
				XUI_Repeater.prototype.usableAttrs = supports = XUI_Attr_createAttrDef( supports, XUI_Layout_Vertical.overrideAttrsForSelf );
		
				XUI_Repeater.prototype.attrClass   = XUI_Attr_preset( XUI_Box.prototype.attrClass, supports );
			};
			
			// dataProvider
			// itemBase　parent に追加されている uinode は不可
			// minHeight=300% height=auto
			X_Pair_create( this,
				XUI_Repeater(
					this,
					dataSource, itemRenderer,
					{
						name      : 'ScrollBox-Scroller',
						role      : 'container',
						width     : 'auto',
						minWidth  : '100%',
						height    : 'auto',
						minHeight : '100%',
				borderColor : 0x252527,
				borderWidth : [ 0.15, 0, 0 ],
				borderStyle : 'solid',
				height      : 'auto',
				bgColor     : 0x444643,
				gapY        : 0.15
					}));
		},
		
		getItemDataAt : function(){
			
		},
		
		add : function( /* node, node, node ... */ ){
		},
		addAt : function( index /* , node , node, node ... */ ){
		},
		remove : function( /* node, node, node ... */ ){
		},
		removeAt : function( from, length ){
		},
		getNodesByClass : function( klass ){
		},
		getFirstChild : function(){
		},
		getLastChild : function(){
		},
		getNodeAt : function( index ){
		},
		numNodes : function(){
			var uinodes = X_Pair_get( this ).uinodes;
			return uinodes && uinodes.length || 0;
		}

	}
);
