﻿
/*
 * original : uupaa-js HTML5Audio.js
 * https://code.google.com/p/uupaa-js/source/browse/trunk/0.8/src/Audio/HTML5Audio.js?r=568
 */

var X_Audio_HTMLAudio_playTrigger =
		6 <= X_UA[ 'iOS' ] ? 'loadeddata' :
		X_UA[ 'iOS' ] < 5  ? 'stalled' :
		X_UA[ 'iOS' ]      ? 'suspend' :
		X_UA[ 'AndroidBrowser2' ] || X_UA[ 'AndroidBrowser3' ] ? 'stalled' : // Android 2.3.5(SBM101SH) では stalled は発生しない,,,
		X_UA[ 'AndroidBrowser4' ] ? 'loadeddata' : 
		X_UA[ 'OperaMobile' ] || X_UA[ 'OperaTablet' ] ? 'loadeddata' :
		//X_UA[ 'WinPhone' ] && X_UA[ 'IE9' ] ? 'canplay' :
			'loadeddata', //'canplay',
	X_Audio_HTMLAudioWrapper,
	X_Audio_constructor = window[ 'Audio' ] || window.HTMLAudioElement,
	X_Audio_rawAudio,
	// Opera Mobile 12 android4.4.4 & 2.3.5 は 2回目以降の currentTime へのセットで currentTime が更新されなくなるため、タイマーを使用する
	X_Audio_HTMLAudioWrapper_currentTimeFix  = !!X_UA[ 'OperaMobile' ] || !!X_UA[ 'OperaTablet' ], // || ( X_UA[ 'WinPhone' ] && X_UA[ 'IE9' ] ),
	// Android1.6+MobileOpera12では無理っぽい、、、
	X_Audio_HTMLAudioWrapper_badOperaAndroid = X_Audio_HTMLAudioWrapper_currentTimeFix && X_UA[ 'Android' ] < 2,

	// 一方 Desktop の Opera12 は、loadeddata 等では duration が infinity で、再生後の durationchange 時に duration が判明する。
	// opera12 volume, mute の変更が2度目以降できない
	// duration 判明後には currentTime によるシークと、現在時間の取得が可能になる。
	// canplay で play() durationchange で duration が取れたら loadedmetadata->loadeddata -> canplay する
	// boombox.js に書いてあった currentTime の効かないブラウザってこいつのことみたい、、、
	// Opera12.17 Win32(XP) portable apps は勝手に再生が始まる、、、その際には timeupdate が発行されない、、、　iframe+image+audio で使わないときは破棄する、とか。
	// opera11、10.54 WinXP はまとも、、、
	// X_Audio_Sprite_handleEvent でも使用
	X_Audio_HTMLAudioWrapper_ieMobile9Fix    = ( X_UA[ 'WinPhone' ] && X_UA[ 'IE9' ] ),
	X_Audio_HTMLAudioWrapper_durationFix     = ( !X_Audio_HTMLAudioWrapper_currentTimeFix && 12 <= X_UA[ 'Opera' ] ),
	
	X_Audio_HTMLAudioWrapper_shortPlayFix    = X_UA[ 'AndroidBrowser' ] && X_UA[ 'AndroidWebkit' ] <= 534.3, // Android 4.1.1 でも遭遇
	
	X_Audio_codecs;

if( X_Audio_constructor && !X_Audio_HTMLAudioWrapper_badOperaAndroid ){
	//http://himaxoff.blog111.fc2.com/blog-entry-97.html
	//引数なしで new Audio() とすると、Operaでエラーになるそうなので注意。
	X_Audio_rawAudio = new X_Audio_constructor( '' );

	// https://html5experts.jp/miyuki-baba/3766/
	// Chrome for Android31 で HE-AAC が低速再生されるバグ
	if( X_Audio_rawAudio.canPlayType ){
		X_Audio_codecs = {
	      'mp3'  : X_Audio_rawAudio.canPlayType('audio/mpeg'),
	      'opus' : X_Audio_rawAudio.canPlayType('audio/ogg; codecs="opus"'),
	      'ogg'  : X_Audio_rawAudio.canPlayType('audio/ogg; codecs="vorbis"'),
	      'wav'  : X_Audio_rawAudio.canPlayType('audio/wav; codecs="1"'),
	      'aac'  : X_Audio_rawAudio.canPlayType('audio/aac'),
	      'm4a'  : X_Audio_rawAudio.canPlayType('audio/x-m4a') + X_Audio_rawAudio.canPlayType('audio/m4a') + X_Audio_rawAudio.canPlayType('audio/aac'),
	      'mp4'  : X_Audio_rawAudio.canPlayType('audio/x-mp4') + X_Audio_rawAudio.canPlayType('audio/mp4') + X_Audio_rawAudio.canPlayType('audio/aac'),
	      'weba' : X_Audio_rawAudio.canPlayType('audio/webm; codecs="vorbis"')
		};
		(function( k, v ){
			for( k in X_Audio_codecs ){
				if( X_EMPTY_OBJECT[ k ] ) continue;
				v = X_Audio_codecs[ k ];
				X_Audio_codecs[ k ] = v && v.split( 'no' ).join( '' );
				console.log( k + ' ' + X_Audio_codecs[ k ] );
			};
		})();
	} else {
		// iOS3.2.3
		X_Audio_codecs = {
	      'mp3'  : X_UA[ 'IE' ] || X_UA[ 'Chrome' ] || ( X_UA[ 'Windows' ]  && X_UA[ 'Safari' ]  ),
	      'ogg'  : 5 <= X_UA[ 'Gecko' ] || X_UA[ 'Chrome' ] || X_UA[ 'Opera' ] ,
	      'wav'  : X_UA[ 'Gecko' ] || X_UA[ 'Opera' ] || ( X_UA[ 'Windows' ]  && X_UA[ 'Safari' ]  ),
	      'aac'  : X_UA[ 'IE' ] || X_UA[ 'WebKit' ],
	      'm4a'  : X_UA[ 'IE' ] || X_UA[ 'WebKit' ],
	      'mp4'  : X_UA[ 'IE' ] || X_UA[ 'WebKit' ],
	      'weba' : 2 <= X_UA[ 'Gecko' ] || 10.6 <= X_UA[ 'Opera' ] // firefox4+(Gecko2+)
		};
	};
	
	X_Audio_HTMLAudioWrapper = X_Audio_AbstractAudioBackend[ 'inherits' ](
		'X.AV.HTML5AudioWrapper',
		X_Class.POOL_OBJECT,
		{
			_playTime        : 0,
			_closed          : true,
			_loaded          : false,
			_beginTime       : 0,
			_playForDuration : 0,
			_lastCurrentTime : 0,
			_src             : '',
			
			Constructor : function( target, source, option ){
				var raw;
				
				this.target  = target || this;
				this._closed = false;
				
				this.setState( option );

				if( option[ 'useVideo' ] ){
					this[ '_rawObject' ]  = raw = document.createElement( 'video' );
	                raw.preload           = 'none'; // auto, metadata, none
	                //raw.autoplay = false, // no-auto
	                raw.loop              = false;
	                raw.muted             = false;
	                raw.crossorigin       = option[ 'crossorigin' ] || ''; //crossorigin: "anonymous", X.URL.isSameDomain() で切り替え
	                raw.style.cssText     = 'position:absolute;bottom:0;left:-50px;width:100px;height:100px;opacity:0;';
					raw.controls          = false;
					raw.WebKitPlaysInline = true;
					raw.src               = source;
					//raw.onclick  = "alert('play');this.actualPlay();";
					document.body.appendChild( raw );
					//raw.load();
				} else {
					this[ '_rawObject' ] = X_Audio_rawAudio || new X_Audio_constructor( source );
					// X_Doc_create( 'audio', { src : source } )[ 'appendTo' ]( X.Doc.body );
					this[ '_rawObject' ].autobuffer = false;
					this._src = source;
				};
				
				this[ 'listen' ]( [
						'loadstart', 'load', 'progress', 'suspend', 'abort', 'error', 'emptied', 'stalled', 'play', 'pause', 'loadedmetadata',
						'loadeddata', 'waiting', 'playing', 'canplay', 'canplaythrough', 'seeking', 'seeked', 'timeupdate', 'ended',
						'ratechange', 'durationchange', 'volumechange' ], this.handleEventProxy );				

				//document.body.appendChild( this[ '_rawObject' ] );
				this[ '_rawObject' ].autoplay = false;

				if( X_Audio_rawAudio === this[ '_rawObject' ] ){
					if( X_Audio_HTMLAudioWrapper_badOperaAndroid ){
						X_Audio_HTMLAudioWrapper_badOperaAndroid && alert( 12 );
						X_EventDispatcher_toggleAllEvents( this, false );
						this[ '_rawObject' ] = new X_Audio_constructor( X_URL_toAbsolutePath( source ) );
						//X_EventDispatcher_toggleAllEvents( this, true );
					} else {
						X_Audio_rawAudio.src = source;
					};

					//this[ '_rawObject' ] = new X_Audio_constructor( X_URL_toAbsolutePath( source ) );
					/*!X_Audio_Sprite_needTouchFirst && */ X_Audio_rawAudio.load(); // 要る?
					X_Audio_rawAudio = null;
				};

				this[ 'listenOnce' ]( X_EVENT_KILL_INSTANCE );
			},
			
			handleEvent : function( e ){
				switch( e.type ){

					case X_EVENT_KILL_INSTANCE :
						// 【javascript】モバイル向けブラウザでも音を鳴らしたい【WebAudio】
						// http://ingaouhou.com/archives/3633
						// ・使い終わったインスタンスはload()しておくとやや安定
						this.playing && this.actualPause();
						delete this._closed;
						delete this._loaded;
						
						this[ '_rawObject' ].src = '';
						this[ '_rawObject' ].load();
						
						// removeChild for video
						break;
				};
			},
			/*
			 * http://uguisu.skr.jp/html/table3.html
			 */
			handleEventProxy : function( e ){
				var type, loaded, end, now;
				
				X_Audio_HTMLAudioWrapper_badOperaAndroid && alert( e.type );
				
				X_Audio_HTMLAudioWrapper_ieMobile9Fix && e.type !== 'timeupdate' && console.log( e.type );
				
				switch( e.type ){
					case 'loadstart' :      // 	ブラウザがコンテンツの検索を開始した場合に発生
						break;
					case 'progress' :       // 	ブラウザがコンテンツの取得を実行した場合に発生
						console.log( e.loaded + ' ' + e.total * 100 + '%' );
						// iem9 で常に0 this[ '_rawObject' ].networkState;
						// opera Android 12 で　buffered.end() へのアクセスはエラー　try catch も無効、iem9 は常に end(0) = 0
						//console.log( 'buffered.end ' + this[ '_rawObject' ].buffered && this[ '_rawObject' ].buffered.end(0) ); 
						break;
					
					case 'canplay' :        // 	今すぐに再生を再開できるが、バッファリングが不十分でコンテンツを最後まで表示できないと予測している場合に発生
						if( X_Audio_HTMLAudioWrapper_durationFix && this._playForDuration === 0 ){
							//console.log( 'DurationFix開始 - ' + this[ '_rawObject' ].duration );
							this._playForDuration = 1;
							this[ '_rawObject' ].play();
							this[ '_rawObject' ].currentTime = this._beginTime / 1000; // 必要！
							return;
						};
					case 'loadedmetadata' : // 	ブラウザがメディアリソースの長さと寸法を判定した場合に発生
					case 'loadeddata' :     // 	コンテンツの表示を現在の再生位置で初めて行えるようになった場合に発生
					case 'canplaythrough' : // 	今すぐに再生を開始してもバッファリングで停止することなく最後まで表示できると予測している場合に発生
						if( X_Audio_HTMLAudioWrapper_durationFix && this._playForDuration !== 2 ) return;
						this.duration = this.duration || this[ '_rawObject' ].duration * 1000;
						break;
	
					case 'stalled' :        // 	ブラウザがコンテンツの取得を試みたが、データがまだ用意されていない場合に発生
						// Android2 で ready 扱い?
					case 'suspend' :        // 	ブラウザが意図的にコンテンツの取得を現在行っていない場合に発生（ダウンロードは未完了）
						// iOS で ready 扱い
					case 'emptied' :        // 	読み込み中に致命的なエラーが発生したか、実行状態ででload()メソッドが実行された場合に発生
					case 'abort' :          // 	ダウンロードの完了前にコンテンツの取得を停止した場合に発生（この停止はエラーによるものではない）
						break;
						
					case 'error' :          // 	コンテンツの取得実行中にエラーが発生した場合に発生
						type = X_EVENT_ERROR;
						break;
					
					case 'playing' :        // 	再生が開始された場合に発生
						if( X_Audio_HTMLAudioWrapper_currentTimeFix ){
							this._playTime  = X_Timer_now();
						};
						type = X_EVENT_MEDIA_PLAYING;
					case 'play' :           // 	再生が開始された。play()メソッドからの復帰後に発生する場合に発生
					case 'pause' :          // 	再生が一時停止された。pauseメソッドからの復帰後に発生する場合に発生
					case 'seeked' :         // 	シークがfalseに変化した場合に発生
					case 'ratechange' :     // defaultPlaybackRate属性とplaybackRate属性のどちらかが更新された場合に発生
					case 'volumechange' :   // volume属性とmuted属性のどちらかが変化した場合に発生
						if( this._playForDuration === 1 ) return;
						break;
						
					case 'waiting' :        // 	次のフレームが利用不可のため再生を停止したが、そのフレームがやがて利用可能になると想定している場合に発生
						type = X_EVENT_MEDIA_WAITING;
					case 'seeking' :        // 	シークがtrueに変化し、イベントを発生させるのに十分な時間がシーク操作にかかっている場合に発生
						type = type || X_EVENT_MEDIA_SEEKING;
						if( this._playForDuration === 1 ) return;
						break;
						
					case 'ended' :
						if( !this._closed && this.autoLoop ){
							if( !( this.target[ 'dispatch' ]( X_EVENT_MEDIA_BEFORE_LOOP ) & X_Callback_PREVENT_DEFAULT ) ){
								this.looped = true;
								this.target[ 'dispatch' ]( X_EVENT_MEDIA_LOOPED );
								this.actualPlay();
							};
							return;
						};
						type = X_EVENT_MEDIA_ENDED;
						this.seekTime = 0;
						delete this.playing;
						break;
	
					case 'timeupdate' :     // 	通常の再生が行われ現在の再生位置の変化が起こった場合に発生
						if( X_Audio_HTMLAudioWrapper_ieMobile9Fix ){
							if( this._playForDuration === 1 ){
								console.log( 'tu ' + this[ '_rawObject' ].duration );
								if( !this.duration && X_Type_isFinite( this[ '_rawObject' ].duration ) ){
									this.duration = this.duration || this[ '_rawObject' ].duration * 1000;
									this._playForDuration = 2;
					                loaded = true;
					                //console.log( 'durationFix が完了' + this.duration );
					                break;
								} else {
									this[ '_rawObject' ].currentTime = this._beginTime / 1000; // 必要！
									return;
								};
							} else
							if( this[ '_rawObject' ].currentTime === this._lastCurrentTime ){
								//this.target[ 'dispatch' ]( 'seeking' );
								this.target[ 'dispatch' ]( X_EVENT_MEDIA_WAITING );
								return;
							};
							this._lastCurrentTime = this[ '_rawObject' ].currentTime;
						};
						this.duration = this.duration || this[ '_rawObject' ].duration * 1000;

			            if( this.playing ){
			            	end = X_AudioWrapper_getEndTime( this );
			            	now = this.getActualCurrentTime();
			            	console.log( end + ' / ' + now );
			            	if( 0 + end <= 0 + now ){ // なぜか iem9 で必要,,,
				            	if( this.autoLoop ){
				            		if( !( this.target[ 'dispatch' ]( X_EVENT_MEDIA_BEFORE_LOOP ) & X_Callback_PREVENT_DEFAULT ) ){
				            			this.looped = true;
				            			this.target[ 'dispatch' ]( X_EVENT_MEDIA_LOOPED );
				            			this.actualPlay();
					            	};
				            	} else {
				            		this.actualPause();
				            		this.target[ 'dispatch' ]( X_EVENT_MEDIA_ENDED );
				            	};
			            		return;
			            	};
			            } else {
			            	return;
			            };
			            type = X_EVENT_MEDIA_PLAYING;
						break;
						
					case 'durationchange' : // duration属性が更新された場合に発生
						
						if( !X_Audio_HTMLAudioWrapper_durationFix ){
							this.duration = this[ '_rawObject' ].duration * 1000;
						} else
						// Desktop Opera では Infinity, IEM9 では NaN
						if( !this.duration && X_Type_isFinite( this[ '_rawObject' ].duration ) ){
							
							//console.log( this[ '_rawObject' ].duration );
							
							this.duration = this[ '_rawObject' ].duration * 1000;
							
							if( this._playForDuration === 0 ) this._playForDuration = 2;
							
							if( this._playForDuration === 1 ){
								this._playForDuration = 2;
								
								console.log( 'Loaded ' + this._loaded );
								
								if( this._loaded ){
									this[ '_rawObject' ].currentTime = this._beginTime / 1000;
									console.log( '設定 ' + this._beginTime );
									return;
								};

				                loaded = true;
				                console.log( 'durationFix が完了' + this.duration );
				                
				                if( this.autoplay ){
									this[ '_rawObject' ].currentTime = this._beginTime / 1000;	
				                } else {
				                	// Opera12.17 WinXP で勝手に再生される不具合
				                	// これで一応再生は止まる、、、
									this[ '_rawObject' ].src = '';
									//this[ '_rawObject' ].load();			                	
				                };
							};
							
						};
						break;
					
				};
				
				
				if( !this._loaded && ( loaded || e.type === X_Audio_HTMLAudio_playTrigger || e.type === 'loadeddata' ) ){
					this.autoplay && X_Timer_once( 16, this, this.play );
					this._loaded = true;
					this.target[ 'asyncDispatch' ]( X_EVENT_READY );
					console.log( 'Loaded! ' + e.type + ' d:' + ( this.duration | 0 ) );
					return;
				};
				
				if( !loaded && type ){
					this.target[ 'dispatch' ]( type );
					type === X_EVENT_ERROR && this[ 'kill' ]();
				};
			},

			actualPlay : function(){
				var begin, end;
				
				// もし kill 後に autoplayTimer で呼ばれても、_closed==true なので平気
				if( this._closed ) return;
				if( !this._loaded && !X_Audio_HTMLAudioWrapper_ieMobile9Fix /* && !X_Audio_Sprite_inTouchAction */ ){
	            	this.autoplay = true;
	            	return;
				};
				
				if( X_Audio_HTMLAudioWrapper_ieMobile9Fix && this._playForDuration === 0 ){
					console.log( 'DurationFix開始 - ' + this[ '_rawObject' ].duration );
					this._playForDuration = 1;
				};

				end   = X_AudioWrapper_getEndTime( this );
				begin = this._beginTime = X_AudioWrapper_getStartTime( this, end, true );

	            if( X_Audio_HTMLAudioWrapper_shortPlayFix ){
	            	begin -= end - begin > 1000 ? 200 : 400;
	            	begin  = begin < 0 ? 0 : begin;
	            };

				if( !this[ '_rawObject' ].src ){
					this._beginTime = begin;
					this[ '_rawObject' ].src = this._src;
					delete this._playForDuration;
				};

			    if( !this.playing ){
				    if( X_UA[ 'Chrome' ] ){ // [CHROME][FIX] volume TODO どの version で 修正される？
				        // [!] delay
				        X_Timer_once( 0, this, this._fixForChrome );
				        this[ '_rawObject' ].volume = 0;
				    } else {
				    	this[ '_rawObject' ].volume = X_Audio_HTMLAudioWrapper_ieMobile9Fix ? 1 : this.gain;
				    };
			    	this[ '_rawObject' ].play();
			    	this.playing = true;
			    };
				//http://himaxoff.blog111.fc2.com/blog-entry-97.html
				//Firefox3.6では一度も play() していない状態で currentTime = 0 を実行するとエラーになる。
				//また、GoogleChrome7 では currentTime = 0 直後に play() すると、pause()した位置前後の音が混ざることがある。(少なくとも自分の環境では)
				this[ '_rawObject' ].currentTime = this._lastCurrentTime = begin / 1000;

			    console.log( '[HTMLAudio] play ' + begin + ' -> ' + end );
	            
	            if( X_Audio_HTMLAudioWrapper_currentTimeFix ){
                	this._beginTime = begin;
                	this._playTime  = X_Timer_now();
	            };

			},
				
				// [CHROME][FIX] volume
				_fixForChrome : X_UA[ 'Chrome' ] && function(){
					!this._closed && ( this[ '_rawObject' ].volume = this.gain );
				},
			
			actualPause : function(){
				if( !this.playing ) return;
				
				this.seekTime = this.getActualCurrentTime();

				delete this._playTime;

		        !this[ '_rawObject' ].error && this[ '_rawObject' ].pause();
		        
		        if( X_Audio_HTMLAudioWrapper_durationFix ){
		        	this[ '_rawObject' ].src = '';
		        	// load();
		        };
		        delete this.playing;
			},
			
			getActualCurrentTime : function(){
				return ( X_Audio_HTMLAudioWrapper_currentTimeFix ?
				    				X_Timer_now() - this._playTime + this._beginTime :
				    				this[ '_rawObject' ].currentTime * 1000 | 0 );
			},
		/*
		http://www.w3schools.com/tags/av_prop_error.asp
		1 = MEDIA_ERR_ABORTED - fetching process aborted by user
	    2 = MEDIA_ERR_NETWORK - error occurred when downloading
	    3 = MEDIA_ERR_DECODE - error occurred when decoding
	    4 = MEDIA_ERR_SRC_NOT_SUPPORTED - audio/video not supported
	    */			
			getActualError : function(){
				return this[ '_rawObject' ].error || 0;
			},
			
			afterUpdateState : function( result ){
				if( result & 3 ){ // seek
	            	this.actualPlay();
				} else
				if( result & 4 ){
	               this[ '_rawObject' ].volume = X_Audio_HTMLAudioWrapper_ieMobile9Fix ? 1 : this.gain;
				};				
			}
	
		}
	);
	
	X_Audio_BACKENDS.push(
		{
			backendName : 'HTML Audio',
		/*
		 * HTML5 の audio 要素と video 要素でサポートされているメディアフォーマット
		 * https://developer.mozilla.org/ja/docs/Web/HTML/Supported_media_formats
		 * 
		 * 主要ブラウザのHTML5 audioタグで使えるファイル形式の再生対応状況を調べてみた
		 * http://sothis.blog.so-net.ne.jp/2010-10-27
		 * ダメ元で仕様に含まれていない SHOUTcast もテストしてみました。
		 * 
		 * IE9 の HTML5 Audio について
		 * http://kentablog.cluscore.com/2011/05/ie9-html5-audio.html
		 * 1.Audioオブジェクトを作ることができないので、Audioタグを使う
		 * 2.クロスドメインアクセスには、「clientaccesspolicy.xml」か「crossdomain.xml」が必要
		 * 3.wav が不可
		 * 
		 * IE9でHTML5 autio タグが無効になる
		 * http://bbs.wankuma.com/index.cgi?mode=al2&namber=64886&KLOG=109
		 *  IEのバージョン9.0.8112.16421では、Audioオブジェクトのnewも対応してました。
		 *  createElement等で動的生成すると、よろしくない
		 * 
		 * media-can-play-wav-audio.html
		 * https://github.com/adobe/webkit/blob/master/LayoutTests/media/media-can-play-wav-audio.html
		 * testExpected("audio.canPlayType('audio/wav; codecs=1')", "probably");
		 * 
		 * HTML5 audioタグ ブラウザ間の違い
		 * http://wiki.bit-hive.com/tomizoo/pg/HTML5%20audio%A5%BF%A5%B0%20%A5%D6%A5%E9%A5%A6%A5%B6%B4%D6%A4%CE%B0%E3%A4%A4
		 *  - volume, muted iPhone(iOS4-6)、Android(2.3.6)では動作せず。
		 *  - FireFox3.6, Android 2.3.6については、src変更後、load()を呼び出さないと切り替わらなかった。iPhoneはload()が不要。
		 */	
			detect : function( proxy, source, ext ){
				/*
				var ok, mineType = 'audio/' + ext;
				switch( ext ){
					case 'mp3' :
						ok = X_UA[ 'IE' ] || X_UA[ 'Chrome' ] || ( X_UA[ 'Windows' ]  && X_UA[ 'Safari' ]  );
						mineType = 'audio/mpeg';
						//if( X_UA[ 'Android' ] && X_UA[ 'Gecko' ] ) mineType = '';
						break;
					case 'ogg' :
						ok = 15 <= X_UA[ 'Gecko' ] || X_UA[ 'Chrome' ] || X_UA[ 'Opera' ] ;
						if( X_UA[ 'AndroidBrowser' ] ) mineType = '';
						break;
					case 'm4a' :
						ok = X_UA[ 'IE' ] || X_UA[ 'WebKit' ];
						mineType = 'audio/mp4';
						break;
					case 'webm' :
						ok = 2 <= X_UA[ 'Gecko' ] || 10.6 <= X_UA[ 'Opera' ] ; // firefox4+(Gecko2+)
						break;
					case 'wav' :
						ok = X_UA[ 'Gecko' ] || X_UA[ 'Opera' ] || ( X_UA[ 'Windows' ]  && X_UA[ 'Safari' ]  );
						//mineType = 'audio/wav'; // audio/x-wav ?
						break;
					default :
						mineType = '';
				};
				
				if( !ok && mineType ){
					if( !X_Audio_rawAudio ) X_Audio_rawAudio = new Audio;
					ok = X_Audio_rawAudio.canPlayType( mineType );
					//console.log( 'HTML Audio ' + ok + ' ext:' + ext );
				};
				console.log( 'HTML Audio ' + ok + ' ext:' + ext );
				*/
				
				proxy[ 'asyncDispatch' ]( { type : X_EVENT_COMPLETE, canPlay : X_Audio_codecs[ ext ] } );
			},
			
			klass : X_Audio_HTMLAudioWrapper
			
		} );

/*
 * 
 * howler.js
 *     codecs = {
      mp3: !!audioTest.canPlayType('audio/mpeg;').replace(/^no$/, ''),
      opus: !!audioTest.canPlayType('audio/ogg; codecs="opus"').replace(/^no$/, ''),
      ogg: !!audioTest.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/, ''),
      wav: !!audioTest.canPlayType('audio/wav; codecs="1"').replace(/^no$/, ''),
      aac: !!audioTest.canPlayType('audio/aac;').replace(/^no$/, ''),
      m4a: !!(audioTest.canPlayType('audio/x-m4a;') || audioTest.canPlayType('audio/m4a;') || audioTest.canPlayType('audio/aac;')).replace(/^no$/, ''),
      mp4: !!(audioTest.canPlayType('audio/x-mp4;') || audioTest.canPlayType('audio/mp4;') || audioTest.canPlayType('audio/aac;')).replace(/^no$/, ''),
      weba: !!audioTest.canPlayType('audio/webm; codecs="vorbis"').replace(/^no$/, '')
    };
 */
	
};





