//{+xhrgadget"OpenSocialガジェット通信プロキシ"(Xドメインは元よりXプロトコルな擬似xhr通信を可能にする)[+xhr]

/*
 * gadgets.io.makeRequest
 * 
 * 1. gadget-iframe を作る。指示を # で渡す。 元文書は frame 内の images の監視を開始する。
 *  1. 通信用 img の src
 *
 * 2. gadget-iframe が 通信用 img を作る。#ready
 * 
 * 3. 元文書が #ready を受け取ったら、iframe の # を書き換えて指示を送る。指示が長い場合、分割して送る。
 * 
 * 4. gadget-iframe は 通信用 img の # に結果を書く。コンテンツが長い場合、分割する。
 * 
 * 5. 元文書は結果を受け取ったことを gadget-iframe の # に書いて伝える。
 * 
 * 
 */

var X_NET_GIMR_canUse         = 5.5 <= X_UA[ 'IE' ] || !X_UA[ 'IE' ],
	
	X_NET_GIMR_iframeName     = 'gadgetProxy_' + ( Math.random() * 100000 | 0 ),
	
	X_NET_GIMR_GADGET_XML_URL = 'http://googledrive.com/host/0B4Y86MXyTfuoVUkwTE54T3V1V1U',
	
	// https://kldleov8fp2dl82hphfmor8riij82tof-a-sites-opensocial.googleusercontent.com/gadgets/ifr
	X_NET_GIMR_GADGET_URL     = 'http://www.ig.gmodules.com/gadgets/ifr?url=' + encodeURIComponent( X_NET_GIMR_GADGET_XML_URL ) + '&nocache=1',
	
	X_NET_GIMR_IMAGE_URL      = 'img/opacity0.gif',
	
	X_NET_GIMR_detection      = new Function( 'f,j,i', 'for(j=f.length;j;)try{i=f[--j];return i.location.hash}catch(e){}' ),
	
	X_NET_GIMR_gadgetIframe,
	
	X_NET_GIMR_requestOptions,
	
	X_NET_GIMR_requestOriginal,
	
	X_NET_GIMR_timerID,
	
	X_NET_GIMR_phase = 0,
	
	X_NET_GIMR_lastHashString,
	
	X_NET_GIMR_isReceiveBatches, X_NET_GIMR_receivedString = '';


function X_NET_GIMR_detectImageOverIframe(){
	var raw = X_NET_GIMR_gadgetIframe[ '_rawObject' ],
		iwin, ret, n, error, data = null, zero, e;
	
	if( raw ){
		iwin = raw.contentWindow || ( raw.contentDocument && raw.contentDocument.parentWindow ) || window.frames[ X_NET_GIMR_iframeName ];
		
		if( iwin && iwin.frames && iwin.frames.length ){
			ret = X_NET_GIMR_detection( iwin.frames );
			if( ret && ret !== X_NET_GIMR_lastHashString ){
				X_NET_GIMR_lastHashString = ret;
				//console.log( ret.length );
				//console.log( '' + ret );
				
				switch( X_NET_GIMR_phase ){
					case 0 : // init
						// TODO 分割
						iwin.location.href = X_NET_GIMR_GADGET_URL + '#' + encodeURIComponent( X_JSON_stringify( X_NET_GIMR_requestOptions ) );
						break;
						
					case 1 : // after makeRequest > :ok 待ち
						iwin.location.href = X_NET_GIMR_GADGET_URL + '#_waiting_';
						break;

					case 2 : // _waiting_ 通信結果待ち
						// 分割受信モードか?
						ret = ret.substr( 1 );
						n   = parseInt( ret );
						
						if( X_NET_GIMR_isReceiveBatches ){
							X_NET_GIMR_receivedString += X_Net_GIMR_decodeLocationHash( ret );						
							if( --X_NET_GIMR_isReceiveBatches ){
								iwin.location.href = X_NET_GIMR_GADGET_URL + '#_recived_' + X_NET_GIMR_isReceiveBatches;
								return;
							};
						} else
						if( 1 < n ){
							ret = ret.substr( ( n + ':' ).length );
							X_NET_GIMR_receivedString   = X_Net_GIMR_decodeLocationHash( ret );
							X_NET_GIMR_isReceiveBatches = --n;
							iwin.location.href = X_NET_GIMR_GADGET_URL + '#_recived_' + X_NET_GIMR_isReceiveBatches;
							// speedup
							X_NET_GIMR_timerID = X_Timer_add( 16, 0, X_NET_GIMR_detectImageOverIframe );
							return X_Callback_UN_LISTEN;
						} else {
							X_NET_GIMR_receivedString = X_Net_GIMR_decodeLocationHash( ret );
						};

						ret = X_String_parseTrustedJsonString( X_NET_GIMR_receivedString );
						
						
						X_NET_GIMR_receivedString = '';
						
						error = ret[ 'errors' ] && ret[ 'errors' ].length;
						
						switch( !error && X_NET_GIMR_requestOriginal[ 'dataType' ] ){
							case 'json' :
								data = X_String_parseTrustedJsonString( ret[ 'json' ] || ret[ 'text' ] || '' );
								break;
						};
						
						//console.dir( data || ret );
						
						X_NET_GIMRWrapper._busy = false;
						
						if( error || ret[ 'rc' ] < 200 || 400 < ret[ 'rc' ] ){
							e = {
								type      : X_EVENT_ERROR,
								status    : ret[ 'rc' ] || ret[ 'code' ] || 400,
								'message' : error && ret[ 'errors' ].join( '\n' )
							};
						} else {
							e = {
								type      : X_EVENT_SUCCESS,
								status    : ret[ 'rc' ] || 200,
								response  : data
							};
						};
						
						e[ 'headers' ] = ret[ 'headers' ];
						
						X_NET_GIMRWrapper[ 'asyncDispatch' ]( e);
						
						//console.dir( e );

						X_NET_GIMR_timerID = X_NET_GIMR_phase = 0;
						X_NET_GIMR_lastHashString = '';							
						iwin.location.href = X_NET_GIMR_GADGET_URL + '#_recived_';
						
						return X_Callback_UN_LISTEN;
				};
				++X_NET_GIMR_phase;
			};
		};
	};
};

// http://outcloud.blogspot.jp/2015/06/gecko-location-hash.html
function X_Net_GIMR_decodeLocationHash( str ){
	return X_UA[ 'Gecko' ] ? unescape( str ) : decodeURIComponent( str );
};

X_TEMP.X_Net_GIMR_init = function(){
	// TODO extend NinjaIframe
	X_NET_GIMRWrapper = X_Class_override(
			X_EventDispatcher(),
			X_TEMP.X_Net_GIMR_props
		);
	
	delete X_TEMP.X_Net_GIMR_init;
	delete X_TEMP.X_Net_GIMR_props;	
	
	return X_NET_GIMRWrapper;
};

X_TEMP.X_Net_GIMR_props = {

		_busy         : false,
		_canceled     : false,
		_onloadCount  : 0,
		
		load : function( obj ){
			var k, v;
			//createURL
			if( !X_NET_GIMR_gadgetIframe ){
				X_NET_GIMR_gadgetIframe = X_Node_systemNode
						.create( 'iframe', {
							className         : 'hidden-iframe',
							name              : X_NET_GIMR_iframeName,
							id                : X_NET_GIMR_iframeName,
							src               : X_NET_GIMR_GADGET_URL + '#' + encodeURIComponent(
									X_JSON_stringify( {
										'img'  : X_URL_toAbsolutePath( X_NET_GIMR_IMAGE_URL ),
										// https://code.google.com/p/xssinterface/source/browse/trunk/js/xssinterface.js
										'len'  : X_UA[ 'IE' ] ? 2000 : 6000,
										'itvl' : 333
									} )
								),
							scrolling         : 'no',
							allowtransparency : 'no',					
							frameborder       : 0,
							tabindex          : -1
							} );
			};
			
			X_NET_GIMR_timerID = X_Timer_add( 333, 0, X_NET_GIMR_detectImageOverIframe );
			
			X_NET_GIMR_requestOriginal = X_Object_deepCopy( obj );
	
			//console.dir( obj );
			
			X_NET_GIMR_requestOptions = {
				'CONTENT_TYPE'     : 'TEXT',
				'GET_FULL_HEADERS' : true,
				'REFRESH_INTERVAL' : 0,
				'url'              : obj[ 'url' ]
			};
			
			for( k in obj ){
				if( v = '' + obj[ k ] ){
					switch( k ){
						case 'postdata' :
							X_NET_GIMR_requestOptions[ 'POST_DATA' ] = v;
							break;
						case 'method' :
							X_NET_GIMR_requestOptions[ 'METHOD' ] = v;
							break;					
						case 'dataType' :
							// TEXT 以外は無視される?
							switch( v = v.toUpperCase() ){
								case 'TEXT' :
								case 'JSON' :
									X_NET_GIMR_requestOptions[ 'CONTENT_TYPE' ] = v;
									break;
								case 'DOM'  :
								case 'HTML' :
								case 'HTM'  :
								case 'XML'  :
									X_NET_GIMR_requestOptions[ 'CONTENT_TYPE' ] = 'DOM';
									break;
								//case 'FEED' :
							};		
							break;
						case 'headers' :
							X_NET_GIMR_requestOptions[ 'HEADERS' ] = X_NET_GIMR_requestOriginal[ k ];
							break;
						case 'cashe' :
							X_NET_GIMR_requestOptions[ 'REFRESH_INTERVAL' ] = 3600;
							break;
					};					
				};
			};
			
			this._busy = true;
		},
		
		cancel : function(){
			this._canceled = true;
		},
		
		reset : function(){
			this._busy = this._canceled = false;
			this._onloadCount = 0;
		}
	};

//}+xhrgadget