//{+netimage"画像の読み込み監視"(Imageの読み込みを監視し画像表示のコントロールを行う)[+net,+utilimage]
/* 
 * original
 *  LICENSE: MIT?
 *  URL: http://d.hatena.ne.jp/uupaa/20080413/1208067631
 *  AUTHOR: uupaa.js@gmail.com
 * 
 */
var X_Net_Image_hasImage  = !!window[ 'Image' ],
	X_Net_Image_image     = X_Net_Image_hasImage && new Image(),
	// IE では厳密には HTMLImageElement ではなく、appendChild してもサイズが取れず、removeChild に失敗する
	X_Net_Image_isElement = !( X_UA[ 'IE' ] < 9 ) && X_Type_isHTMLElement( X_Net_Image_image );

/*
 * TODO
 * new Image() のときに Image オブジェクトを作るもの(IE8-)と、HTMLImageElement を作るものがある。
 * Image は、X.EventDispatcher で、<img> は X.Node で。 
 */

X_TEMP.X_NET_Image_init = function(){
	X_NET_ImageWrapper = X_Class_override(
		X_Net_Image_isElement ? Node( X_Net_Image_image ) : X_EventDispatcher( X_Net_Image_image ),
		X_TEMP.X_NET_Image_params
	);
	
	X_NET_ImageWrapper[ 'listen' ]( [ 'load', 'error' /*, 'abort'*/, X_EVENT_KILL_INSTANCE ], X_NET_Image_handleEvent );
	
	delete X_TEMP.X_NET_Image_init;
	delete X_TEMP.X_NET_Image_params;	
	
	return X_NET_ImageWrapper;
};

X_TEMP.X_NET_Image_params = {
		_busy      : false,
		tick       : 0,
		timerID    : 0,
		finish     : false,
		abspath    : '',
		delay      : 0,
		timeout    : 0,
		
		load : function( data ){
			this._busy   = true;
			this.abspath = X_URL_toAbsolutePath( data[ 'url' ] );
			this.delay   = data[ 'delay'   ] || 100;
			this.timeout = data[ 'timeout' ] || 5000;

			this[ '_rawObject' ].src = this.abspath;

			if( X_UA[ 'Opera7' ] && this[ '_rawObject' ].complete ){
				this[ 'asyncDispatch' ]( 'load' );
			} else {
				this.timerID = X_Timer_add( this.delay, 0, this, X_NET_Image_detect );
			};
		},
		
		cancel : function(){
			var raw = this[ '_rawObject' ];
			// abort がある?
			raw && raw.abort && raw.abort();
			// this[ '_rawObject' ].src = '';
			this._busy  = false;
			this.finish = true;
		},
		
		reset : function(){
			this.timerID && X_Timer_remove( this.timerID );
			//X_Net_Image_isElement ? this[ '_rawObject' ].removeAttribute( 'src' ) : ( this[ '_rawObject' ].src = '' );
			this[ '_rawObject' ].src = '';
			this.timerID  = 0;
			this._busy    = false;
			this.finished = false;
			this.abspath  = '';
		}
	};

function X_NET_Image_detect(){
	var raw = this[ '_rawObject' ];
	
	if( this.finish ) return;
	if( raw && raw.complete ){
		this._busy  = false;
		this.finish = true;
		if( raw.width ) return;
		X_Timer_remove( this.timerID );
		this.timerID = this[ 'asyncDispatch' ]( X_EVENT_ERROR );
	} else
	if( this.timeout < ( this.tick += this.delay ) ){
		this._busy  = false;
		this.finish = true;
		X_Timer_remove( this.timerID );
		this.timerID = this[ 'asyncDispatch' ]( { type : X_EVENT_ERROR, 'timeout' : true } );
	};
};

function X_NET_Image_handleEvent( e ){
	var size;
	
	switch( e.type ){
		case 'error' :
		//case 'abort' : // TODO ??
			if( this.finish ) return;
			this._busy  = false;
			this.finish  = true;
			this.timerID && X_Timer_remove( this.timerID );
			this.timerID = this[ 'asyncDispatch' ]( /*e.type === 'error' ?*/ X_EVENT_ERROR /*: X_EVENT_CANCELED*/ );
			break;

		case 'load' :
		// if( finish === true ) return; // これがあると firefox3.6 で駄目、、、
		// if( timer ) return; // これがあると safari3.2 で駄目、、、
			this._busy  = false;
			this.finish = true;
			this.timerID && X_Timer_remove( this.timerID );
			if( X_UA[ 'Opera' ] && !this[ '_rawObject' ].complete ){
				this.timerID = this[ 'asyncDispatch' ]( X_EVENT_ERROR );
				return;
			};

			size = X_Util_Image_getActualDimension( !X_Net_Image_isElement ? this.abspath : this );
			this.timerID = this[ 'asyncDispatch' ]( {
				'type' : X_EVENT_SUCCESS,
				'src'  : this.abspath,
				'w'    : size[ 0 ],
				'h'    : size[ 1 ]
				// TODO feedback net speed
				// time , this[ '_rawObject' ].fileSize
			} );
			break;

		case X_EVENT_KILL_INSTANCE :
			this.reset();
			!X_Net_Image_hasImage && this[ 'kill' ](); // if xnode
			break;
	};
};


// X_Net_Image_isElement && X_NET_ImageWrapper[ 'appendAt' ]( X.X_Node_systemNode );
