/*
 * http://msdn.microsoft.com/ja-jp/library/ie/hh180174%28v=vs.85%29.aspx
 * 孤立するとウィンドウ オブジェクトのプロパティが消去される
 * 
 * http://qiita.com/sou/items/3380d4fa9b08b27bb387
 * モバイルブラウザでの iframe の挙動（Mobile Safari, Chrome for Android)
 */

// TODO Node.inherits
X[ 'Util' ][ 'NinjaIframe' ] = Node[ 'inherits' ](
	'NinjaIframe',
	{
		autoRefresh  : 0,
		
		_iwin        : null,
		
		_contentHTML : '',
		_name        : '',
		_ready       : false,
		
		'Constructor' : function( html ){
			
			this._name = 'hidden-iframe-' + X_Timer_now();
			// https://github.com/polygonplanet/Pot.js/blob/master/src/Worker.js

			X_Node_newByTag = true;

			this[ 'Super' ](
				'IFRAME',
				{
					className         : 'hidden-iframe',
					scrolling         : 'no',
					allowtransparency : 'no',					
					frameborder       : 0,
					tabindex          : -1,
					name              : this._name,
					id                : this._name
				}
			);
			
			// http://nanto.asablo.jp/blog/2011/12/08/6237308
			// IE 6/7 で文書間通信を実現するための一案
			if( X_UA[ 'IE' ] < 9 ){
				this[ 'attr' ]( 'src', 'about:blank' );
			};
			// Safari 2.0.* bug: iframe's absolute position and src set.
			if( !X_UA[ 'Webkit' ]  ){
				this[ 'css' ]( { position : 'absolute' } );
			};
			
			if( html ) this._contentHTML = html;			
			
			this[ 'appendTo' ]( X_Node_body /* X_Node_systemNode */ );
			
			X_ViewPort[ 'listenOnce' ]( X_EVENT_AFTER_UPDATE, this, X_Util_NinjaIframe_handleEvent );
		},
		
		'refresh' : function( opt_contentHTML ){
			var raw = this[ '_rawObject' ],
				idoc;
				
			this._ready = false;
			
			if( !this._iwin ){
				this._contentHTML = opt_contentHTML;
				return this;
			};
			
			if( X_UA[ 'IE5x' ] ){
				this._iwin.location.href = 'about:blank'; // reload() では、IE5.5(IETester)で2回目移行の操作でerrorが出る(doc取得やopen,writeで)
			} else {
				this._iwin.location.reload();
			};
			
			if( !opt_contentHTML && opt_contentHTML !== '' ) return this;
			
			this._contentHTML = opt_contentHTML;

			if( !( X_UA[ 'IE' ] < 9 ) ){
				X_Util_NinjaIframe_writeToIframe( this );
				this._ready = true;
			};
			
			return this;
		},
		
		// TODO close -> kill
		'close' : function(){
			X_ViewPort[ 'unlisten' ]( X_EVENT_AFTER_UPDATE, this, X_Util_NinjaIframe_handleEvent );
			this.call( 'close' );
			this[ 'kill' ]();
		}
		
	}
);


function X_Util_NinjaIframe_handleEvent( e ){
	var raw = this[ '_rawObject' ];
	
	switch( e.type ){
		case X_EVENT_AFTER_UPDATE :
			this._iwin = raw.contentWindow || ( raw.contentDocument && raw.contentDocument.parentWindow ) || window.frames[ this._name ];
			// http://d.hatena.ne.jp/NeoCat/20080921/1221940658
			// こちらに名前をsetしないとtargetが動作しない
			if( X_UA[ 'IE' ] ) this._iwin.name = this._name;
			
			this[ 'listen' ]( [ X_UA[ 'IE' ] < 9 ? 'readystatechange' : 'load', 'error' ], this, X_Util_NinjaIframe_handleEvent );
			
			if( !( X_UA[ 'IE' ] < 9 ) ){
				( this._contentHTML || this._contentHTML === '' ) && X_Util_NinjaIframe_writeToIframe( this );
				this._ready = true;
				return;
			};
			//break; これあると IE8 で駄目！
			
		case 'readystatechange' :
			if( ( raw.readyState !== 'complete' && raw.readyState !== 'loaded' ) ) break;
			// ie9-
			if( !this._ready ){
				( this._contentHTML || this._contentHTML === '' ) && X_Util_NinjaIframe_writeToIframe( this );
				this._ready = true;
				break;
			};
			// onload
		case 'load' :
			console.log( 'iframe load.' );
			this[ 'asyncDispatch' ]( 'ninjaload' );
			break;

		case 'error' :
			this[ 'asyncDispatch' ]( 'ninjaerror' );
			break;
	};
	
	return X_Callback_STOP_PROPAGATION;
};

function X_Util_NinjaIframe_writeToIframe( that ){
	var raw  = that[ '_rawObject' ],
		idoc = raw.contentDocument || that._iwin.document,
		html = that._contentHTML;
	
	that._ready = true; // これを削除すると ie6,7,8 で Stack overflow at line : 0 意味不明
	delete that._contentHTML;

	idoc.open();
	idoc.writeln( html );
	idoc.close();
};

