
// ------------------------------------------------------------------------- //
// ------------ local variables -------------------------------------------- //
// ------------------------------------------------------------------------- //

var /** @const */
	X_Callback_NONE             =  0,
	/** @const */
	X_Callback_UN_LISTEN        =  1,
	/** @const */
	X_Callback_STOP_PROPAGATION =  2,
	/** @const */
	X_Callback_STOP_NOW         =  4 | 2,  // 同一階層のリスナーのキャンセル(上位へもキャンセル)
	/** @const */
	X_Callback_PREVENT_DEFAULT  =  8,  // 結果動作のキャンセル,
	/** @const */
	X_Callback_CAPTURE_POINTER  = 16,
	/** @const */
	X_Callback_RELEASE_POINTER  = 32,
	
	/** @const */
	X_Callback_SYS_CANCEL       = 64 | 4 | 2;

/**
 * X.Timer と X.EventDispaｔcher からのコールバックの返り値を定義。
 * @namespace X.Callback
 */
X[ 'Callback' ] = {
	/**
	 * このコールバックでは返り値による操作は無い。
	 * @alias X.Callback.NONE
	 */
	'NONE'             : X_Callback_NONE,
	/**
	 * X.Timer, X.EventDispaｔcher のコールバックでタイマーやイベントリスナの解除に使用。
	 * @alias X.Callback.UN_LISTEN
	 */
	'UN_LISTEN'        : X_Callback_UN_LISTEN,
	/**
	 * 上位階層へのイベント伝播のキャンセル。DOM イベントのコールバックの戻り値に指定すると e.stopPropagation() が呼ばれる。
	 * @alias X.Callback.STOP_PROPAGATION
	 */
	'STOP_PROPAGATION' : X_Callback_STOP_PROPAGATION,
	/**
	 * 以降のイベントのディスパッチを中断する。STOP_PROPAGATION との違いは、次に控えているコールバックもキャンセルされる点。但し system によって追加されたイベントはキャンセルされない。
	 * @alias X.Callback.STOP_NOW
	 */
	'STOP_NOW'         : X_Callback_STOP_NOW,
	/**
	 * DOM イベントのコールバックの戻り値に指定すると e.preventDefault() が呼ばれる。
	 * またフレームワーク内で定義されたデフォルト動作の回避にも使用される。
	 * @alias X.Callback.PREVENT_DEFAULT
	 */
	'PREVENT_DEFAULT'  : X_Callback_PREVENT_DEFAULT,
	/**
	 * X.UI の uinode でポインターイベントの戻り値に指定すると、以降のポインターベントを独占する。
	 * @alias X.Callback.CAPTURE_POINTER
	 */
	'CAPTURE_POINTER'  : X_Callback_CAPTURE_POINTER,
	/**
	 * X.UI の uinode でポインターイベントの戻り値に指定すると、以降のポインターベントを独占を解除する。
	 * @alias X.Callback.RELEASE_POINTER
	 */
	'RELEASE_POINTER'  : X_Callback_RELEASE_POINTER
};

X_TEMP.onSystemReady.push( function( sys ){
	sys.monitor( X_Callback_monitor );
	sys.gc( X_Callback_gc );
});


console.log( 'X.Core.Callback' );

