
// ------------------------------------------------------------------------- //
// ------------ local variables -------------------------------------------- //
// ------------------------------------------------------------------------- //
var X_URL_BASE_URL = ( function( parts ){
		var last = 1 < parts.length && parts[ parts.length - 1 ];
		if( last !== false && ( last === '' || //末尾が/で終わるとき
			last.indexOf( '.' ) !== -1 ) ){    //末尾がファイル名で終わる時
			--parts.length;
		};
		return parts.join( '/' );
	})( X_URL_cleanup( location.href ).split( '/' ) ),
	
	X_URL_IS_FILE  = location.protocol === 'file:',
	
	X_URL_IS_LOCAL = X_URL_IS_FILE || location.hostname === 'localhost' || location.hostname === '127.0.0.1',
	
	X_URL_PARAMS = X_URL_ParamToObj( location.search.slice( 1 ) );

// ------------------------------------------------------------------------- //
// --- interface ----------------------------------------------------------- //
// ------------------------------------------------------------------------- //

/**
 * @namespace X.URL
 * @alias X.URL
 */
X[ 'URL' ] = {

	'BASE_URL'       : X_URL_BASE_URL,
	
	'IS_FILE'        : X_URL_IS_FILE,
	
	'IS_LOCAL'       : X_URL_IS_LOCAL,
	
	'PARAMS'         : X_URL_PARAMS,
	
	'create'         : X_URL_create,
	
	'toAbsolutePath' : X_URL_toAbsolutePath,
	
	'isSameDomain'   : X_URL_isSameDomain,
	
	'isSameProtocol' : X_URL_isSameProtocol,
	
	'isLocal'        : X_URL_isLocal,
	
	'cleanup'        : X_URL_cleanup,
	
	'getEXT'         : X_URL_getEXT
};

// ------------------------------------------------------------------------- //
// --- implements ---------------------------------------------------------- //
// ------------------------------------------------------------------------- //
/*
 * original
 * AS3で相対パスを絶対パスに変換する
 * http://www.shin-go.net/motionlab/?p=449
 */
function X_URL_toAbsolutePath( path ){
	var s  = '/',
		ss = '//',
		_ary, ary, i = 0;

	if( 'http:file:https:'.indexOf( path.substr( 0, 4 ) ) !== -1 ) return path;
	
	_ary = X_URL_BASE_URL.split( ss );
	ary  = _ary[ 1 ].split( s );

	if( path.charAt( 0 ) === s ) return [ _ary[ 0 ], ss, ary[ 0 ], path ].join( '' );
		
	if( path.substr( 0, 2 ) === './' ){
		path = path.substr( 2 );
	} else {
		while( path.substr( i, 3 ) === '../' ){
			--ary.length;
			i += 3;
		};
		if( i ) path = path.substr( i );
	};
	return [ _ary[ 0 ], ss, ary.join( s ), s, path ].join( '' );
};

function X_URL_isSameDomain( path ){
	path = X_URL_cleanup( X_URL_toAbsolutePath( path ) );
	return path === X_URL_BASE_URL || path.indexOf( X_URL_BASE_URL + '/' ) === 0;
};

function X_URL_isSameProtocol( path ){
	return X_URL_toAbsolutePath( path ).indexOf( location.protocol ) === 0;
};

function X_URL_isLocal( path ){
	return X_URL_toAbsolutePath( path ).indexOf( 'file:' ) === 0;
};

function X_URL_cleanup( path ){
	return path.split( '?' )[ 0 ].split( '#' )[ 0 ];
};

function X_URL_getEXT( path ){
	path = X_URL_cleanup( path ).split( '.' );
	return path.length ? path.pop() : '';
};

function X_URL_objToParam( data ){
	var result = [], k, n = -1;
	for( k in data ){
		if( n !== -1 ) result[ ++n ] = '&';
		result[ ++n ] = k;
		result[ ++n ] = '=';
		result[ ++n ] = encodeURIComponent( data[ k ] );
	}
	return result.join( '' );
};

function X_URL_create( url, params ){
	if( !X_Type_isObject( params ) || !( params = X_URL_objToParam( params ) ) ) return url;
	
	return url + ( url.indexOf( '?' ) !== -1 ? '&' : '?' ) + params;
};

function X_URL_ParamToObj( str ){
	var i   = 0,
		obj = {},
		parts, l, pair, p;

	if( !str ) return obj;
	
	for( parts = str.split( '&' ), l = parts.length; i < l; ++i ){
		pair = parts[ i ];
		p    = pair.indexOf( '=' );
		if( p === -1 ){
			obj[ decodeURIComponent( pair ) ] = true;
		} else {
			obj[ decodeURIComponent( pair.substr( 0, p ) ) ] = X_String_parse( decodeURIComponent( pair.substr( p + 1 ) ) );
		};
	};

	return obj;	
};
