<?php
/*
 * This file is part of the somfa package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Simple O/R Mapping Class
 * PHP versions 5
 * 
 * @package SOMFA
 * @author Noriaki Koide <advans@mu-fan.com>
 *         S.Tajima<tajima@exbridge.jp> 2007/10/22 change class name etc...
 * @version svn:$Id: somfa.php 17 2009-05-09 06:21:54Z exbridge $
 * @copyright 2007-2008 Exbridge,inc.
 */
class somfa
{
    /**
     * SOMFA Session Key
     * @var array
     * @access private
     */
    var $_session_dsn_key = 'somfa.dsn';

    /**
     * SOMFA Session Key
     * @var array
     * @access private
     */
    var $_session_table_list_key = 'somfa.table.list';

    /**
     * SOMFA Config 
     * @var array
     * @access private
     */
    var $_my_conf = '';

    /**
     * SOMFA Database Instance
     * @var somfaDatabase Object
     * @access private
     */
    var $_db = null;

    /**
     * ADODB Object
     * @var ADODB Object
     * @access private
     */
    var $_con = null;

    /**
     * table list
     * @var array
     * @access private
     */
    var $_table_list = array();

    /**
     * column list
     * @var array
     * @access private
     */
    var $_column_list = array();

    /**
     * total count
     * @var array
     * @access private
     */
    var $_count = 0;

    /**
     * ident
     * @var array
     * @access private
     */
    var $_ident = 'default';

    /**
     * Construct
     * @param string
     * @return void
     */
    function somfa($somfaConfig = '', $connector_mode = '0')
    {
        require_once('somfaDatabase.php');
        require_once('somfaLogger.php');
        require_once('somfaCache.php');
        $this->_my_conf = $somfaConfig;
        //somfaLogger('DNS >>> ' . $this->_my_conf['dsn'] , __CLASS__, __FILE__, __LINE__);
        $this->_db = new somfaDatabase($this->_my_conf, $connector_mode);
    }

    /**
     * CREATE APP MODEL
     * IF No set table is Return Default MODEL
     * @param srting $TableName
     * @return MODEL Object 
     */
    function & getModel($table_name='', $ident='default')
    {
        require_once('somfaModel.php');
        $this->_connected($ident);
        //----------------------------------------------------------------------------------------------
        //本当はconstructでやりたいが、frameworkや使用している環境によってエラーとなりやすい
        //しかたなく。。。
        if (!$this->_my_conf[$ident]['session_disable']) {
            if ($this->_my_conf[$ident]['dsn'] != $_SESSION[$this->_session_dsn_key]) {
                $_SESSION[$this->_session_dsn_key] = $this->_my_conf[$ident]['dsn'];
                $_SESSION[$this->_session_table_list_key] = $this->_con->MetaTables();
            }
            $this->_table_list = $_SESSION[$this->_session_table_list_key];
        }
        else {
            $this->_table_list = $this->_con->MetaTables();
        }
        //----------------------------------------------------------------------------------------------
        //table check
        $table_name = strtolower($table_name);
        $table_list = array_flip( $this->_table_list );
        if ((isset($table_list[strtolower($table_name)])) ||
            (isset($table_list[strtoupper($table_name)]))) {

            //SET CLASS NAME for TABLE MODEL
            $class_name = $table_name.'_mdl';
            //use cache file
            if (!$this->_my_conf[$ident]['dynamic']) {
                if (!is_null($this->_my_conf[$ident]['cache_model_dir'])) {
                    $model_file = $this->_my_conf[$ident]['cache_model_dir'] . '/' . $class_name . '.php';
                    //exists cache file
                    if (file_exists ($model_file)) {
                        //instance of model class
                        if (!class_exists($class_name)) {
                            require_once($model_file);
                        }
                        $vo = & new $class_name($this->_con, $this->_my_conf[$ident]);
                        return $vo;
                    }
                }
            }

            $tbl = $table_name;
            if (strtolower($this->_my_conf[$ident]['type'])=='db2') {
                if (!is_null($this->_my_conf[$ident]['prefix'])) {
                    $tbl = $this->_my_conf[$ident]['prefix'] . '.' . $table_name;
                }
            }

            //GET table INFO
            $table_info = $this->_con->MetaColumns($tbl);

            //TAB code chr(32) space *4
            $itab = chr(32) . chr(32) . chr(32) . chr(32);

            if (!class_exists( $class_name )) {
                $dynamicClass_header    = array();
                $dynamicClass_construct = array();
                $dynamicClass_parts     = array();
                $dynamicClass_body      = array();
                $dynamicClass_footer    = array();

                $dynamicClass_header[] = 'class ' . $class_name . ' extends somfaModel {';

                foreach ($table_info as $columnItem) {
                    $c_name = strtolower($columnItem->name);
                    $dynamicClass_parts[] = $itab . $itab . '$this->_column_details["'. $c_name .'"]["max_length"] = "'. $columnItem->max_length. '";';
                    $dynamicClass_parts[] = $itab . $itab . '$this->_column_details["'. $c_name .'"]["scale"] = "'. $columnItem->scale. '";';
                    $dynamicClass_parts[] = $itab . $itab . '$this->_column_details["'. $c_name .'"]["has_default"] = "'. $columnItem->has_default. '";';
                    $dynamicClass_parts[] = $itab . $itab . '$this->_column_details["'. $c_name .'"]["not_null"] = "'. $columnItem->not_null. '";';
                    $dynamicClass_parts[] = $itab . $itab . '$this->_column_details["'. $c_name .'"]["primary_key"] = "'. $columnItem->primary_key. '";';
                    $dynamicClass_parts[] = $itab . $itab . '$this->_column_details["'. $c_name .'"]["unique"] = "'. $columnItem->unique. '";';
                    $dynamicClass_parts[] = $itab . $itab . '$this->_column_details["'. $c_name .'"]["type"] = "'. $columnItem->type. '";';
                    $dynamicClass_parts[] = $itab . $itab . '$this->_column_details["'. $c_name .'"]["auto_increment"] = "'. $columnItem->auto_increment. '";';

                    $dynamicClass_body[] = $itab . 'function set_'. $c_name. '($val) {';
                    $dynamicClass_body[] = $itab . $itab . '$val = $this->validation( $val, "'. $c_name .'");';
                    $dynamicClass_body[] = $itab . '}';
                }
                $dynamicClass_footer[] = '}';

                $dynamicClass_construct[] = $itab . 'function '.$class_name.'( $con, $config ) {';
                $dynamicClass_construct[] = $itab . $itab . '$this->_table_name ="'. $table_name.'";';

                //GET primary_keys
                $this->_primary_keys = $this->_con->MetaPrimaryKeys($tbl);
                if (isset($this->_primary_keys['0'])) {
                    foreach ($this->_primary_keys as $primary_keys) {
                        $primary_keys = strtolower($primary_keys);
                        $dynamicClass_construct[] = $itab . $itab . '$this->_primary_keys[] = "'. $primary_keys. '";';
                    }
                }
                //GET ColumnNames */
                $this->_column_list = $this->_con->MetaColumnNames($tbl);
                foreach ($this->_column_list as $column) {
                    $column = strtolower($column);
                    $dynamicClass_construct[] = $itab . $itab . '$this->_field_list[] = "'. $column. '";';
                }
                $dynamicClass_construct = array_merge($dynamicClass_construct, $dynamicClass_parts);
                $dynamicClass_construct[] = $itab . $itab . 'parent::somfaModel($con, $config);';
                $dynamicClass_construct[] = $itab . '}';

                $dynamicClass = @implode("\n", $dynamicClass_header)."\n".@implode("\n", $dynamicClass_construct)."\n".@implode("\n", $dynamicClass_body)."\n".@implode("\n", $dynamicClass_footer);

                //use cache file
                if (!$this->_my_conf[$ident]['dynamic']) {
                    if (!is_null($this->_my_conf[$ident]['cache_model_dir'])) {
                        $model_file = $this->_my_conf[$ident]['cache_model_dir'] . '/' . $class_name . '.php';
                        $fp = @fopen($model_file, 'w');@fwrite($fp, "<?php \n" . $dynamicClass . "\n?>");@fclose($fp);
                        /*@fclose(@fwrite(@fopen($model_file, 'w'), "<?php \n" . $dynamicClass . "\n?>" ));*/
                    }
                }
                eval($dynamicClass);
            }
            $vo = & new $class_name($this->_con, $this->_my_conf[$ident]);
        }
        else {
            $vo = & new somfaModel($this->_con, $this->_my_conf[$ident]);
        }
        return $vo;
    }

    /**
     * ADODB Connection Rapper
     * @param string $dns
     */
    function connect($ident='default')
    {
        //connect
        $this->_con = $this->_db->connect($ident);
        $this->_ident = $ident;
        return true;
    }

    /**
     * public
     * begin transaction
     */
    function begin()
    {
        $this->_connected();
        $this->_db->begin($this->_con);
    }

    /**
     * public
     * commit transaction
     */
    function commit()
    {
        $this->_db->commit($this->_con);
    }

    /**
     * public
     * rollback transaction
     */
    function rollback()
    {
        $this->_db->rollback($this->_con);
    }

    /**
     * public
     * close database
     */
    function close()
    {
        $this->_db->close($this->_con);
    }

    /**
     * public
     * fixedTable
     */
    function prefix()
    {
        return $this->_my_conf[$this->_ident]['prefix'];
    }

    /**
     * public
     * fixedTable
     */
    function fixedTable($table_name)
    {
        return $this->_my_conf[$this->_ident]['prefix'] . '.' . $table_name;
    }

    /**
     * public
     * execute
     */
    function execute($sql, $bind = false)
    {
        $this->_connected();
        $return = $this->_db->execute($this->_con, $sql, $bind);
        if ($return) {
            if (method_exists($return, 'GetArray')) {
                $rs = $return->GetArray();
                if (count($rs) >= 0) {
                    return $rs;
                }
            }
            return $return;
        }
        return $return;
    }

    /**
     * public
     * selectLimit
     */
    function selectLimit($sql, $limit, $offset, $bind = false)
    {
        $this->_connected();
        $return = $this->_db->selectLimit($this->_con, $sql, $limit, $offset, $bind);
        if ($return) {
            if (method_exists($return, 'GetArray')) {
                $rs = $return->GetArray();
                if (count($rs) >= 0) {
                    return $rs;
                }
            }
            return $return;
        }
        return $return;
    }

    /**
     * public
     * blob
     */
    function blob( $table, $column, $path, $where )
    {
        $this->_connected();
        return $this->_db->blob($this->_con, $table, $column, $path, $where);
    }

    /**
     * public
     * blob
     */
    function getBlob($field)
    {
        $this->_connected();
        return $this->_db->getBlob($field);
    }

    /**
     * public
     * select
     */
    function select($table, $column=null, $criterion=null, $bind=null, $order=null, $group=null, &$page=null, &$count=-1)
    {
        require_once('somfaCriteria.php');
        $this->_connected();
        $md = null;
        $c = new somfaCriteria();
        if (!is_null($table)) {
            $md = $this->getModel($table, $this->_ident);
        }
        else {
            trigger_error("table name is not found [".__METHOD__."].", E_USER_ERROR);
            return;
        }
        if (!is_null($column)) {
            $c->addColumn($column);
        }
        if (!is_null($criterion)&&($criterion != '')) {
            $c->addCriterion($criterion);
        }
        if (!is_null($order)&&($order != '')) {
            $c->addOrderByColumn($order);
        }
        if (!is_null($group)&&($group != '')) {
            $c->addGroupByColumn($group);
        }
        if (isset($md) && !is_null($md)) {
            if (isset($page) && !is_null($page)) {
                require_once('somfaPager.php');
                $pg = new somfaPager($md);
                $pg->setPageId($page);
                $rs = $pg->find($c, $bind);
                $page = $pg->_page_id;
                $count= $pg->_count;
                $this->_count = $pg->_count;
            }
            else {
                $rs = $md->find($c, $bind);
            }
        }
        else {
            trigger_error("model class is not found [".__METHOD__."].", E_USER_ERROR);
            return;
        }
        return $rs;
    }

    /**
     * public
     * retrieveByLK
     */
    function retrieveByLK($table, $val)
    {
        $this->_connected();
        $md = null;
        if (!is_null($table)) {
            $md = $this->getModel($table, $this->_ident);
        }
        else {
            trigger_error("table name is not found [".__METHOD__."].", E_USER_ERROR);
            return;
        }
        if (isset($md) && !is_null($md)) {
            $results = $md->retrieveByLK($val);
        }
        return $results;
    }

    /**
     * public
     * retrieveByPK
     */
    function retrieveByPK($table, $val)
    {
        $this->_connected();
        $md = null;
        if (!is_null($table)) {
            $md = $this->getModel($table, $this->_ident);
        }
        else {
            trigger_error("table name is not found [".__METHOD__."].", E_USER_ERROR);
            return;
        }
        if (isset($md) && !is_null($md)) {
            $results = $md->retrieveByPK($val);
        }
        return $results;
    }

    /**
     * public
     * save
     */
    function save($table, $val, $lk=null)
    {
        $this->_connected();
        $md = null;
        if (!is_null($table)) {
            $md = $this->getModel($table, $this->_ident);
        }
        else {
            trigger_error("table name is not found [".__METHOD__."].", E_USER_ERROR);
            return;
        }
        if (isset($md) && !is_null($md)) {
            $results = $md->save($val, $lk);
        }
        return $results;
    }

    /**
     * public（primary key delete only）
     * remove
     */
    function remove($table, $val)
    {
        $this->_connected();
        $md = null;
        if (!is_null($table)) {
            $md = $this->getModel($table, $this->_ident);
        }
        else {
            trigger_error("table name is not found [".__METHOD__."].", E_USER_ERROR);
            return;
        }
        if (isset($md) && !is_null($md)) {
            $results = $md->remove($val);
        }
        return $results;
    }

    /**
     * public（logical key delete）
     * delete
     */
    function delete($table, $val)
    {
        $this->_connected();
        $md = null;
        if (!is_null($table)) {
            $md = $this->getModel($table, $this->_ident);
        }
        else {
            trigger_error("table name is not found [".__METHOD__."].", E_USER_ERROR);
            return;
        }
        if (isset($md) && !is_null($md)) {
            $results = $md->delete($val);
        }
        return $results;
    }

    function count()
    {
        return $this->_count;
    }

    function _connected($ident='default') {
        if (is_null($this->_con)) {
            $this->connect($ident);
        }
    }
}
