﻿using System;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Windows;
using MControls = Microsoft.Windows.Controls;
using Progressive.PecaStarter.Dao;
using Progressive.PecaStarter.Dxo;
using Progressive.PecaStarter.View;
using Progressive.PecaStarter.View.TaskTray;
using Progressive.PecaStarter.ViewModel;

namespace Progressive.PecaStarter
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : GlassWindow
    {
        private TaskTrayIconManager taskTrayIconManager;

        public MainWindow()
        {
            taskTrayIconManager = null;
            var sd = new SaveDataDao().Select();
            if (sd == null)
            {
                DataContext = new MainWindowViewModel();
            }
            else
            {
                DataContext = SaveDataDxo.toViewModel(sd);
            }
            InitializeComponent();
        }

        protected override void OnClosing(System.ComponentModel.CancelEventArgs e)
        {
            try
            {
                var vm = DataContext as MainWindowViewModel;
                if (vm == null)
                {
                    return;
                }
                var info = vm.CanClose();
                if (!info.Item1)
                {
                    switch (info.Item2)
                    {
                        case MessageBoxButton.OK:
                            MControls.MessageBox.Show(info.Item3, "", info.Item2, MessageBoxImage.Error);
                            e.Cancel = true;
                            return;
                        case MessageBoxButton.YesNo:
                            var result = MControls.MessageBox.Show(info.Item3, "", info.Item2, MessageBoxImage.Question, MessageBoxResult.None);
                            if (result != MessageBoxResult.Yes)
                            {
                                e.Cancel = true;
                                return;
                            }
                            break;
                        default:
                            throw new NotImplementedException();
                    }
                }
                vm.Dispose();
            }
            finally
            {
                base.OnClosing(e);
            }
        }

        protected override void OnClosed(EventArgs e)
        {
            if (taskTrayIconManager != null)
            {
                taskTrayIconManager.Dispose();
                taskTrayIconManager = null;
            }
            base.OnClosed(e);
        }
        private void OnLoaded(object sender, RoutedEventArgs e)
        {
            var settings = (DataContext as MainWindowViewModel).SettingsViewModel;
            taskTrayIconManager = new TaskTrayIconManager(sender as Window, settings, "IsNotifyIcon");
            settings.IsNotifyIcon = settings.IsNotifyIcon;
        }

        private void OnUpdateHistoryItemClicked(object sender, System.Windows.RoutedEventArgs e)
        {
            (DataContext as MainWindowViewModel).ExternalSourceViewModel.UpdateHistory();
        }

        private void OnAssemblyPathItemClicked(object sender, System.Windows.RoutedEventArgs e)
        {
            Process.Start(new FileInfo(Assembly.GetExecutingAssembly().Location).Directory.FullName);
        }

        private void OnConfigurationPathItemClicked(object sender, System.Windows.RoutedEventArgs e)
        {
            Process.Start(new FileInfo((DataContext as MainWindowViewModel).ConfigurationPath).Directory.FullName);
        }
    }
}
