﻿using System.Collections.Generic;
using System.Windows;
using Progressive.PecaStarter.Model;
using System;

namespace Progressive.PecaStarter.ViewModel.Page
{
    public class YellowPagesesViewModel : ViewModelBase
    {
        #region Variables
        private readonly MainWindowViewModel parent;
        private YellowPagesViewModel selectedYellowPages;
        #endregion

        #region Binding Properties
        public IDictionary<string, YellowPagesViewModel> YellowPageses { get { return parent.YellowPageses; } }
        public bool IsSelectorEnabled { get { return !parent.IsBusy && !parent.IsBroadcast; } }
        public YellowPagesViewModel SelectedYellowPages
        {
            get { return selectedYellowPages; }
            set
            {
                selectedYellowPages = value;
                NotifyPropertyChanged("SelectedYellowPages");
            }
        }
        public Visibility SelectedYellowPagesVisibility { get { return selectedYellowPages != null ? Visibility.Visible : Visibility.Collapsed; } }
        #endregion

        public YellowPagesesViewModel(MainWindowViewModel parent)
        {
            this.parent = parent;
            SelectedYellowPages = null;
            //foreach (var yp in YellowPageses.Values)
            //{
            //    AddRelation(yp, "SelectedYellowPages");
            //}
            AddRelation(parent, "IsBusy", "IsSelectorEnabled");
            AddRelation(parent, "IsBroadcast", "IsSelectorEnabled");
            AddRelation("SelectedYellowPages", "SelectedYellowPagesVisibility");
        }
    }
}
