﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using Progressive.PecaStarter.ViewModel.Page;
using Progressive.PecaStarter.Model;
using System.Collections.ObjectModel;

namespace Progressive.PecaStarter.ViewModel.Command
{
    public class ReloadCommand : PeercastCommandBase
    {
        private readonly RelayListViewModel relayListViewModel;

        public ReloadCommand(Peercast peercast, MainWindowViewModel mainWindowViewModel, RelayListViewModel relayListViewModel)
            : base(peercast, mainWindowViewModel)
        {
            this.relayListViewModel = relayListViewModel;
        }

        protected override bool CanExecute()
        {
            return true;
        }

        protected override async Task Execute()
        {
            viewModel.Feedback = "通信中...";
            relayListViewModel.IsListEnabled = false;
            try
            {
                var info = await peercast.GetChannels();
                if (info.Result != Result.Success)
                {
                    viewModel.Feedback = "中止";
                    viewModel.NotifyAlert("チャンネルリストの取得に失敗しました。\n原因: " + GetErrorMessage(info.Result));
                    return;
                }
                relayListViewModel.Channels = new List<Channel>(info.Value);
                viewModel.Feedback = "チャンネルリストを更新しました";
            }
            finally
            {
                relayListViewModel.IsListEnabled = true;
            }
        }
    }
}
