﻿using System.ComponentModel;
using System.Windows;
using System.Windows.Controls;
using Progressive.PecaStarter.Util;

namespace Progressive.PecaStarter.View.Control
{
    class Alert : ContentControl
    {
        protected override void OnPropertyChanged(DependencyPropertyChangedEventArgs e)
        {
            base.OnPropertyChanged(e);
            if (e.Property.Name != "Content")
            {
                return;
            }
            if (e.NewValue as string == "")
            {
                return;
            }
            Microsoft.Windows.Controls.MessageBox.Show(WpfUtils.GetRoot(this), e.NewValue as string, "エラー", MessageBoxButton.OK, MessageBoxImage.Error);
        }
    }
}
