﻿using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using Progressive.PecaStarter.Entity;
using Progressive.PecaStarter.ViewModel;
using Progressive.PecaStarter.ViewModel.Page;

namespace Progressive.PecaStarter.Dxo
{
    public static class SaveDataDxo
    {
        public static SaveData toEntity(MainWindowViewModel vm)
        {
            var selected = vm.YellowPagesesViewModel.SelectedYellowPages;
            var ypValues = new List<YellowPages>();
            foreach (var kvp in vm.YellowPagesesViewModel.YellowPageses)
            {
                var yp = kvp.Value;
                var myypValues = new List<Parameter>();
                myypValues.Add(Parameter.Create("AcceptedHash", yp.AcceptedHash.ToString()));
                foreach (var key in yp.Keys)
                {
                    myypValues.Add(Parameter.Create(key, yp[key]));
                }
                ypValues.Add(new YellowPages() { Name = yp.Name, Parameters = myypValues });
            }
            return new SaveData()
            {
                Left = vm.Left,
                Top = vm.Top,
                Height = vm.Height,
                Width = vm.Width,
                SelectedYellowPagesName = selected != null ? selected.Name : "",
                YellowPagesValues = ypValues,
                ExternalSourceStreamUrl = vm.ExternalSourceViewModel.StreamUrl,
                ExternalSourceNames = new List<string>(vm.ExternalSourceViewModel.Name.History),
                ExternalSourceGenres = new List<string>(vm.ExternalSourceViewModel.Genre.History),
                ExternalSourceDescriptions = new List<string>(vm.ExternalSourceViewModel.Description.History),
                ExternalSourceContacts = new List<string>(vm.ExternalSourceViewModel.ContactUrl.History),
                ExternalSourceComments = new List<string>(vm.ExternalSourceViewModel.Comment.History),
                SettingsPort = vm.SettingsViewModel.Port,
                SettingsIsNotifyIcon = vm.SettingsViewModel.IsNotifyIcon,
                SettingsIsSavePosition = vm.SettingsViewModel.IsSavePosition,
                SettingsLogging = vm.SettingsViewModel.Logging,
                SettingsLogPath = vm.SettingsViewModel.LogPath,
                SettingsDelay = vm.SettingsViewModel.Delay,
            };
        }

        public static MainWindowViewModel toViewModel(SaveData sd)
        {
            var mwvm = new MainWindowViewModel();
            if (sd.SettingsIsSavePosition)
            {
                mwvm.Left = sd.Left;
                mwvm.Top = sd.Top;
                mwvm.Height = sd.Height;
                mwvm.Width = sd.Width;
            }
            Convert(sd, mwvm.YellowPagesesViewModel);
            Convert(sd, mwvm.ExternalSourceViewModel);
            Convert(sd, mwvm.SettingsViewModel);
            return mwvm;
        }

        private static void Convert(SaveData sd, YellowPagesesViewModel ypsvm)
        {
            var selected = ypsvm.YellowPageses.Where(a => a.Key == sd.SelectedYellowPagesName);
            if (selected.Count() == 1)
            {
                ypsvm.SelectedYellowPages = selected.Single().Value;
            }
            foreach (var yp in ypsvm.YellowPageses.Values)
            {
                Convert(sd, yp);
            }
        }

        private static void Convert(SaveData sd, YellowPagesViewModel ypvm)
        {
            if (sd.YellowPagesValues == null)
            {
                return;
            }
            var ypvs = sd.YellowPagesValues.Where(a => a.Name == ypvm.Name);
            if (ypvs.Count() != 1)
            {
                return;
            }
            var values = ypvs.Single().Parameters;
            var acceptedHash = values.Where(a => a.Key == "AcceptedHash");
            if (acceptedHash.Count() == 1)
            {
                int result;
                int.TryParse(acceptedHash.Single().Value, out result);
                ypvm.AcceptedHash = result;
                ypvm.IsAccepted = result != 0 ? true : false;
            }
            foreach (var key in ypvm.Keys)
            {
                var kvps = values.Where(a => a.Key == key);
                if (kvps.Count() == 1)
                {
                    ypvm[key] = kvps.Single().Value;
                }
            }
        }

        private static void Convert(SaveData sd, ExternalSourceViewModel esvm)
        {
            esvm.StreamUrl = sd.ExternalSourceStreamUrl;
            Convert(sd.ExternalSourceNames, esvm.Name);
            Convert(sd.ExternalSourceGenres, esvm.Genre);
            Convert(sd.ExternalSourceDescriptions, esvm.Description);
            Convert(sd.ExternalSourceContacts, esvm.ContactUrl);
            Convert(sd.ExternalSourceComments, esvm.Comment);
        }

        private static void Convert(List<string> sd, TextBoxWithHistoryViewModel vm)
        {
            vm.Value = sd.Count == 0 ? "" : sd[0];
            vm.History = new ObservableCollection<string>(sd);
        }


        private static void Convert(SaveData sd, SettingsViewModel svm)
        {
            svm.Port = sd.SettingsPort;
            svm.IsNotifyIcon = sd.SettingsIsNotifyIcon;
            svm.IsSavePosition = sd.SettingsIsSavePosition;
            svm.Logging = sd.SettingsLogging;
            svm.LogPath = sd.SettingsLogPath;
            svm.Delay = sd.SettingsDelay;
        }
    }
}
