﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;
using System.Threading.Tasks;

namespace Progressive.PecaStarter.Commons.Networks
{
    static class HttpWebRequestAsyncExtension
    {
        public static Task AccessAsync(this HttpWebRequest webRequest)
        {
            return Task.Factory.FromAsync(
                    webRequest.BeginAccess(null, null),
                    new Action<IAsyncResult>(webRequest.EndAccess));
        }

        public static Task<string> GetTextAsync(this HttpWebRequest webRequest)
        {
            return Task.Factory.FromAsync(
                    webRequest.BeginGetText(null, null),
                    new Func<IAsyncResult, string>(webRequest.EndGetText));
        }
    }
}
