﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Progressive.PecaStarter.Model;
using Progressive.PecaStarter.Model.Internal;
using Progressive.PecaStarter.ViewModel.Page;

namespace Progressive.PecaStarter.ViewModel.Command
{
    public class UpdateCommand : ChannelCommandBase
    {
        public UpdateCommand(Peercast peercast, Logger logger, IList<YellowPages> yellowPageses, MainWindowViewModel viewModel)
            : base(peercast, logger, yellowPageses, viewModel) { }

        #region ICommand メンバー
        protected override bool CanExecute()
        {
            if (!peercast.IsBroadcast)
            {
                return false;
            }
            var esvm = viewModel.ExternalSourceViewModel;
            if (!TryLength(esvm.Description.Value)) return false;
            if (!TryLength(esvm.ContactUrl.Value)) return false;
            if (!TryLength(esvm.Comment.Value)) return false;
            var ypvm = viewModel.YellowPagesesViewModel.SelectedYellowPages;
            var yp = yellowPageses.Single(a => a.Name == ypvm.Name);
            if (yp is PeercastYellowPages)
            {
                if (!TryLength(ypvm.Prefix + esvm.Genre.Value)) return false;
                return true;
            }
            else
            {
                if (!TryLength(esvm.Genre.Value)) return false;
                foreach (var param in (yp as WebApiYellowPages).UpdateParameters)
                {
                    if (WebApiDefine.ExcludeParameters.Contains(param))
                    {
                        continue;
                    }
                    if (!TryLength(ypvm[param])) return false;
                }
                return true;
            }
        }
        protected override async Task Execute()
        {
            viewModel.Save();
            viewModel.Feedback = "通信中...";
            var ypvm = viewModel.YellowPagesesViewModel.SelectedYellowPages;
            var yp = yellowPageses.Single(a => a.Name == ypvm.Name);
            if (yp is PeercastYellowPages)
            {
                var result = await PeercastYpExecute(ypvm, viewModel.ExternalSourceViewModel);
                if (result != Result.Success)
                {
                    viewModel.Feedback = "中止";
                    viewModel.NotifyAlert("チャンネル情報の更新時にエラーが発生しました。\n原因: " + GetErrorMessage(result));
                    return;
                }
            }
            else
            {
                var info = await WebApiYpExecute(yp as WebApiYellowPages, ypvm, viewModel.ExternalSourceViewModel);
                if (info.Result != Result.Success)
                {
                    viewModel.Feedback = "中止";
                    viewModel.NotifyAlert("チャンネル情報の更新時にエラーが発生しました。\n原因: " + GetErrorMessage(info));
                    return;
                }
            }
            if (viewModel.SettingsViewModel.Logging)
            {
                var esvm = viewModel.ExternalSourceViewModel;
                logger.insert("", "", esvm.Genre.Value, esvm.Description.Value, esvm.Comment.Value);
            }
            viewModel.Feedback = "チャンネル情報を更新しました";
        }
        #endregion
        private async Task<Result> PeercastYpExecute(YellowPagesViewModel ypvm, ExternalSourceViewModel esvm)
        {
            return (await peercast.Update(ypvm.Prefix + esvm.Genre.Value,
                    esvm.Description.Value, esvm.ContactUrl.Value, esvm.Comment.Value, "", "", "", "", "")).Result;
        }
        private async Task<ResultInfo<string>> WebApiYpExecute(WebApiYellowPages wyp, YellowPagesViewModel ypvm, ExternalSourceViewModel esvm)
        {
            var info = await peercast.Update(esvm.Genre.Value, esvm.Description.Value, esvm.ContactUrl.Value, esvm.Comment.Value, "", "", "", "", "");
            if (info.Result != Result.Success)
            {
                return ResultInfo.Create(info.Result, "");
            }
            return await wyp.Update(GetWebApiParameters(wyp.UpdateParameters, info.Value, ypvm, esvm, ""));
        }
    }
}
