﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Input;
using Progressive.PecaStarter.Model;
using Progressive.PecaStarter.ViewModel.Page;

namespace Progressive.PecaStarter.ViewModel.Command
{
    public class OpenCommand : ICommand
    {
        private readonly Peercast peercast;
        private readonly IList<YellowPages> yellowPageses;
        private readonly MainWindowViewModel viewModel;

        public OpenCommand(Peercast peercast, IList<YellowPages> yellowPageses, MainWindowViewModel viewModel)
        {
            this.peercast = peercast;
            this.yellowPageses = yellowPageses;
            this.viewModel = viewModel;
        }
        #region ICommand メンバー
        public bool CanExecute(object parameter)
        {
            if (viewModel.RelayListViewModel.SelectedYellowPages == null)
            {
                return false;
            }
            var ch = parameter as Channel;
            if (ch == null || ch.Status != "BROADCAST")
            {
                return false;
            }
            return true;
        }

        public event EventHandler CanExecuteChanged
        {
            add { CommandManager.RequerySuggested += value; }
            remove { CommandManager.RequerySuggested -= value; }
        }

        public void Execute(object parameter)
        {
            var ch = parameter as Channel;
            if (ch == null || viewModel.IsBusy)
            {
                throw new ApplicationException();
            }
            viewModel.IsBusy = true;
            try
            {
                if (viewModel.IsTimerRunning)
                {
                    if (viewModel.SettingsViewModel.Logging)
                    {
                        viewModel.EndTimer("（中断）");
                    }
                    else
                    {
                        viewModel.EndTimer();
                    }
                }
                peercast.SetChannel(ch.Name, ch.Id);
                viewModel.YellowPagesesViewModel.SelectedYellowPages = viewModel.RelayListViewModel.SelectedYellowPages;
                var esvm = viewModel.ExternalSourceViewModel;
                esvm.Name.Value = ch.Name;
                esvm.Genre.Value = viewModel.YellowPagesesViewModel.SelectedYellowPages.Parse(ch.Genre);
                esvm.Description.Value = ch.Description;
                esvm.ContactUrl.Value = ch.ContactUrl;
                esvm.Comment.Value = ch.Comment;
                esvm.Name.Value = ch.Name;
                viewModel.SelectedIndex = 3;
                var ypvm = viewModel.YellowPagesesViewModel.SelectedYellowPages;
                var yp = yellowPageses.Single(a => a.Name == ypvm.Name);
                if (yp is WebApiYellowPages || viewModel.SettingsViewModel.Logging)
                {
                    viewModel.BeginTimer();
                }
                viewModel.Feedback = "\"" + ch.Name + "\"で配信中です";
            }
            finally
            {
                viewModel.IsBusy = false;
            }
        }
        #endregion
    }
}
