﻿using System;
using System.ComponentModel;
using System.Windows;

namespace Progressive.PecaStarter.View.TaskTray
{
    class TaskTrayIconManager : IDisposable
    {
        private TaskTrayIcon taskTrayIcon;
        private Window root;
        private INotifyPropertyChanged dataSource;
        private string propertyName;

        public bool IsEnabled { get { return taskTrayIcon != null; } }

        public TaskTrayIconManager(Window root, INotifyPropertyChanged source, string propertyName)
        {
            this.root = root;
            this.dataSource = source;
            this.propertyName = propertyName;
            source.PropertyChanged += source_PropertyChanged;
        }
        ~TaskTrayIconManager()
        {
            Dispose();
            dataSource.PropertyChanged -= source_PropertyChanged;
        }

        public void Dispose()
        {
            Disable();
        }
        public void Enable()
        {
            if (taskTrayIcon == null)
            {
                taskTrayIcon = new TaskTrayIcon(root);
                taskTrayIcon.Icon = Progressive.PecaStarter.Properties.Resources.icon;
                taskTrayIcon.Text = root.Title;
                taskTrayIcon.BalloonTipText = "";
                taskTrayIcon.BalloonTipTitle = root.Title;
            }
        }
        public void Disable()
        {
            if (taskTrayIcon != null)
            {
                taskTrayIcon.Dispose();
                taskTrayIcon = null;
            }
        }
        private void source_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == propertyName)
            {
                var isEnabled = (bool)sender.GetType().GetProperty(propertyName).GetValue(dataSource, null);
                if (isEnabled)
                {
                    Enable();
                }
                else
                {
                    Disable();
                }
            }
        }
    }
}
