﻿using System;
using System.Collections;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using Progressive.PecaStarter.Common;
using Progressive.PecaStarter.ViewModel.Page;
using System.ComponentModel;
using System.Reflection;

namespace Progressive.PecaStarter.View.Page
{
    /// <summary>
    /// Parameters.xaml の相互作用ロジック
    /// </summary>
    public partial class YellowPages : UserControl
    {
        public YellowPages()
        {
            InitializeComponent();
        }

        private void Hyperlink_Click(object sender, RoutedEventArgs e)
        {
            Process.Start(((sender as Hyperlink).DataContext as string));
        }

        /// <summary>
        /// (DataContextの変更通知を受けて)Viewを更新
        /// disabled?
        /// </summary>
        public void UpdateTarget()
        {
            // foreach (var input in InputsStackPanel.Children)
            Parallel.ForEach(InputsStackPanel.Children.Cast<UIElement>(), (input) =>
            {
                if (!(input is UserControl))
                {
                    return;
                }
                var content = (input as UserControl).Content;
                if (content is ComboBox)
                {
                    var comboBox = content as ComboBox;
                    comboBox.GetBindingExpression(ComboBox.SelectedValueProperty).UpdateTarget();
                    return;
                }
                if (content is TextBox)
                {
                    (content as TextBox).GetBindingExpression(TextBox.TextProperty).UpdateTarget();
                    return;
                }
            });
            // foreach (var input in CheckboxesStackPanel.Children)
            Parallel.ForEach(CheckboxesStackPanel.Children.Cast<UIElement>(), (input) =>
            {
                if (!(input is UserControl))
                {
                    return;
                }
                ((input as UserControl).Content as CheckBox).GetBindingExpression(CheckBox.IsCheckedProperty).UpdateTarget();
                return;
            });
        }

        /// <summary>
        /// コントロールを生成
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnDataContextChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            Clear();
            var components = e.NewValue as YellowPagesViewModel;
            if (components == null)
            {
                if (e.NewValue.GetType().Name == "WpfBindingWrapper")
                {
                    return;
                }
                throw new ArgumentException();
            }
            int i = 11;
            foreach (var key in components.Keys)
            {
                switch (key)
                {
                    case YellowPagesDefine.Namespace:
                        AddTextBox("名前空間:", components, key, i);
                        break;
                    case YellowPagesDefine.Password:
                        AddPasswordBox("パスワード:", components, key, i);
                        break;
                    case YellowPagesDefine.NoLog:
                        AddCheckBox("statsを記録しない", components, key, i);
                        break;
                    case YellowPagesDefine.ListenersVisibility:
                        AddCheckBox("リスナー数を表示しない", components, key, i);
                        break;
                    case YellowPagesDefine.ListenersInvisibility:
                        AddCheckBox("リスナー数を表示しない", components, key, i);
                        break;
                    case YellowPagesDefine.TimeVisibility:
                        AddCheckBox("配信時間を表示する", components, key, i);
                        break;
                    case YellowPagesDefine.TimeInvisibility:
                        AddCheckBox("配信時間を表示しない", components, key, i);
                        break;
                    case YellowPagesDefine.PortBandwidthCheck:
                        AddComboBox("ポート/帯域チェック:", components, key, new Tuple<string, string>[]
                        {
                            Tuple.Create("無効", "0"),
                            Tuple.Create("ポートチェック", "1"),
                            Tuple.Create("ポートチェック+帯域チェック", "2"),
                            Tuple.Create("ポートチェック+帯域チェック(高速回線)", "3")
                        }, "Item1", "Item2", i);
                        break;
                    case YellowPagesDefine.OutsideDisplay:
                        AddComboBox("チャンネルの外部掲載:", components, key, new Tuple<string, string>[]
                        {
                            Tuple.Create("全てに掲載", "0"),
                            Tuple.Create("RSSに掲載しない", "1"),
                            Tuple.Create("HTML及び、RSSに掲載しない", "2"),
                        }, "Item1", "Item2", i);
                        break;
                }
                i++;
            }
        }

        private void Clear()
        {
            LabelsStackPanel.Children.Clear();
            InputsStackPanel.Children.Clear();
            CheckboxesStackPanel.Children.Clear();
        }

        private void AddTextBox(string content, object dataContext, string key, int index)
        {
            LabelsStackPanel.Children.Add(new Label() { Content = content });
            var control = new TextBox() { DataContext = dataContext, TabIndex = index };
            control.SetBinding(TextBox.TextProperty, new Binding(key));
            InputsStackPanel.Children.Add(new UserControl() { Content = control });
            CheckboxesStackPanel.Children.Add(new FrameworkElement());
        }

        private void AddPasswordBox(string content, object dataContext, string key, int index)
        {
            LabelsStackPanel.Children.Add(new Label() { Content = content });
            var control = new PasswordBox() { DataContext = dataContext, TabIndex = index };
            var vm = dataContext as YellowPagesViewModel;
            control.Password = vm[key];
            PropertyChangedEventHandler onSourceChanged = (sender, e) =>
            {
                if (e.PropertyName != key)
                {
                    return;
                }
                if (control.Password == vm[key])
                {
                    return;
                }
                control.Password = vm[key];
            };
            vm.PropertyChanged += onSourceChanged;
            control.PasswordChanged += (sender, e) =>
            {
                if (vm[key] != control.Password)
                {
                    vm[key] = control.Password;
                }
            };
            control.Unloaded += (sender, e) => vm.PropertyChanged -= onSourceChanged;
            InputsStackPanel.Children.Add(new UserControl() { Content = control });
            CheckboxesStackPanel.Children.Add(new FrameworkElement());
        }

        private void AddCheckBox(string content, object dataContext, string key, int index)
        {
            LabelsStackPanel.Children.Add(new FrameworkElement());
            InputsStackPanel.Children.Add(new FrameworkElement());
            var control = new CheckBox() { Content = content, TabIndex = index };
            control.SetBinding(CheckBox.IsCheckedProperty, new Binding(key));
            CheckboxesStackPanel.Children.Add(new UserControl() { Content = control });
        }

        private void AddComboBox(string content, object dataContext, string key, IEnumerable items, string displayMemberPath, string selectedValuePath, int index)
        {
            LabelsStackPanel.Children.Add(new Label() { Content = content });
            var control = new ComboBox()
            {
                DataContext = dataContext,
                ItemsSource = items,
                DisplayMemberPath = displayMemberPath,
                SelectedValuePath = selectedValuePath,
                TabIndex = index
            };
            control.SetBinding(ComboBox.SelectedValueProperty, new Binding(key));
            InputsStackPanel.Children.Add(new UserControl() { Content = control });
            CheckboxesStackPanel.Children.Add(new FrameworkElement());
        }
    }
}
