﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Progressive.PecaStarter.Model
{
    public enum Result
    {
        Success, ConnectFailure, GettingSettingsHtmlFailure, ChannelDuplicated,
        CreatingChannelFailure, DeletingChannelFailure, UpdatingChannelFailure,
        YellowPagesFailure
    }

    public static class ResultExtensions
    {
        public static string GetErrorMessage(this Result result)
        {
            switch (result)
            {
                case Result.ChannelDuplicated:
                    return "チャンネルの重複";
                case Result.ConnectFailure:
                    return "接続に失敗";
                case Result.CreatingChannelFailure:
                    return "チャンネルの作成に失敗";
                case Result.UpdatingChannelFailure:
                    return "チャンネル情報の更新に失敗";
                case Result.DeletingChannelFailure:
                    return "チャンネルの切断に失敗";
                case Result.GettingSettingsHtmlFailure:
                    return "設定へのアクセスに失敗";
                default:
                    throw new NotSupportedException();
            }
        }
    }

    public class ResultInfo<T>
    {
        public readonly Result Result;
        public readonly T Value;

        public ResultInfo(Result result, T value)
        {
            Result = result;
            Value = value;
        }

        public string GetErrorMessage()
        {
            var value = Value as string;
            if (value == null)
            {
                throw new NotImplementedException();
            }
            switch (Result)
            {
                case Result.YellowPagesFailure:
                    return "イエローページサーバのエラー\nエラーメッセージ: " + value;
                case Result.ConnectFailure:
                    return string.IsNullOrEmpty(value) ? "接続に失敗" : "接続に失敗\n" + value;
                default:
                    return Result.GetErrorMessage();
            }
        }
    }

    public static class ResultInfo
    {
        public static ResultInfo<T> Create<T>(Result result, T value)
        {
            return new ResultInfo<T>(result, value);
        }
    }
}
