/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.ModelTextSelection;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.actions.FindMethodExitOccurrencesAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.keys.IBindingService;

public class OccurrencesSearchGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private PHPStructuredEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindMethodExitOccurrencesAction fMethodExitOccurrencesAction;

    public OccurrencesSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fMethodExitOccurrencesAction = new FindMethodExitOccurrencesAction(site);
        this.fMethodExitOccurrencesAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.search.method.exits");
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fMethodExitOccurrencesAction, provider, selection);
    }

    public OccurrencesSearchGroup(PHPStructuredEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fMethodExitOccurrencesAction = new FindMethodExitOccurrencesAction(this.fEditor);
        this.fMethodExitOccurrencesAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.search.method.exits");
        this.fEditor.setAction("ExitOccurrencesAction", (IAction)this.fMethodExitOccurrencesAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    public void fillContextMenu(IMenuManager manager) {
        String menuText = "SearchMessages.group_occurrences";
        String shortcut = this.getShortcutString();
        if (shortcut != null) {
            menuText = String.valueOf(menuText) + '\t' + shortcut;
        }
        MenuManager javaSearchMM = new MenuManager(menuText, "group.search");
        javaSearchMM.add((IAction)new Action(){});
        javaSearchMM.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mm) {
                mm.removeAll();
                OccurrencesSearchGroup.this.updateActionsInPhpEditor();
                this.addAction((Action)OccurrencesSearchGroup.this.fMethodExitOccurrencesAction, mm);
                if (mm.isEmpty()) {
                    mm.add((IAction)new Action("SearchMessages.group_occurrences_quickMenu_noEntriesAvailable"){

                        public boolean isEnabled() {
                            return false;
                        }
                    });
                }
            }

            private void addAction(Action action, IMenuManager mm) {
                if (action.isEnabled()) {
                    mm.add((IAction)action);
                }
            }
        });
        manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
    }

    private void updateActionsInPhpEditor() {
        if (this.fEditor == null) {
            return;
        }
        ISourceModule element = SelectionConverter.getInput(this.fEditor);
        if (element == null) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        IDocument document = DLTKUIPlugin.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        ModelTextSelection phpSelection = new ModelTextSelection((IModelElement)element, document, textSelection.getOffset(), textSelection.getLength());
        this.fMethodExitOccurrencesAction.update((ISelection)phpSelection);
    }

    private String getShortcutString() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService == null) {
            return null;
        }
        return bindingService.getBestActiveBindingFormattedFor("org.eclipse.php.ui.edit.text.search.occurrences.in.file.quickMenu");
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction((ISelectionChangedListener)this.fMethodExitOccurrencesAction, provider);
        }
        super.dispose();
        this.fMethodExitOccurrencesAction = null;
        this.updateGlobalActionHandlers();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.php.ui.actions.MethodExitOccurrences", (IAction)this.fMethodExitOccurrencesAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

