/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.PreferencesMessages;
import org.eclipse.php.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.StatusUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class PHPProjectLayoutPreferencePage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.eclipse.php.ui.preferences.PHPProjectLayoutPreferencePage";
    public static final String PROP_ID = "org.eclipse.php.ui.propertyPages.PHPProjectLayoutPreferencePage";
    private static final String SRCBIN_FOLDERS_IN_NEWPROJ = "org.eclipse.php.ui.wizards.srcBinFoldersInNewProjects";
    private static final String SRCBIN_SRCNAME = "com.xore.dltk.ui.wizards.srcFoldersSrcName";
    private static final String SRCBIN_BINNAME = "org.eclipse.php.ui.wizards.srcBinFoldersBinName";
    private ArrayList fRadioButtons;
    private Button fProjectAsSourceFolder;
    private Button fFoldersAsSourceFolder;
    private Label fSrcFolderNameLabel;
    private Label fBinFolderNameLabel;
    private ArrayList fTextControls;
    private Text fSrcFolderNameText;
    private Text fBinFolderNameText;
    private SelectionListener fSelectionListener;
    private ModifyListener fModifyListener;

    public PHPProjectLayoutPreferencePage() {
        this.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.NewPHPProjectPreferencePage_description);
        this.fRadioButtons = new ArrayList();
        this.fTextControls = new ArrayList();
        this.fSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PHPProjectLayoutPreferencePage.this.controlChanged(e.widget);
            }
        };
        this.fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PHPProjectLayoutPreferencePage.this.controlModified(e.widget);
            }
        };
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.new_project_layout_preferences");
    }

    private void controlModified(Widget widget) {
        if (widget == this.fSrcFolderNameText || widget == this.fBinFolderNameText) {
            this.validateFolders();
        }
    }

    protected Control createPreferenceContent(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group sourceFolderGroup = new Group(result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        sourceFolderGroup.setLayout((Layout)layout);
        sourceFolderGroup.setLayoutData((Object)gd);
        sourceFolderGroup.setText(PreferencesMessages.NewPHPProjectPreferencePage_sourcefolder_label);
        int indent = 0;
        this.fProjectAsSourceFolder = this.addRadioButton((Composite)sourceFolderGroup, PreferencesMessages.NewPHPProjectPreferencePage_sourcefolder_project, SRCBIN_FOLDERS_IN_NEWPROJ, "false", indent);
        this.fProjectAsSourceFolder.addSelectionListener(this.fSelectionListener);
        this.fFoldersAsSourceFolder = this.addRadioButton((Composite)sourceFolderGroup, PreferencesMessages.NewPHPProjectPreferencePage_sourcefolder_folder, SRCBIN_FOLDERS_IN_NEWPROJ, "true", indent);
        this.fFoldersAsSourceFolder.addSelectionListener(this.fSelectionListener);
        indent = this.convertWidthInCharsToPixels(4);
        this.fSrcFolderNameLabel = new Label((Composite)sourceFolderGroup, 0);
        this.fSrcFolderNameLabel.setText(PreferencesMessages.NewPHPProjectPreferencePage_folders_src);
        this.fSrcFolderNameText = this.addTextControl((Composite)sourceFolderGroup, this.fSrcFolderNameLabel, SRCBIN_SRCNAME, indent);
        this.fSrcFolderNameText.addModifyListener(this.fModifyListener);
        this.fBinFolderNameLabel = new Label((Composite)sourceFolderGroup, 0);
        this.fBinFolderNameLabel.setText(PreferencesMessages.NewPHPProjectPreferencePage_folders_public);
        this.fBinFolderNameText = this.addTextControl((Composite)sourceFolderGroup, this.fBinFolderNameLabel, SRCBIN_BINNAME, indent);
        this.fBinFolderNameText.addModifyListener(this.fModifyListener);
        this.validateFolders();
        return result;
    }

    private Button addRadioButton(Composite parent, String label, String key, String value, int indent) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = indent;
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, value});
        button.setLayoutData((Object)gd);
        button.setSelection(value.equals(this.getPreferenceStore().getString(key)));
        this.fRadioButtons.add(button);
        return button;
    }

    private Text addTextControl(Composite parent, Label labelControl, String key, int indent) {
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        Text text = new Text(parent, 2052);
        text.setText(this.getPreferenceStore().getString(key));
        text.setData((Object)key);
        text.setLayoutData((Object)gd);
        this.fTextControls.add(text);
        return text;
    }

    private void validateFolders() {
        boolean useFolders = this.fFoldersAsSourceFolder.getSelection();
        this.fSrcFolderNameText.setEnabled(useFolders);
        this.fBinFolderNameText.setEnabled(useFolders);
        this.fSrcFolderNameLabel.setEnabled(useFolders);
        this.fBinFolderNameLabel.setEnabled(useFolders);
        if (useFolders) {
            IStatus status;
            String srcName = this.fSrcFolderNameText.getText();
            String binName = this.fBinFolderNameText.getText();
            if (srcName.length() + binName.length() == 0) {
                this.updateStatus(new StatusInfo(4, PreferencesMessages.NewPHPProjectPreferencePage_folders_error_namesempty));
                return;
            }
            IWorkspace workspace = PHPUiPlugin.getWorkspace();
            IProject dmy = workspace.getRoot().getProject("project");
            IPath srcPath = dmy.getFullPath().append(srcName);
            if (srcName.length() != 0 && !(status = workspace.validatePath(srcPath.toString(), 2)).isOK()) {
                String message = Messages.format(PreferencesMessages.NewPHPProjectPreferencePage_folders_error_invalidsrcname, status.getMessage());
                this.updateStatus(new StatusInfo(4, message));
                return;
            }
            IPath binPath = dmy.getFullPath().append(binName);
            if (binName.length() != 0 && !(status = workspace.validatePath(binPath.toString(), 2)).isOK()) {
                String message = Messages.format(PreferencesMessages.NewPHPProjectPreferencePage_folders_error_invalidbinname, status.getMessage());
                this.updateStatus(new StatusInfo(4, message));
                return;
            }
        }
        this.updateStatus(new StatusInfo());
    }

    protected boolean supportsProjectSpecificOptions() {
        return false;
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    private void controlChanged(Widget widget) {
        if (widget == this.fFoldersAsSourceFolder || widget == this.fProjectAsSourceFolder) {
            this.validateFolders();
        }
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(SRCBIN_FOLDERS_IN_NEWPROJ, false);
        store.setDefault(SRCBIN_SRCNAME, "application");
        store.setDefault(SRCBIN_BINNAME, "public");
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return false;
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fRadioButtons.size()) {
            Button button = (Button)this.fRadioButtons.get(i);
            String[] info = (String[])button.getData();
            button.setSelection(info[1].equals(store.getDefaultString(info[0])));
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            String key = (String)text.getData();
            text.setText(store.getDefaultString(key));
            ++i;
        }
        this.validateFolders();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fRadioButtons.size()) {
            Button button = (Button)this.fRadioButtons.get(i);
            if (button.getSelection()) {
                String[] info = (String[])button.getData();
                store.setValue(info[0], info[1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            String key = (String)text.getData();
            store.setValue(key, text.getText());
            ++i;
        }
        PHPUiPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    public void performApply() {
        this.performOk();
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.setDescription(null);
    }
}

