/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.SemanticHighlightingStyle;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.ISemanticHighlighting;
import org.eclipse.wst.sse.ui.ISemanticHighlightingExtension2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSemanticHighlighting
implements ISemanticHighlighting,
ISemanticHighlightingExtension2,
Comparable<AbstractSemanticHighlighting> {
    private ISourceModule sourceModule = null;
    private SemanticHighlightingStyle style = new SemanticHighlightingStyle(this.getPreferenceKey());
    private List<Position> list;
    private final String preferenceKey = this.getClass().getName();

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public SemanticHighlightingStyle getStyle() {
        return this.style;
    }

    public ISourceModule getSourceModule() {
        if (this.sourceModule == null) {
            throw new IllegalStateException("Source module cannot be null");
        }
        return this.sourceModule;
    }

    protected AbstractSemanticHighlighting highlight(ISourceRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Range cannot be null");
        }
        return this.highlight(range.getOffset(), range.getLength());
    }

    protected AbstractSemanticHighlighting highlight(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        return this.highlight(node.getStart(), node.getLength());
    }

    protected AbstractSemanticHighlighting highlight(int start, int length) {
        if (this.list == null) {
            throw new IllegalStateException();
        }
        this.list.add(new Position(start, length));
        return this;
    }

    public Position[] consumes(Program program) {
        if (program != null) {
            this.list = new ArrayList<Position>();
            this.sourceModule = program.getSourceModule();
            AbstractSemanticApply apply = this.getSemanticApply();
            program.accept((Visitor)apply);
            return this.list.toArray(new Position[this.list.size()]);
        }
        return new Position[0];
    }

    public Position[] consumes(IStructuredDocumentRegion region) {
        if (region.getStart() == 0) {
            Program program = this.getProgram(region);
            return this.consumes(program);
        }
        return new Position[0];
    }

    protected Program getProgram(final IStructuredDocumentRegion region) {
        this.sourceModule = null;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                PHPStructuredEditor phpStructuredEditor;
                IEditorPart editor;
                IWorkbenchPage page = PHPUiPlugin.getActivePage();
                if (page != null && (editor = page.getActiveEditor()) instanceof PHPStructuredEditor && (phpStructuredEditor = (PHPStructuredEditor)editor).getTextViewer() != null && phpStructuredEditor.getDocument() == region.getParentDocument()) {
                    AbstractSemanticHighlighting.this.sourceModule = (ISourceModule)phpStructuredEditor.getModelElement();
                }
            }
        });
        Program program = null;
        if (this.sourceModule != null) {
            try {
                program = SharedASTProvider.getAST(this.sourceModule, SharedASTProvider.WAIT_YES, null);
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return program;
    }

    public String getBoldPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".bold";
    }

    public String getColorPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".color";
    }

    public String getBackgroundColorPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".bgcolor";
    }

    public String getEnabledPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".enabled";
    }

    public String getItalicPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".italic";
    }

    public IPreferenceStore getPreferenceStore() {
        return PreferenceConstants.getPreferenceStore();
    }

    public String getStrikethroughPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".strikethrough";
    }

    public String getUnderlinePreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".underline";
    }

    public abstract AbstractSemanticApply getSemanticApply();

    public abstract void initDefaultPreferences();

    @Override
    public int compareTo(AbstractSemanticHighlighting highlighter) {
        return this.getPriority() - highlighter.getPriority();
    }

    public int getPriority() {
        return 100;
    }
}

