/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.PhpFormatter;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class PHPAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.text != null && c.text.length() > 1 && c.text.trim().length() > 1 && PHPAutoIndentStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            this.smartPaste(d, c);
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return PHPUiPlugin.getDefault().getPreferenceStore();
    }

    protected void smartPaste(IDocument document, DocumentCommand command) {
        StringBuffer helpBuffer;
        block10: {
            if (command.offset == -1 || document.getLength() == 0) {
                return;
            }
            helpBuffer = new StringBuffer();
            try {
                if (!(document instanceof IStructuredDocument)) break block10;
                DefaultIndentationStrategy.placeMatchingBlanksForStructuredDocument((IStructuredDocument)((IStructuredDocument)document), (StringBuffer)helpBuffer, (int)document.getLineOfOffset(command.offset), (int)command.offset);
                IRegion region = document.getLineInformation(document.getLineOfOffset(command.offset));
                if (document.get(region.getOffset(), region.getLength()).trim().length() == 0) {
                    if (command.offset != region.getOffset()) {
                        document.replace(region.getOffset(), region.getLength(), "");
                        command.offset = region.getOffset();
                    }
                    break block10;
                }
                return;
            }
            catch (BadLocationException badLocationException) {}
        }
        String start = "<?php\n";
        IStructuredModel model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForPHP.ContentTypeID_PHP);
        IStructuredDocument newdocument = model.getStructuredDocument();
        newdocument.set(String.valueOf(start) + command.text);
        PhpFormatter formatter = new PhpFormatter(0, newdocument.getLength());
        formatter.format((Node)((IDOMModel)model).getDocument());
        ArrayList<String> list = new ArrayList<String>();
        try {
            int lineNumber = newdocument.getNumberOfLines();
            int i = 1;
            while (i < lineNumber) {
                IRegion region = newdocument.getLineInformation(i);
                String line = newdocument.get(region.getOffset(), region.getLength());
                list.add(line);
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        String newline = newdocument.getLineDelimiter();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            sb.append(helpBuffer.toString()).append((String)list.get(i));
            if (i != list.size() - 1) {
                sb.append(newline);
            }
            ++i;
        }
        command.text = sb.toString();
        model.releaseFromEdit();
    }

    protected static boolean isSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = PHPUiPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 extension = (ITextEditorExtension3)part;
            return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }
}

