/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PHPWebPageURLLaunchDialog
extends MessageDialog {
    private static Set previousURLs = new TreeSet();
    private ILaunchConfigurationWorkingCopy launchConfiguration;
    private Combo combo;
    private final Server server;

    public PHPWebPageURLLaunchDialog(ILaunchConfigurationWorkingCopy launchConfiguration, Server server, String title) {
        super(PHPDebugUIPlugin.getActiveWorkbenchShell(), title, null, "", 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.launchConfiguration = launchConfiguration;
        this.server = server;
        this.message = "Note that no files will be published to the server.";
    }

    protected Control createCustomArea(Composite parent) {
        Object[] urls;
        Group group = new Group(parent, 0);
        group.setText("Launch URL");
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.combo = new Combo((Composite)group, 2052);
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        this.combo.setLayoutData((Object)data);
        Object[] objectArray = urls = previousURLs.toArray();
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.combo.add(element.toString());
            ++n2;
        }
        try {
            String selectedURL = this.launchConfiguration.getAttribute("base_url", "");
            int comboIndex = this.combo.indexOf(selectedURL);
            if (comboIndex > -1) {
                this.combo.select(comboIndex);
            } else {
                this.combo.add(selectedURL, 0);
                this.combo.select(0);
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String url = this.combo.getText().trim();
            previousURLs.add(url);
            try {
                if (!url.equals(this.launchConfiguration.getAttribute("base_url", ""))) {
                    this.launchConfiguration.setAttribute("auto_generated_url", false);
                }
            }
            catch (CoreException e) {
                Logger.logException((Throwable)e);
                this.launchConfiguration.setAttribute("auto_generated_url", false);
            }
            this.launchConfiguration.setAttribute("base_url", url);
        }
        super.buttonPressed(buttonId);
    }
}

