/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;

public class BreakpointSet {
    private IProject fProject;
    private ArrayList<String> fDirectories;
    private ArrayList<IProject> fProjects;

    public BreakpointSet(IProject project, boolean isPHPCGI) {
        this.fProject = project;
        this.fDirectories = new ArrayList();
        this.fProjects = new ArrayList();
        if (project != null) {
            IBuildpathEntry[] entries = null;
            try {
                entries = DLTKCore.create((IProject)project).getRawBuildpath();
            }
            catch (ModelException modelException) {}
            if (entries != null) {
                IBuildpathEntry[] iBuildpathEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    File file;
                    IPath path;
                    IBuildpathEntry element = iBuildpathEntryArray[n2];
                    if (element.getEntryKind() == 1) {
                        path = element.getPath();
                        file = new File(path.toOSString());
                        this.fDirectories.add(file.getAbsolutePath());
                    } else if (element.getEntryKind() == 2) {
                        IResource includeResource = ResourcesPlugin.getWorkspace().getRoot().findMember(element.getPath().lastSegment());
                        if (includeResource instanceof IProject) {
                            this.fProjects.add((IProject)includeResource);
                        }
                    } else if (element.getEntryKind() == 4 && (file = (path = DLTKCore.getResolvedVariablePath((IPath)element.getPath())).toFile()) != null && file.isDirectory()) {
                        this.fDirectories.add(file.getAbsolutePath());
                    }
                    ++n2;
                }
            }
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (this.fProject == null) {
            return true;
        }
        PHPLineBreakpoint bp = (PHPLineBreakpoint)breakpoint;
        IMarker marker = bp.getMarker();
        IResource resource = null;
        if (breakpoint instanceof PHPRunToLineBreakpoint) {
            return true;
        }
        resource = marker.getResource();
        if (resource instanceof IWorkspaceRoot) {
            return true;
        }
        IProject project = resource.getProject();
        return this.fProject.equals((Object)project) || this.fProjects.contains(project);
    }
}

