/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;

public class PHPRuntime {
    public static final String PHP_CONTAINER = "org.eclipse.php.debug.core.PHP_CONTAINER";
    public static final String ID_STANDARD_VM_TYPE = "org.eclipse.php.internal.debug.ui.launcher.StandardPHPType";

    public static IPath newDefaultPHPContainerPath() {
        return new Path(PHP_CONTAINER);
    }

    public static IPath newPHPContainerPath(PHPexeItem item) {
        return PHPRuntime.newPHPContainerPath(item.getDebuggerID(), item.getName());
    }

    public static IPath newPHPContainerPath(String typeId, String name) {
        IPath path = PHPRuntime.newDefaultPHPContainerPath();
        path = path.append(typeId);
        path = path.append(name);
        return path;
    }

    public static IPath newPHPContainerPath(PHPVersion version) {
        IPath path = PHPRuntime.newDefaultPHPContainerPath();
        path = path.append(ID_STANDARD_VM_TYPE);
        path = path.append(version.getAlias());
        return path;
    }

    public static PHPVersion getPHPVersion(IPath containerPath) {
        if (containerPath.segmentCount() == 3 && containerPath.segment(1).equals(ID_STANDARD_VM_TYPE)) {
            return PHPVersion.byAlias((String)containerPath.segment(2));
        }
        return null;
    }

    public static PHPexeItem getPHPexeItem(IPath containerPath) {
        if (containerPath.segmentCount() == 3) {
            return PHPexes.getInstance().getItem(containerPath.segment(1), containerPath.segment(2));
        }
        return null;
    }
}

