/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionStrategy;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.ClassInstantiationContext;
import org.eclipse.php.internal.core.codeassist.contexts.ExceptionClassInstantiationContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.ClassInstantiationStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.ExceptionClassInstantiationStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalConstantsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalFunctionsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalTypesStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceClassInstantiationStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceConstantsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceExceptionClassInstantiationStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceFunctionsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceTypesStrategy;

public class NamespaceElementsCompositeStrategy
extends AbstractCompletionStrategy {
    private final Collection<ICompletionStrategy> strategies = new ArrayList<ICompletionStrategy>();

    public NamespaceElementsCompositeStrategy(ICompletionContext context, ICompletionContext[] allContexts, boolean isGlobalNamespace) {
        super(context);
        boolean hasNewClassContext = false;
        boolean hasNewExceptionClassContext = false;
        ICompletionContext[] iCompletionContextArray = allContexts;
        int n = allContexts.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionContext c = iCompletionContextArray[n2];
            if (c instanceof ExceptionClassInstantiationContext) {
                hasNewExceptionClassContext = true;
                break;
            }
            if (c instanceof ClassInstantiationContext) {
                hasNewClassContext = true;
                break;
            }
            ++n2;
        }
        if (isGlobalNamespace) {
            if (hasNewClassContext) {
                this.strategies.add(new ClassInstantiationStrategy(context));
            } else if (hasNewExceptionClassContext) {
                this.strategies.add(new ExceptionClassInstantiationStrategy(context));
            } else {
                this.strategies.add(new GlobalTypesStrategy(context));
                this.strategies.add(new GlobalFunctionsStrategy(context));
                this.strategies.add(new GlobalConstantsStrategy(context));
            }
        } else if (hasNewClassContext) {
            this.strategies.add(new NamespaceClassInstantiationStrategy(context));
        } else if (hasNewExceptionClassContext) {
            this.strategies.add(new NamespaceExceptionClassInstantiationStrategy(context));
        } else {
            this.strategies.add(new NamespaceTypesStrategy(context));
            this.strategies.add(new NamespaceFunctionsStrategy(context));
            this.strategies.add(new NamespaceConstantsStrategy(context));
        }
    }

    public void apply(ICompletionReporter reporter) throws Exception {
        for (ICompletionStrategy strategy : this.strategies) {
            strategy.apply(reporter);
        }
    }
}

