/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceMemberContext;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceMembersStrategy;

public class NamespaceConstantsStrategy
extends NamespaceMembersStrategy {
    public NamespaceConstantsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public NamespaceConstantsStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof NamespaceMemberContext)) {
            return;
        }
        NamespaceMemberContext concreteContext = (NamespaceMemberContext)context;
        String prefix = concreteContext.getPrefix();
        String suffix = this.getSuffix(concreteContext);
        SourceRange replaceRange = this.getReplacementRange(concreteContext);
        IType[] iTypeArray = concreteContext.getNamespaces();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            try {
                IField[] iFieldArray = ns.getFields();
                int n3 = iFieldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IField field = iFieldArray[n4];
                    if (PHPFlags.isConstant(field.getFlags()) && CodeAssistUtils.startsWithIgnoreCase(field.getElementName(), prefix)) {
                        reporter.reportField(field, suffix, replaceRange, false);
                    }
                    ++n4;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        return "";
    }
}

