/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionContextResolver;
import org.eclipse.php.core.codeassist.ICompletionStrategy;
import org.eclipse.php.core.codeassist.ICompletionStrategyFactory;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.CompletionCompanion;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.codeassist.contexts.CompletionContextResolver;
import org.eclipse.php.internal.core.codeassist.strategies.CompletionStrategyFactory;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class PHPCompletionEngine
extends ScriptCompletionEngine
implements ICompletionReporter {
    private int relevanceKeyword;
    private int relevanceMethod;
    private int relevanceClass;
    private int relevanceVar;
    private int relevanceConst;
    private Set<? super Object> processedElements = new HashSet<Object>();
    private Set<? super Object> processedPaths = new HashSet<Object>();
    private Set<IField> processedFields = new TreeSet<IField>(new Comparator<IField>(){

        @Override
        public int compare(IField f1, IField f2) {
            if (PHPModelUtils.isSameField(f1, f2)) {
                return 0;
            }
            return f1.getElementName().compareTo(f2.getElementName());
        }
    });
    IModuleSource module;

    public void complete(IModuleSource module, int position, int i) {
        this.complete(module, position, i, true);
    }

    public void complete(IModuleSource module, int position, int i, boolean waitForBuilder) {
        if (!PHPCorePlugin.toolkitInitialized) {
            return;
        }
        if (this.requestor instanceof IPHPCompletionRequestor) {
            ((IPHPCompletionRequestor)this.requestor).setOffset(this.offset);
        }
        if (waitForBuilder) {
            ModelManager.getModelManager().getIndexManager().waitUntilReady();
        }
        this.module = module;
        this.relevanceKeyword = 10000000;
        this.relevanceMethod = 1000000;
        this.relevanceClass = 100000;
        this.relevanceVar = 10000;
        this.relevanceConst = 1000;
        try {
            ICompletionContextResolver[] contextResolvers = CompletionContextResolver.getActive();
            ICompletionStrategyFactory[] strategyFactories = CompletionStrategyFactory.getActive();
            CompletionCompanion companion = new CompletionCompanion();
            ISourceModule sourceModule = (ISourceModule)module.getModelElement();
            ICompletionContextResolver[] iCompletionContextResolverArray = contextResolvers;
            int n = contextResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionContextResolver resolver = iCompletionContextResolverArray[n2];
                ICompletionContext[] contexts = resolver.resolve(sourceModule, position, this.requestor, companion);
                if (contexts != null) {
                    ICompletionStrategyFactory[] iCompletionStrategyFactoryArray = strategyFactories;
                    int n3 = strategyFactories.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICompletionStrategyFactory factory = iCompletionStrategyFactoryArray[n4];
                        ICompletionStrategy[] strategies = factory.create(contexts);
                        if (strategies != null) {
                            ICompletionStrategy[] iCompletionStrategyArray = strategies;
                            int n5 = strategies.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                ICompletionStrategy strategy = iCompletionStrategyArray[n6];
                                strategy.init(companion);
                                try {
                                    strategy.apply(this);
                                }
                                catch (Exception e) {
                                    PHPCorePlugin.log(e);
                                    this.processedElements.clear();
                                    this.processedPaths.clear();
                                    return;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.processedElements.clear();
            this.processedPaths.clear();
        }
    }

    private int nextKeywordRelevance() {
        int relevance;
        if ((relevance = this.relevanceKeyword--) < 1) {
            relevance = 1;
        }
        return relevance;
    }

    private int nextMethodRelevance() {
        int relevance;
        if ((relevance = this.relevanceMethod--) < 1) {
            relevance = 1;
        }
        return relevance;
    }

    private int nextClassRelevance() {
        int relevance;
        if ((relevance = this.relevanceClass--) < 1) {
            relevance = 1;
        }
        return relevance;
    }

    private int nextVariableRelevance() {
        int relevance;
        if ((relevance = this.relevanceVar--) < 1) {
            relevance = 1;
        }
        return relevance;
    }

    private int nextConstantRelevance() {
        int relevance;
        if ((relevance = this.relevanceConst--) < 1) {
            relevance = 1;
        }
        return relevance;
    }

    public void reportField(IField field, String suffix, SourceRange replaceRange, boolean removeDollar) {
        if (this.processedFields.contains(field)) {
            return;
        }
        this.processedFields.add(field);
        int flags = 0;
        try {
            flags = field.getFlags();
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        int relevance = PHPFlags.isConstant(flags) ? this.nextConstantRelevance() : this.nextVariableRelevance();
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(1, this.actualCompletionPosition);
            proposal.setName(field.getElementName());
            String completion = String.valueOf(field.getElementName()) + suffix;
            if (removeDollar && completion.startsWith("$")) {
                completion = completion.substring(1);
            }
            proposal.setCompletion(completion);
            proposal.setModelElement((IModelElement)field);
            proposal.setFlags(flags);
            proposal.setRelevance(relevance);
            proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    public void reportKeyword(String keyword, String suffix, SourceRange replaceRange) {
        if (this.processedElements.contains(keyword)) {
            return;
        }
        this.processedElements.add(keyword);
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
            proposal.setName(keyword);
            proposal.setCompletion(String.valueOf(keyword) + suffix);
            proposal.setRelevance(this.nextKeywordRelevance());
            proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    public void reportMethod(IMethod method, String suffix, SourceRange replaceRange, Object extraInfo) {
        if (this.processedElements.contains(method)) {
            return;
        }
        this.processedElements.add(method);
        this.noProposal = false;
        if (!this.requestor.isIgnored(6)) {
            int relevance;
            CompletionProposal proposal;
            block8: {
                String elementName;
                proposal = this.createProposal(6, this.actualCompletionPosition);
                proposal.setExtraInfo(extraInfo);
                String[] params = null;
                try {
                    params = method.getParameterNames();
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                }
                if (params != null && params.length > 0) {
                    proposal.setParameterNames(params);
                }
                String completionName = elementName = method.getElementName();
                proposal.setModelElement((IModelElement)method);
                proposal.setName(elementName);
                relevance = this.nextMethodRelevance();
                proposal.setCompletion(String.valueOf(completionName) + suffix);
                try {
                    proposal.setIsConstructor(elementName.equals("__construct") || method.isConstructor());
                    proposal.setFlags(method.getFlags());
                }
                catch (ModelException e) {
                    if (!DEBUG) break block8;
                    e.printStackTrace();
                }
            }
            proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    public void reportMethod(IMethod method, String suffix, SourceRange replaceRange) {
        this.reportMethod(method, suffix, replaceRange, null);
    }

    public void reportType(IType type, String suffix, SourceRange replaceRange) {
        this.reportType(type, suffix, replaceRange, null);
    }

    public void reportType(IType type, String suffix, SourceRange replaceRange, Object extraInfo) {
        if (this.processedElements.contains(type)) {
            return;
        }
        this.processedElements.add(type);
        this.noProposal = false;
        if (!this.requestor.isIgnored(7)) {
            String elementName;
            CompletionProposal proposal = this.createProposal(7, this.actualCompletionPosition);
            proposal.setExtraInfo(extraInfo);
            if (this.requestor.isContextInformationMode()) {
                try {
                    IMethod[] iMethodArray = type.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        if (method.isConstructor()) {
                            String[] params = method.getParameterNames();
                            if (params != null && params.length > 0) {
                                proposal.setParameterNames(params);
                            }
                            break;
                        }
                        ++n2;
                    }
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                }
            }
            String completionName = elementName = type.getElementName();
            proposal.setModelElement((IModelElement)type);
            proposal.setName(elementName);
            int relevance = this.nextClassRelevance();
            proposal.setCompletion(String.valueOf(completionName) + suffix);
            try {
                proposal.setFlags(type.getFlags());
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    public void reportResource(IModelElement model, IPath relative, String suffix, SourceRange replaceRange) {
        if (this.processedElements.contains(model) || this.processedPaths.contains(relative)) {
            return;
        }
        this.processedElements.add(model);
        this.processedPaths.add(relative);
        this.noProposal = false;
        CompletionProposal proposal = null;
        if (model.getElementType() == 4 && !this.requestor.isIgnored(11)) {
            proposal = this.createProposal(11, this.actualCompletionPosition);
        } else if (model.getElementType() == 3) {
            proposal = this.createProposal(11, this.actualCompletionPosition);
        } else if (!this.requestor.isIgnored(2)) {
            proposal = this.createProposal(2, this.actualCompletionPosition);
        }
        proposal.setName(relative.toString());
        proposal.setCompletion(String.valueOf(relative.toString()) + suffix);
        proposal.setRelevance(this.nextKeywordRelevance());
        proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
        proposal.setModelElement(model);
        this.requestor.accept(proposal);
        if (DEBUG) {
            this.printDebug(proposal);
        }
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processMethodName(IMethod method, String token) {
        return method.getElementName();
    }

    protected String processTypeName(IType type, String token) {
        return type.getElementName();
    }

    public IModuleSource getModule() {
        return this.module;
    }
}

