/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Include
extends Expression {
    public static final int IT_REQUIRE = 0;
    public static final int IT_REQUIRE_ONCE = 1;
    public static final int IT_INCLUDE = 2;
    public static final int IT_INCLUDE_ONCE = 3;
    private Expression expression;
    private int includeType;
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(Include.class, "expression", Expression.class, true, true);
    public static final SimplePropertyDescriptor INCLUDE_TYPE_PROPERTY = new SimplePropertyDescriptor(Include.class, "includeType", Integer.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(2);
        propertyList.add(EXPRESSION_PROPERTY);
        propertyList.add(INCLUDE_TYPE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public Include(int start, int end, AST ast, Expression expr, int type) {
        super(start, end, ast);
        if (expr == null) {
            throw new IllegalArgumentException();
        }
        this.setExpression(expr);
        this.setIncludetype(type);
    }

    public Include(AST ast) {
        super(ast);
    }

    public static String getType(int type) {
        switch (type) {
            case 0: {
                return "require";
            }
            case 1: {
                return "require_once";
            }
            case 2: {
                return "include";
            }
            case 3: {
                return "include_once";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.expression.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expression.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.expression.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Include");
        this.appendInterval(buffer);
        buffer.append(" kind='").append(Include.getType(this.includeType)).append("'>\n");
        this.expression.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</Include>");
    }

    @Override
    public int getType() {
        return 36;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Expression getExpr() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    public int getIncludeType() {
        return this.includeType;
    }

    public final void setIncludetype(int value) {
        if (Include.getType(value) == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(INCLUDE_TYPE_PROPERTY);
        this.includeType = value;
        this.postValueChange(INCLUDE_TYPE_PROPERTY);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == INCLUDE_TYPE_PROPERTY) {
            if (get) {
                return this.getIncludeType();
            }
            this.setIncludetype(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        int type = this.getIncludeType();
        Expression expr = ASTNode.copySubtree(target, this.getExpression());
        Include result = new Include(this.getStart(), this.getEnd(), target, expr, type);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveInclude(this);
    }
}

