/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.presentation;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpThread;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.presentation.PHPModelPresentation;

public class XDebugModelPresentation
extends PHPModelPresentation
implements IDebugModelPresentation {
    protected String getStackFrameText(IStackFrame frame) {
        if (frame instanceof DBGpStackFrame) {
            try {
                DBGpThread thread = (DBGpThread)frame.getThread();
                DBGpStackFrame topFrame = (DBGpStackFrame)thread.getTopStackFrame();
                if (topFrame != null && topFrame.equals((Object)frame)) {
                    frame = topFrame;
                }
                StringBuffer buffer = new StringBuffer();
                String frameName = frame.getName();
                if (frameName != null && frameName.length() > 0) {
                    buffer.append(frame.getName());
                    buffer.append("() ");
                }
                buffer.append(((DBGpStackFrame)frame).getSourceName());
                buffer.append(String.valueOf(PHPDebugUIMessages.MPresentation_ATLine_1) + frame.getLineNumber());
                return buffer.toString();
            }
            catch (DebugException e) {
                Logger.logException(e);
            }
        }
        return "";
    }
}

